/*
  ******************************************************************************
  * @file    APP.c
  * @author  SAM
  * @version V1.0.0
  * @date    2021
  * @brief   WDT demo source code.
  ******************************************************************************
*/
#include "app.h"
#include "fxx_wdt.h"

volatile uint32_t g_IRQFlag = 0;
volatile uint32_t g_wdtRis = 0;

/*********************************************************************************
* Function    : APP_WDT_Test
* Description : 
* Input       : fe_Func
* Output      : None
**********************************************************************************/
void APP_WDT_Test(enum_WDT_FUNC_t fe_Func)
{
    uint32_t resetReason;

    switch (fe_Func)
    {
        /* WDTжϹ */
        case WDT_Interrupt: 
        {
            /* ʹWDTλϵͳ */
            System_Enable_Disable_Reset(RESET_ENABLE_SOURCE_WDT, FUNC_ENABLE);
            
            WDT_DeInit();
            
            /* ʹWDTʱ */
            System_Module_Enable(EN_WDT);
            /* 128Ƶ */
            WDT_SetPrescaler(WDT_CLOCK_PRESCALER_128);
            /* Ϊжģʽ */
            WDT_SetMode(WDT_MODE_INTERRUPT);
            /*  Relaod */
            WDT_SetLoadValue(3000 * ((System_Get_APBClock() / 128) / 1000));   // 3000ms
            /* жʱ */
            WDT_SetITClrTime(5 * ((System_Get_APBClock() / 128) / 1000));    // 50ms
            
            printfS("WDT interrupt period : 3000 ms.\r\n");
            printfS("If the WDT feed dog fails, the system will be reset.\r\n");
    
            // Enable NVIC IRQ
            NVIC_ClearPendingIRQ(WDT_IRQn);
            NVIC_SetPriority(WDT_IRQn, 0x03);
            NVIC_EnableIRQ(WDT_IRQn);
            
            /* ʹж */
            WDT_ITCmd(WDT_INTERRUPT_ENABLE);
            
            /* Źʹ */
            WDT_Cmd(WDT_ENABLE);
            
            g_IRQFlag = 0;
            g_wdtRis = 0;
            
            while(1)
            {
                if(g_IRQFlag)
                {
                    g_IRQFlag = 0;
                    printfS("WDT Interrupt occurs, WDT->RIS = %d\r\n", g_wdtRis);
                    g_wdtRis = 0;
                }
            }
            
        }break;

        /* WDTλ */
        case WDT_Reset:
        {
            resetReason = System_Return_Last_Reset_Reason();
            printfS("System Return Last Reset Reason is %d\r\n", resetReason);
            if(resetReason == RESET_REASON_WDT)
            {
                resetReason = 0;
                printfS("System WDT reset\r\n");
            }
           /* ʹWDTλϵͳ */
            System_Enable_Disable_Reset(RESET_ENABLE_SOURCE_WDT, FUNC_ENABLE);
            
            WDT_DeInit();
            
            /* ʹWDTʱ */
            System_Module_Enable(EN_WDT);
            /* 128Ƶ */
            WDT_SetPrescaler(WDT_CLOCK_PRESCALER_128);
            /* Ϊλģʽ */
            WDT_SetMode(WDT_MODE_RESET);
            /*  Relaod */
            WDT_SetLoadValue(3000 * ((System_Get_APBClock() / 128) / 1000));   // 500ms
            /* жʱ */
            WDT_SetITClrTime(5 * ((System_Get_APBClock() / 128) / 1000));    // 50ms
            
            printfS("WDT reset period : 3000 ms.\r\n");
            printfS("Without WDT feed dog fails, the system will be reset.\r\n");
   
            /* Źʹ */   
            WDT_Cmd(WDT_ENABLE);       
            
            while(1)
            {

            }
        }break;

       
        
        default: break; 
    }
}
