/*
  ******************************************************************************
  * @file    APP.h
  * @author  Chris_Kyle
  * @version V1.0.0
  * @date    2020
  * @brief   GPIO demo Header file.
  ******************************************************************************
*/
#ifndef __APP_H__
#define __APP_H__

#include "fxx_std.h"

#define DMA_TX_SIZE         256
#define UART_TX_BUF_SIZE	512
#define UART_RX_BUF_SIZE	512

typedef struct
{
	UART_TypeDef *uart;	            /* ӦĴָ */	
	uint8_t *pTxBuf;			    /* ͻ */
	uint8_t *pRxBuf;			    /* ջ */
	uint32_t lu32_TxBufSize;	    /* ͻС */
	uint32_t lu32_RxBufSize;	    /* ջС */
	uint32_t lu32_TxWrite;		    /* ͻдָ */
	uint32_t lu32_TxRead;		    /* ͻָ */
	uint32_t lu32_RxWrite;		    /* ջдָ */
	uint32_t lu32_RxRead;		    /* ջָ */
	void (*SendOverFunc)(void); 	/* ϵĻصָ */
	void (*ReciveNewFunc)(void);	/* յݵĻصָ */
}Type_UART_t;



typedef enum
{
    TEST_LOOP,
    TEST_UART_IT,
    TEST_DMA
}enum_TEST_MODE_t;

//vars
extern Type_UART_t g_UART2Handle;

//functions
void UartSend(enum_TEST_MODE_t fe_Mode,Type_UART_t *pUart, uint8_t *SendBuf, uint32_t DataLen);

void UartIRQ(Type_UART_t *pUart);

void APP_Uart_Test(enum_TEST_MODE_t fe_Mode);

#endif
