/*
  ******************************************************************************
  * @ app.h
  *  Time base Demo source code.
  ******************************************************************************
*/
#include "app.h"

#define PWM_OUTPUT_CHANNEL1    TIM_CHANNEL_1   

#define TIM_CLOCK_FREQ            (8000000U)    

TIM_Base_InitTypeDef TIM_TimeBaseStructure;    
TIM_OC_InitTypeDef Tim_OC_Init_Para;     


void Clock_Configuration(void);
void GPIO_Configuration(void);
void NVIC_Configuration(void);   

void NVIC_Configuration(void)
{
    // do nothing here 
} 

void Clock_Configuration(void)
{
    System_Module_Enable(EN_TIM1);   
}  

GPIO_InitTypeDef gpio_init;  
void GPIO_Configuration(void)  
{	
	gpio_init.Pin = GPIO_PIN_8;  //TIM1_CH1  
	gpio_init.Mode = GPIO_MODE_AF_PP;          
	gpio_init.Pull = GPIO_NOPULL;    
	gpio_init.Alternate = GPIO_FUNCTION_2;         
	GPIO_Init(GPIOC, &gpio_init);    // PC8     
}


void TIM1_Init(void)  
{
    uint32_t timer_clock;    
    
    timer_clock = System_Get_APBClock();     
    if (System_Get_SystemClock() != System_Get_APBClock())  // if hclk/pclk != 1, then timer clk = pclk * 2  
    {
       timer_clock =  System_Get_APBClock() << 1;    
    }
    
	TIM_TimeBaseStructure.ClockDivision = TIM_CLOCKDIVISION_DIV1; 
	TIM_TimeBaseStructure.CounterMode = TIM_COUNTERMODE_UP; 
	TIM_TimeBaseStructure.RepetitionCounter = 0;  
	TIM_TimeBaseStructure.Prescaler = (timer_clock/TIM_CLOCK_FREQ) - 1;  
    if (timer_clock%TIM_CLOCK_FREQ > TIM_CLOCK_FREQ/2) 
	{
		TIM_TimeBaseStructure.Prescaler = TIM_TimeBaseStructure.Prescaler + 1;  
	}
	TIM_TimeBaseStructure.Period = (TIM_CLOCK_FREQ/1000000)*10 - 1;  // period = 10us       	    
	TIM_TimeBase_Init(TIM1, &TIM_TimeBaseStructure);        
    
	Tim_OC_Init_Para.OCMode = OUTPUT_MODE_PWM1;  
	Tim_OC_Init_Para.OCIdleState = OUTPUT_IDLE_STATE_0;
	Tim_OC_Init_Para.OCNIdleState = OUTPUT_IDLE_STATE_0;      
	Tim_OC_Init_Para.OCPolarity = OUTPUT_POL_ACTIVE_HIGH;  
	Tim_OC_Init_Para.OCNPolarity = OUTPUT_POL_ACTIVE_HIGH;    
	Tim_OC_Init_Para.OCFastMode =  OUTPUT_FAST_MODE_DISABLE;  
	Tim_OC_Init_Para.Pulse = (TIM_TimeBaseStructure.Period + 1)/2;   // 50% duty cycle   	
	TIM_OC1Init(TIM1, &Tim_OC_Init_Para);             
             
}


/*********************************************************************************
* Function    : Timer_PWM_Output_Test      
* Description : test function ,output period=10us 50% duty PWM waveform  
* Input       : none    
* Output      : none 
* Author      : xwl                       
**********************************************************************************/  
void Timer_PWM_Output_Test(void)   
{
    Clock_Configuration();    
    GPIO_Configuration();   
    
	TIM1_Init(); 
    
    TIM_CCxCmd(TIM1, TIM_CHANNEL_1, TIM_CCx_Enable);       
    /* TIM1 enable counter */    
    TIM_Cmd(TIM1, ENABLE);   
    
    /* Main Output Enable */  
    TIM_CtrlPWMOutputs(TIM1, ENABLE);            
    
    
	while(1)   
	{

	}
}


