/*
  ******************************************************************************
  * @file    fxx_it.c
  * @brief   fxx_it source File.
  ******************************************************************************
*/

#include "fxx_it.h"

         
volatile uint16_t Capture_data[CHANNEL_NUMBER][CAPTURE_TIMES_TOTAL];      
volatile uint32_t capture_times;  

/************************************************************************
 * function   : TIM1_CC_IRQHandler
 * Description: TIM1 capture and compare Interrupt Handler 
 ************************************************************************/ 
void TIM1_CC_IRQHandler(void)  
{
    uint32_t status; 
    
    status = TIM1->SR;  
    
    if ( (status & TIMER_SR_CC1IF) && ((TIM1->CCMR1) & (BIT0|BIT1)) ) 
    {
       Capture_data[0][capture_times] = TIM1->CCR1;  
    }
    
    if ((status & TIMER_SR_CC2IF)  && ((TIM1->CCMR1) & (BIT8|BIT9))  )     
    {
       Capture_data[1][capture_times] = TIM1->CCR2;  
    }
    
    capture_times++;    
    
    NVIC_ClearPendingIRQ(TIM1_CC_IRQn);    
    
}


