/*
  ******************************************************************************
  * @ app.h
  *  Time synchro Demo source code.
  ******************************************************************************
*/
#include "app.h"  

#define PERIOD_MAX_VALUE   0xFFFFU    

TIM_Base_InitTypeDef TIM_Time1BaseStructure;    
TIM_Base_InitTypeDef TIM_Time3BaseStructure;   
TIM_OC_InitTypeDef Tim_Time3_OC_Init_Para;     


void Clock_Configuration(void);
void GPIO_Configuration(void);
void NVIC_Configuration(void);   

void NVIC_Configuration(void)
{
    // do nothing here 
} 

void Clock_Configuration(void)
{
    System_Module_Enable(EN_TIM1);     
    System_Module_Enable(EN_TIM3);       
}  


void GPIO_Configuration(void)  
{	
    GPIO_InitTypeDef gpio_init;  
    
	gpio_init.Pin = GPIO_PIN_8;  //TIM1_CH1  
	gpio_init.Mode = GPIO_MODE_AF_PP;          
	gpio_init.Pull = GPIO_PULLUP;    
	gpio_init.Alternate = GPIO_FUNCTION_2;         
	GPIO_Init(GPIOC, &gpio_init);    // PC8       
    
    gpio_init.Pin = GPIO_PIN_7;  //TIM3_CH2  PA7  
	gpio_init.Mode = GPIO_MODE_AF_PP;     
	gpio_init.Pull = GPIO_PULLUP;    
	gpio_init.Alternate = GPIO_FUNCTION_2;       
	GPIO_Init(GPIOA, &gpio_init);  	   
}

//PC8 high, TIM1 runs; PC8 low, TIM1 stops    
void TIM1_Init(void)  
{
	TIM_Time1BaseStructure.ClockDivision = TIM_CLOCKDIVISION_DIV1; 
	TIM_Time1BaseStructure.CounterMode = TIM_COUNTERMODE_UP; 
	TIM_Time1BaseStructure.RepetitionCounter = 0;  
	TIM_Time1BaseStructure.Prescaler = 0;   

	TIM_Time1BaseStructure.Period = PERIOD_MAX_VALUE;  	    
	TIM_TimeBase_Init(TIM1, &TIM_Time1BaseStructure);        
     
    TIM_SelectOutputTrigger(TIM1, TIM_TRGO_ENABLE);            	
	TIM_SelectMasterSlaveMode(TIM1, TIM_MASTERSLAVEMODE_ENABLE);      
    
    TIM_SelectInputTrigger(TIM1, TIM_TRIGGER_SOURCE_TI1FP1);
    TIM_SelectSlaveMode(TIM1, TIM_SLAVE_MODE_GATE);   
    TIM_TI1FP1_ConfigInputStage(TIM1, TIM_SLAVE_CAPTURE_ACTIVE_RISING, TIM_TI1_FILTER_LVL(0));    
}

//PA7 output
//TIM1 runs, then PA7 output pwm; TIM1 stops, PA7 output constant high or low 
void TIM3_Init(void)  
{
	TIM_Time3BaseStructure.ClockDivision = TIM_CLOCKDIVISION_DIV1; 
	TIM_Time3BaseStructure.CounterMode = TIM_COUNTERMODE_UP; 
	TIM_Time3BaseStructure.RepetitionCounter = 0;  
	TIM_Time3BaseStructure.Prescaler = 0;   

	TIM_Time3BaseStructure.Period = PERIOD_MAX_VALUE;  	    
	TIM_TimeBase_Init(TIM3, &TIM_Time3BaseStructure);    

    TIM_SelectInputTrigger(TIM3, TIM_TRIGGER_SOURCE_ITR0);
    TIM_SelectSlaveMode(TIM3, TIM_SLAVE_MODE_GATE); 
	
	Tim_Time3_OC_Init_Para.OCMode = OUTPUT_MODE_PWM1;  
	Tim_Time3_OC_Init_Para.OCIdleState = OUTPUT_IDLE_STATE_0;
	Tim_Time3_OC_Init_Para.OCNIdleState = OUTPUT_IDLE_STATE_0;      
	Tim_Time3_OC_Init_Para.OCPolarity = OUTPUT_POL_ACTIVE_HIGH;  
	Tim_Time3_OC_Init_Para.OCNPolarity = OUTPUT_POL_ACTIVE_HIGH;    
	Tim_Time3_OC_Init_Para.OCFastMode =  OUTPUT_FAST_MODE_DISABLE;  
	Tim_Time3_OC_Init_Para.Pulse = ((TIM_Time3BaseStructure.Period) + 1) / 2;   // 50% duty cycle        	   
	TIM_OC2Init(TIM3, &Tim_Time3_OC_Init_Para);       
}

/*********************************************************************************
* Function    : Timer_Synchro_Test      
* Description : test function 
* Input       : none    
* Output      : none 
* Author      : xwl                       
**********************************************************************************/  
void Timer_Synchro_Test(void)   
{
    Clock_Configuration();    
    GPIO_Configuration();   
    
	TIM1_Init(); 
    
    TIM3_Init();     
    
    /* TIM3 enable output */  
    TIM_CCxCmd(TIM3, TIM_CHANNEL_2, TIM_CCx_Enable);  
    /* TIM3 enable counter */       
    TIM_Cmd(TIM3, ENABLE);      
        
    /* TIM1 enable counter */     
    TIM_Cmd(TIM1, ENABLE);       
                
	while(1)   
	{

	}
}


