#include  "demo.h"
#include  "bsp_spi.h"

uint8_t test_buf_1[1024*8] PSRAM;

bool debug = true;
volatile uint32_t test_buf[10] PSRAM;
#define BUF_LEN  1024
uint8_t TxBuffer[BUF_LEN];
uint8_t RxBuffer[BUF_LEN];

volatile uint8_t temp;
void SysTick_Handler(void)
{
    gu32_SystemCount++;
#if (__ACCELERATE_EH_PRESENT == 1)   
    //System_CleanInvalidateDAccelerate_by_Addr((uint32_t*)0x90000000, 1);
    
    __DSB();
      SCB->DCCIMVAC = 0x90000000;
    __DSB();
    __ISB();
#endif    
    temp = *(uint8_t *)0x90000000;  /* PSRAM׵ַռһֽ */
}

void msg_result(uint8_t err)
{
    if(err)
        printfS("[FAILED]\r\n");
    else
        printfS("[PASS]\r\n");
}

void hexdump_8(uint8_t *buf, uint32_t len)
{
    uint32_t i;
    for(i = 0; i < len; i++)
        printfS("%02X ", buf[i]);
    printfS("\r\n");
}

void psram_demo_test(void)
{
    uint16_t id;
    uint8_t eid[6];
    uint8_t err = 0;
    uint32_t i;
    uint32_t *paddr = (uint32_t*)&test_buf_1[0];
    
    printfS("PSRAM demo\r\n\r\n");   
    
    IC_APS1604M_Init(SPI3, DMA_Channel0, DMA_Channel1);
    
    id = IC_APS1604M_Read_ID(&eid[0]);
    printfS("id = %02X ", (id >> 8) & 0xFF);
    printfS("%02X ", (id) & 0xFF);
    hexdump_8(eid, 6);

    
    printfS("%-40s", "PSRAM FIFO read/write 1x mode");
    for(i = 0; i < BUF_LEN; i++)
        TxBuffer[i] = 1 + i;
        
    IC_APS1604M_Write((uint32_t)&test_buf_1[0], TxBuffer, BUF_LEN);
    
    IC_APS1604M_Read((uint32_t)&test_buf_1[0], RxBuffer, BUF_LEN);
    
    for(i = 0; i < BUF_LEN; i++)
    {
        if(TxBuffer[i] != RxBuffer[i])
        {
            err = 1;
            break;
        }
    }    
    msg_result(err);
    
    
    /////////////////////////////////////////////////////////
    /*
        xip read write
    */
    printfS("%-40s", "PSRAM XIP read/write");
    err = 0;
    memset(RxBuffer, 0, BUF_LEN);
    paddr = (uint32_t*)&test_buf_1[0];
    for(i = 0; i < BUF_LEN; i++)
        TxBuffer[i] = 2 + i;
    
    for(i = 0; i < BUF_LEN; i += 4)
    {
        /* XIP write only support word write*/
        *paddr++ = *(uint32_t*)&TxBuffer[i];
    }
    
    for(i = 0; i < BUF_LEN; i++)
    {
        RxBuffer[i] = test_buf_1[i];
    }
    
    for(i = 0; i < BUF_LEN; i++)
    {
        if(TxBuffer[i] != RxBuffer[i])
        {
            err = 1;
            break;
        }
    }
    msg_result(err);
    
    
    ////////////////////////////////////////////////////////
    printfS("%-40s", "PSRAM FIFO read/write 4x mode");
    err = 0;
    memset(RxBuffer, 0, BUF_LEN);
    
    for(i = 0; i < BUF_LEN; i++)
        TxBuffer[i] = 3 + i;

    IC_APS1604M_QPI_Write((uint32_t)&test_buf_1[0], TxBuffer, BUF_LEN);

    IC_APS1604M_QPI_Read((uint32_t)&test_buf_1[0], RxBuffer, BUF_LEN);
    
    for(i = 0; i < BUF_LEN; i++)
    {
        if(TxBuffer[i] != RxBuffer[i])
        {
            err = 1;
            break;
        }
    }
    msg_result(err);
    
    /////////////////////////////////////////////////////////////////////////////////////////////
    printfS("%-40s", "PSRAM FIFO DMA read/write 1x mode");
    err = 0;
    memset(RxBuffer, 0, BUF_LEN);
    
    for(i = 0; i < BUF_LEN; i++)
            TxBuffer[i] = 4 + i;
    
    IC_APS1604M_DMA_Write((uint32_t)&test_buf_1[0], TxBuffer, BUF_LEN);
    
    IC_APS1604M_DMA_Read((uint32_t)&test_buf_1[0], RxBuffer, BUF_LEN);
    
    for(i = 0; i < BUF_LEN; i++)
    {
        if(TxBuffer[i] != RxBuffer[i])
        {
            err = 1;
            break;
        }
    }
    msg_result(err);
    
    
    ////////////////////////////////////////////////////////
    printfS("%-40s", "PSRAM FIFO read/write 4x mode");
    err = 0;
    memset(RxBuffer, 0, BUF_LEN);
        
    if(debug == true)
    {
        for(i = 0; i < BUF_LEN; i++)
            TxBuffer[i] = 5 + i;
    
        IC_APS1604M_QPI_Write((uint32_t)&test_buf_1[0], TxBuffer, BUF_LEN);
    
        IC_APS1604M_QPI_Read((uint32_t)&test_buf_1[0], RxBuffer, BUF_LEN);
    }
    
    for(i = 0; i < BUF_LEN; i++)
    {
        if(TxBuffer[i] != RxBuffer[i])
        {
            err = 1;
            break;
        }
    }
    msg_result(err);
    
    
    /////////////////////////////////////////////////////////////////////////////////////////////
    printfS("%-40s", "PSRAM FIFO DMA read/write 1x mode");
    err = 0;
    memset(RxBuffer, 0, BUF_LEN);  
    for(i = 0; i < BUF_LEN; i++)
            TxBuffer[i] = 6 + i;
    
    IC_APS1604M_DMA_Write((uint32_t)&test_buf_1[0], TxBuffer, BUF_LEN);
    
    IC_APS1604M_DMA_Read((uint32_t)&test_buf_1[0], RxBuffer, BUF_LEN);
    
    for(i = 0; i < BUF_LEN; i++)
    {
        if(TxBuffer[i] != RxBuffer[i])
        {
            err = 1;
            break;
        }
    }
    msg_result(err);
    
    
    ////////////////////////////////////////////////////////////////////////////////////////////    
    printfS("%-40s", "PSRAM FIFO DMA read/write 4x mode");
    err = 0;
    memset(RxBuffer, 0, BUF_LEN);
    for(i = 0; i < BUF_LEN; i++)
            TxBuffer[i] = 7 + i;
    
    IC_APS1604M_QPI_DMA_Write((uint32_t)&test_buf_1[0], TxBuffer, BUF_LEN);
    
    IC_APS1604M_QPI_DMA_Read((uint32_t)&test_buf_1[0], RxBuffer, BUF_LEN);
    
    for(i = 0; i < BUF_LEN; i++)
    {
        if(TxBuffer[i] != RxBuffer[i])
        {
            err = 1;
            break;
        }
    }
    msg_result(err);
    
    
    ////////////////////////////////////////////////////////
    printfS("%-40s", "PSRAM FIFO read/write 4x mode");
    err = 0;
    memset(RxBuffer, 0, BUF_LEN);
        
    if(debug == true)
    {
        for(i = 0; i < BUF_LEN; i++)
            TxBuffer[i] = 8 + i;
    
        IC_APS1604M_QPI_Write((uint32_t)&test_buf_1[0], TxBuffer, BUF_LEN);
    
        IC_APS1604M_QPI_Read((uint32_t)&test_buf_1[0], RxBuffer, BUF_LEN);
    }
    
    for(i = 0; i < BUF_LEN; i++)
    {
        if(TxBuffer[i] != RxBuffer[i])
        {
            err = 1;
            break;
        }
    }
    msg_result(err);
    
    ////////////////////////////////////////////////////////////////////////////////////////////    
    printfS("%-40s", "PSRAM FIFO DMA read/write 4x mode");
    err = 0;
    memset(RxBuffer, 0, BUF_LEN);
    for(i = 0; i < BUF_LEN; i++)
            TxBuffer[i] = 9 + i;
    
    IC_APS1604M_QPI_DMA_Write((uint32_t)&test_buf_1[0], TxBuffer, BUF_LEN);
    
    IC_APS1604M_QPI_DMA_Read((uint32_t)&test_buf_1[0], RxBuffer, BUF_LEN);
    
    for(i = 0; i < BUF_LEN; i++)
    {
        if(TxBuffer[i] != RxBuffer[i])
        {
            err = 1;
            break;
        }
    }
    msg_result(err);
    
    //////////////////////////////////////////////////////////////////////////////////////////// 
    printfS("%-40s", "PSRAM FIFO DMA read/write 1x mode");
    err = 0;
    memset(RxBuffer, 0, BUF_LEN);    
    for(i = 0; i < BUF_LEN; i++)
            TxBuffer[i] = 10 + i;
    
    IC_APS1604M_DMA_Write((uint32_t)&test_buf_1[0], TxBuffer, BUF_LEN);
    
    IC_APS1604M_DMA_Read((uint32_t)&test_buf_1[0], RxBuffer, BUF_LEN);
    
    for(i = 0; i < BUF_LEN; i++)
    {
        if(TxBuffer[i] != RxBuffer[i])
        {
            err = 1;
            break;
        }
    }
    msg_result(err);
    
    /////////////////////////////////////////////////////////
    /*
        xip read write
    */
    printfS("%-40s", "PSRAM XIP read/write");
    err = 0;
    paddr = (uint32_t*)&test_buf_1[0];
    memset(RxBuffer, 0, BUF_LEN);
    for(i = 0; i < BUF_LEN; i++)
        TxBuffer[i] = 11 + i;
    
    for(i = 0; i < BUF_LEN; i += 4)
    {
        /* XIP write only support word write*/
        *paddr++ = *(uint32_t*)&TxBuffer[i];
    }
    
    for(i = 0; i < BUF_LEN; i++)
    {
        RxBuffer[i] = test_buf_1[i];
    }
    
    for(i = 0; i < BUF_LEN; i++)
    {
        if(TxBuffer[i] != RxBuffer[i])
        {
            err = 1;
            break;
        }
    }
    msg_result(err);
    
}


