#include "fxx_std.h"

/*
 * @brief  SPI Status structures definition
 */
typedef enum
{
    SPI_OK       = 0x00U,
    SPI_ERROR    = 0x01U,
    SPI_BUSY     = 0x02U,
    SPI_TIMEOUT  = 0x03U
}SPI_StatusTypeDef;

typedef struct
{ 
    uint32_t               RxState;          /* SPI state machine */
    uint32_t               TxState;          /* SPI state machine */
    
    uint8_t               *Rx_Buffer;        /* SPI Rx Buffer */
    uint8_t               *Tx_Buffer;        /* SPI Tx Buffer */
    
    uint32_t               Rx_Size;          /* SPI Rx Size */
    uint32_t               Tx_Size;          /* SPI Tx Size */
    
    uint32_t               Rx_Count;         /* SPI RX Count */
    uint32_t               Tx_Count;         /* SPI TX Count */
}SPI_DataTypeDef;

void Spi_Gpio_Init(void);
void Spi_Init(void);
SPI_StatusTypeDef SPI_Transmit(uint8_t *pData, uint32_t Size, uint32_t Timeout);
SPI_StatusTypeDef SPI_Receive(uint8_t *pData, uint32_t Size, uint32_t Timeout);
SPI_StatusTypeDef SPI_Transmit_DMA(uint8_t *pData, uint32_t Size);
SPI_StatusTypeDef SPI_Receive_DMA(uint8_t *pData, uint32_t Size);
SPI_StatusTypeDef SPI_Transmit_IT(uint8_t *pData, uint32_t Size);
SPI_StatusTypeDef SPI_Receive_IT(uint8_t *pData, uint32_t Size);
SPI_StatusTypeDef SPI_TransmitReceive(uint8_t *pTxData, uint8_t *pRxData, uint32_t Size, uint32_t Timeout);
uint8_t SPI_GetTxState(void);
uint8_t SPI_GetRxState(void);
void SPI_IRQProcess(void);
