/*
  ******************************************************************************
  * @file    APP.c
  * @author  PJ
  * @version V1.0.0
  * @date    2021
  * @brief   RTC demo source code.
  ******************************************************************************
*/
#include "app.h"



void Delay_Sram(volatile uint32_t fu32_Delay)
{
    fu32_Delay *= 5000;
    
    while (fu32_Delay--);
}


void LowPower_STOP(void)
{
    /* رж */
    __set_PRIMASK(1);
    /* رSystickж */     
    SysTick->CTRL &= ~SysTick_CTRL_TICKINT_Msk;
    /* SystickжϹ־ */    
    SCB->ICSR = BIT25;
    
    /* PA0 ػ */
    SCU->PABADS &= ~(1 << 0);
    
    SCU->IPCKENR2 |= BIT4;
    EXTI->EENR  |= 1 << 0;
    EXTI->RTENR |= 1 << 0;
    
    /* ʱԴѡΪRC64M */
    SCU->RCHCR |=  SCU_RCHCR_RCH_EN; 
    while(0 == (SCU->RCHCR & SCU_RCHCR_RCHRDY));  // wait RCH ready 

    SCU->CCR2=((SCU->CCR2) & (~(SCU_CCR2_SYSDIV0 | SCU_CCR2_SYSDIV1 | SCU_CCR2_PCLKDIV)));
    while((SCU->CCR2 & SCU_CCR2_DIVDONE) == 0x00);//wait for done
    
    SCU->CCR1 = 0;  // select RC64M as default 
    SCU->RCHCR &= ~(1 << 8);
    
    SCU->PLLCR &= ~0x01;
    SCU->PLLCR |= (1 << 21);
 
    /* All Clock Disable */
    SCU->CLKOCR &= ~(1ul << 31);    // Buzzer2 Disable
    SCU->CLKOCR &= ~(1ul << 23);    // Buzzer1 Disable
    
    /* رPLLXTHXTL32Kʱ  */
    SCU->XTHCR &= ~(1 << 0);    // XTH Disable
    SCU->PLLCR &= ~(1 << 0);    // PLL Disable
    
    SCU->STOPCFG |= (1 << 0);    // RTCдʹ
    PMU->ANACR &= ~(1 << 0);     // XTL Disable
    PMU->ANACR &= ~(1 << 8);     // RC32K Disable

    /* RTCCLK Disable */
    PMU->CR1 &= ~(1 << 5);

    /* LVD Disable */
    SCU->LVDCFG &= ~(1 << 0);
    
    /* LDO17رգѺҪ */
    SCU->LDOCR &= ~(1 << 9);
    SCU->LDOCR &= ~(1 << 14);
    
    /* Eflash Sleep */
    EFC->CTRL |= (1 << 12);
    Delay_Sram(1);
    
    /* رղҪSram */
    //SCU->MEMCFG = ~2;

    /* STOP ģʽ¹رLDO12RC64M */    
    SCU->STOPCFG |= 1 << 8;//RCHѡ16Ƶ
    SCU->STOPCFG |= 1 << 3;//RCHRC64MǷԶر
    
    /* STOPģʽǰҪMLDO12ѹԶ(MLDO12LV)Ϊ1.0VԼСرMLDO12ĵѹ */
    SCU->STOPCFG &= ~(3 << 4);
    SCU->STOPCFG |= (1 << 4);//MLDO12Ϊ1.0V
    
    SCU->STOPCFG |= 1 << 9;//LPLSTOPģʽ
    
    SCU->STOPCFG &= (~BIT11);  // PDDS=0   

    /* Set SLEEPDEEP bit of Cortex System Control Register */
    SET_BIT(SCB->SCR, ((uint32_t)SCB_SCR_SLEEPDEEP_Msk)); 


    __SEV();   
    __WFE();
    __WFE();    /* Wait For Event */  
   

    CLEAR_BIT(SCB->SCR, ((uint32_t)SCB_SCR_SLEEPDEEP_Msk));
    
    SCU->STOPCFG &= ~(1 << 3);//RCHRC64MԶر
    SCU->STOPCFG &= ~(1 << 8);//RCHѡԭʼƵ
    
    SCU->STOPCFG &= ~(3 << 4);//MLDO12Ϊ1.2V    
    /* Ѻ󣬴LDO17V */
    SCU->LDOCR |= 1 << 9;
    SCU->LDOCR |= 1 << 14;
    
    EFC->CTRL &= ~(1<<12);
    
    Delay_Sram(50);
    
    /* ʹSystickж */
    SysTick->CTRL |= SysTick_CTRL_TICKINT_Msk; 
    /* ʹȫж */    
    __set_PRIMASK(0);
    
}
