/*
  ******************************************************************************
  * @file    APP.c
  * @author  PJ
  * @version V1.0.0
  * @date    2021
  * @brief   OPA demo source code.
  ******************************************************************************
*/
#include "app.h"

OPAMP_InitTypeDef OPA2_Handle;
void OPA_GPIO_Init(void);
/******************************************************************************
*@brief : OPA Initiation as PGA mode. 
*@return: none
******************************************************************************/
void OPA_Init_PGA(void)
{ 

    OPA2_Handle.Hsm = OPA_HSM_HIGH;
    OPA2_Handle.OPAMP_NonInvertingInput = OPA2_VINP_PA7;
    OPA2_Handle.OPAMP_InvertingInput = OPA_VINN_INVERT_PGA;
    OPA2_Handle.OutSel = OPA_OUT_GPIO;
    OPAMP_Init(OPAMP_Selection_OPAMP2,&OPA2_Handle);
    
}

/******************************************************************************
*@brief : OPA Initiation as SA mode. 
*@return: none
******************************************************************************/
void OPA_Init_SA(void)
{
    OPA2_Handle.Hsm = OPA_HSM_HIGH;
    OPA2_Handle.OPAMP_NonInvertingInput = OPA2_VINP_PA7;
    OPA2_Handle.OPAMP_InvertingInput = OPA_VINN_SA_IO;
    OPA2_Handle.OutSel = OPA_OUT_GPIO;
    OPAMP_Init(OPAMP_Selection_OPAMP2,&OPA2_Handle);
}

/******************************************************************************
*@brief : OPA Initiation as UG mode. 
*@return: none
******************************************************************************/
void OPA_Init_UG(void)
{
    OPA2_Handle.Hsm = OPA_HSM_HIGH;
    OPA2_Handle.OPAMP_NonInvertingInput = OPA2_VINP_PA7;
    OPA2_Handle.OPAMP_InvertingInput = OPA_VINN_UG;
    OPA2_Handle.OutSel = OPA_OUT_GPIO;
    OPAMP_Init(OPAMP_Selection_OPAMP2,&OPA2_Handle);
}


/******************************************************************************
*@brief : APP_Test. 
*@param : test_mode: test mode
*@return: none
******************************************************************************/
void APP_Test(TEST_OPA_TypeDef testMode)
{
    printfS("OPA Test is start... \r\n");
	System_Module_Enable(EN_OPA);
	OPA_GPIO_Init();

    switch(testMode)
    {
        case TEST_OPA_PGA:
            printfS("OPA init as PGA mode. \r\n");
            OPA_Init_PGA();
            OPAMP_PGAConfig(OPAMP_Selection_OPAMP2,OPA_GAIN_2_1);
            break;
        
        case TEST_OPA_SA:
            printfS("OPA init as SA mode. \r\n");
            OPA_Init_SA();
            break;
        
        case TEST_OPA_UG:
            printfS("OPA init as UG mode. \r\n");
            OPA_Init_UG();
            break;
    }
	OPAMP_TrimSoftware(OPAMP_Selection_OPAMP2);
	OPAMP_Cmd(OPAMP_Selection_OPAMP2,ENABLE);
    
    printfS("OPA initiate OK!\r\n");
}

void OPA_GPIO_Init(void)
{
    System_Module_Enable(EN_GPIOAB);
    //VINP:PA7, VINM:PC5, VOUT:PA6
    GPIO_InitTypeDef GPIO_handle;
    GPIO_handle.Drive = GPIO_DRIVE_LEVEL3;
    GPIO_handle.Mode = GPIO_MODE_ANALOG;
    GPIO_handle.Pin = GPIO_PIN_7|GPIO_PIN_6;
    GPIO_handle.Pull = GPIO_NOPULL;
    GPIO_Init(GPIOA,&GPIO_handle);

    System_Module_Enable(EN_GPIOCD);
    GPIO_handle.Drive = GPIO_DRIVE_LEVEL3;
    GPIO_handle.Mode = GPIO_MODE_ANALOG;
    GPIO_handle.Pin = GPIO_PIN_5;
    GPIO_handle.Pull = GPIO_NOPULL;
    GPIO_Init(GPIOC,&GPIO_handle);

}
