/*
  ******************************************************************************
  * @file    APP.c
  * @author  Chris_Kyle
  * @version V1.0.0
  * @date    2020
  * @brief   MPU demo source code.
  ******************************************************************************
*/
#include "app.h"
#include "mpu_config.h"

extern uint8_t gu8_Tx1_DMA_Buffer[64]; 

volatile uint32_t dma_complete_times;


void UART_TX_DMA_Init(void)
{   
	DMA_InitTypeDef  DMA_InitStructure;	
	
	UART_DMACmd(UART2, UART_DMACR_TXDMAE, DISABLE);
    /* Enable DMA Module */
    System_Module_Enable(EN_DMA);
    /* NVIC configuration */
    NVIC_ClearPendingIRQ(DMA_IRQn);
    NVIC_EnableIRQ(DMA_IRQn);
    /* DMA channel6 configuration */

    DMA_DeInit(DMA_Channel0);
    DMA_InitStructure.Request_ID = REQ7_UART2_SEND;
    DMA_InitStructure.SrcAddr = (uint32_t)gu8_Tx1_DMA_Buffer;
    DMA_InitStructure.DstAddr = (uint32_t)(&UART2->DR);
    DMA_InitStructure.Data_Flow = DMA_DATA_FLOW_M2P;
    DMA_InitStructure.DMA_BufferSize = DMA_TX_SIZE;
    DMA_InitStructure.Source_Inc = DMA_SOURCE_ADDR_INCREASE_ENABLE;
    DMA_InitStructure.Desination_Inc = DMA_DST_ADDR_INCREASE_DISABLE;
    DMA_InitStructure.Source_Width = DMA_SRC_WIDTH_BYTE;
    DMA_InitStructure.Desination_Width = DMA_DST_WIDTH_BYTE;
    DMA_InitStructure.DMA_Mode = DMA_NORMAL;
    DMA_Init(DMA_Channel0, &DMA_InitStructure);	
}

/*********************************************************************************
* Function    : APP_MPU_Test
* Description : 
* Input       : 
* Outpu       : 
* Author      : Chris_Kyle                         Data : 2020
**********************************************************************************/
void APP_Test(void)
{
    MPU_PrintReg();
    System_Delay_MS(1000);
    uint32_t len=64;

    //prepare data
    memset(gu8_Tx1_DMA_Buffer,0x31,len);
    memcpy(gu8_Tx1_DMA_Buffer, "Buffer1111111111", 16);   // Buffer1 flag
    gu8_Tx1_DMA_Buffer[len-4] = ',';    
    gu8_Tx1_DMA_Buffer[len-2] = '\r';
    gu8_Tx1_DMA_Buffer[len-1] = '\n';
    
    dma_complete_times = 0;

    while(1)
    {
        UART_TX_DMA_Init();
        //modify data count
        gu8_Tx1_DMA_Buffer[len-3] = (0x30 + dma_complete_times%10);
        
        //start dma transmit
        /* Enable DMA Channel0 transfer */
        DMA_Cmd(DMA_Channel0, ENABLE);
        //UART DMA Send
        UART_DMACmd(UART2, UART_DMACR_TXDMAE, ENABLE);			
        while (RESET == DMA_GetFlagStatus(DMA_IT_FLAG_TC0));
        DMA_ClearFlag(DMA_IT_FLAG_TC0);
        dma_complete_times++;
           
    }
}


