
/******************************************************************************
*@file  : fxx_wdt.h
*@brief : Header file of WDT SPL module.
******************************************************************************/

#ifndef __FXX_WDT_H__
#define __FXX_WDT_H__

#include "fxx_std.h"


/** @defgroup WDT_Reload 
  * @{
  */  
#define IS_WDT_RELOAD(__RELOAD__)           ((__RELOAD__) <= 0xFFFFFFFFU)
/**
  * @}
  */
  
/** @defgroup WDT_State
  * @{
  */

#define WDT_DISABLE                         ( 0U )
#define WDT_ENABLE                          ( 0x80U )
#define IS_WDT_STATE(__STATE__)             (((__STATE__) == WDT_ENABLE)    || \
                                            ((__STATE__) == WDT_DISABLE))
/**
  * @}
  */
  
/** @defgroup WDT_Mode
  * @{
  */

#define WDT_MODE_RESET                     ( 0U )
#define WDT_MODE_INTERRUPT                 ( 0x40U )
#define IS_WDT_MODE(__MODE__)               (((__MODE__) == WDT_MODE_RESET)     || \
                                            ((__MODE__) == WDT_MODE_INTERRUPT))
/**
  * @}
  */

/** @defgroup WDT_Interrupt 
  * @{
  */

#define  WDT_INTERRUPT_DISABLE              ( 0U )
#define  WDT_INTERRUPT_ENABLE               ( 0x10U )
#define IS_WDT_INTERRUPT(__STATE__)         (((__STATE__) == WDT_INTERRUPT_DISABLE)     || \
                                            ((__STATE__) == WDT_INTERRUPT_ENABLE))
/**
  * @}
  */
  
/** @defgroup WDT_Clock_Prescaler
  * @{
  */

#define WDT_CLOCK_PRESCALER_1               ( 0U )
#define WDT_CLOCK_PRESCALER_2               ( 1U )
#define WDT_CLOCK_PRESCALER_4               ( 2U )
#define WDT_CLOCK_PRESCALER_8               ( 3U )
#define WDT_CLOCK_PRESCALER_16              ( 4U )
#define WDT_CLOCK_PRESCALER_32              ( 5U )
#define WDT_CLOCK_PRESCALER_64              ( 6U )
#define WDT_CLOCK_PRESCALER_128             ( 7U )
#define IS_WDT_PRESCALER(__PRESCALER__)     (((__PRESCALER__) == WDT_CLOCK_PRESCALER_1)     || \
                                            ((__PRESCALER__) == WDT_CLOCK_PRESCALER_2)      || \
                                            ((__PRESCALER__) == WDT_CLOCK_PRESCALER_4)      || \
                                            ((__PRESCALER__) == WDT_CLOCK_PRESCALER_8)      || \
                                            ((__PRESCALER__) == WDT_CLOCK_PRESCALER_16)     || \
                                            ((__PRESCALER__) == WDT_CLOCK_PRESCALER_32)     || \
                                            ((__PRESCALER__) == WDT_CLOCK_PRESCALER_64)     || \
                                            ((__PRESCALER__) == WDT_CLOCK_PRESCALER_128))
/**
  * @}
  */
  
  

  
/** @defgroup WDT_Feed
  * @{
  */

#define WDT_CMD_FEED_WATCHDOG               ( 0xAA55A55AU )
/**
  * @}
  */
  
  
/** @defgroup WDT_Interrupt_clear_time  
  * @{
  */  
#define IS_WDT_INTCLRTIME(__TIME__)          ((__TIME__) <= 0xFFFFU)
/**
  * @}
  */
 
/** @defgroup WDT_Flag
  * @{
  */

#define  WDT_FLAG_RIS                       ( 1U )
#define IS_WDT_FLAGS(__FLAG__)              ((__FLAG__) == WDT_FLAG_RIS)
/**
  * @}
  */
  
  

  
/* Exported functions --------------------------------------------------------*/


void WDT_DeInit(void);
void WDT_Cmd(uint32_t NewState);
void WDT_SetPrescaler(uint32_t Prescaler);
void WDT_SetMode(uint32_t Mode);
void WDT_ITCmd(uint32_t NewState);
void WDT_SetLoadValue(uint32_t Load);
uint32_t WDT_GetCounterValue(void);
void WDT_SetITClrTime(uint32_t ITClrTime);
void WDT_FeedDog(void);
FlagStatus WDT_GetFlagStatus(uint32_t Flag);



#endif
