/***********************************************************************
  ******************************************************************************
  * @file    fxx_hrng.h
  * @version V1.0.0
  * @date    2020
  * @brief   Header file of HRNG module.
 ***********************************************************************/

#ifndef __HRNG_H__
#define __HRNG_H__

#include "fxx_std.h"

//#define hrng_delay_32() __nop();__nop();__nop();__nop();__nop();__nop();__nop();__nop();__nop();__nop();__nop();__nop();__nop();__nop();__nop();__nop();__nop();__nop();__nop();__nop();__nop();__nop();__nop();__nop();__nop();__nop();__nop();__nop();__nop();__nop();__nop();__nop();
#define hrng_delay_32()__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();__NOP();  
	 

/*********************************************************************************
* Function Name  : HRNG_Initial
* Description    : config hrng module
* Input          : - ctrl   : input ctrl reg data;
				 : - cmpres : input cmpres reg data;
* Output         : None
* Return         : None
*********************************************************************************/
void HRNG_Initial(void);

/*********************************************************************************
* Function Name  : HRNG_Source_Disable
* Description    : disable hrng source 
* Input          : - ctrl   : input ctrl reg data;
				 : - cmpres : input cmpres reg data;
* Output         : None
* Return         : None
*********************************************************************************/
void HRNG_Source_Disable(void);

/*********************************************************************************
* Function Name  : HRNG_Get_Hrng8
* Description    : get 8bit random number
* Input          : None
* Output         : None
* Return         : 8 bit random number
*********************************************************************************/
UINT8 HRNG_Get_Hrng8(void);

/*********************************************************************************
* Function Name  : HRNG_Get_Hrng32
* Description    : get 32bit random number
* Input          : None
* Output         : None
* Return         : 32 bit random number
*********************************************************************************/
UINT32 HRNG_Get_Hrng32(void);

/*********************************************************************************
* Function Name  : HRNG_Get_Hrng
* Description    : get random number
* Input          : byte_len :  the byte length of random number
* Output         : *hdata   :  the start address of random number the size must be 16bytes
* Return         : 0: hrng data is ok; 1: hrng data is bad
*********************************************************************************/
UINT8 HRNG_Get_Hrng(UINT8 *hdata, UINT32 byte_len);

#endif



