/*
  ******************************************************************************
  * @file    APP.c
  * @author  PJ
  * @version V1.0.0
  * @date    2021
  * @brief   RTC demo source code.
  ******************************************************************************
*/
#include "app.h"

GPIO_InitTypeDef GPIOA_Handle;
LVD_InitTypeDef  LVD_Init;


void GPIO_Turn()  /* תPA1ʱ */
{
    GPIOA_Handle.Pin       = GPIO_PIN_1 ;
    GPIOA_Handle.Mode      = GPIO_MODE_OUTPUT_PP;
    GPIOA_Handle.Pull      = GPIO_PULLUP;
    GPIOA_Handle.Alternate = GPIO_FUNCTION_0;
    GPIO_Init(GPIOA, &GPIOA_Handle);  
    
    while(1)
    {
        GPIO_WriteBit(GPIOA,GPIO_PIN_1 , Bit_SET);
        System_Delay_MS(100);
        GPIO_WriteBit(GPIOA,GPIO_PIN_1 , Bit_RESET);
        System_Delay_MS(100);
    }

}

//ѹλܿ
void LVD_Config(void)
{
    
    LVD_Init.LVDEN          =  FUNC_ENABLE;         /*ʹLVD */
    LVD_Init.LVDRST_EN      =  FUNC_ENABLE;         /*ʹLVDλ */
    LVD_Init.LVD_FLTEN      =  FUNC_ENABLE;         /*ʹLVDȽ˲ */
    LVD_Init.LVD_TRIM       =  LVD_TRIM_2V73;       /*LVD TRIM 2.73V*/
    LVD_Init.LVD_FLTCLK_SEL =  FLTCLK_SEL_PCLK_32;  /*FLTCLK ѡRC32K */
    LVD_Init.LVD_FLT_TIME   =  LVD_FLT_TIME_4;      /*FLTCLK 4 */
    
    System_LVD_Config(&LVD_Init);
    
}

/*********************************************************************************
* Function    : APP_Test
* Description : LVD Test
**********************************************************************************/
void APP_Test(void)
{
    printfS("MCU LVD Test \r\n");
    
    LVD_Config();
    
    /*ѹСLVD趨ֵʱϵͳλGPIOתֹͣ */
    GPIO_Turn(); 

}