#ifndef _BSP_UART_H
#define _BSP_UART_H

#include "fxx_std.h"

typedef enum
{
    UART_OK       = 0x00U,
    UART_ERROR    = 0x01U,
    UART_BUSY     = 0x02U,
    UART_TIMEOUT  = 0x03U
}UART_StatusTypeDef;

typedef struct _UART_HandleTypeDef
{
    UART_TypeDef            *Instance;                /*!< UART registers base address        */

    uint32_t                 TxSize;             /*!< UART Transmit parameters in interrupt  */
    __IO uint32_t            TxCount;
    uint8_t                 *TxData;
    
    uint32_t                 RxSize;             /*!< UART Receive parameters in interrupt  */
    __IO uint32_t            RxCount; 
    uint32_t                 fifo_level_minus1;   
    uint8_t                 *RxData;  
    
    
    __IO uint8_t             TxBusy;  
    __IO uint8_t             RxBusy;  
    
	__IO uint32_t           ErrorCode;                /*!<UART Error Code */
    
    void (*RxCpltCallback)(struct _UART_HandleTypeDef* huart);
    void (*TxCpltCallback)(struct _UART_HandleTypeDef* huart);
    void (*ErrorCallback)(struct _UART_HandleTypeDef* huart);
    

}UART_HandleTypeDef;

UART_StatusTypeDef UART_Transmit(UART_HandleTypeDef *huart, uint8_t *fu8_Data, uint32_t fu32_Size, uint32_t fu32_Timeout);
UART_StatusTypeDef UART_Receive(UART_HandleTypeDef *huart, uint8_t *fu8_Data, uint32_t fu32_Size, uint32_t fu32_Timeout);

#endif
