/*
  ******************************************************************************
  * @file    APP.c
  * @author  Xiao Han
  * @version V1.0.0
  * @date    2021
  * @brief   LIN demo source code.
  ******************************************************************************
*/
#include "app.h"

#include "uart_lin.h"
 
//#define UART_TEST_LIN1D3

UART_HandleTypeDef UartLINHandle;

/************************************************************************
 * function   : printfB8
 * Description: printf data block by byte
 * input :
 *         uint8_t* buff: buff
 *         uint32_t length: byte length
 * return: none
 ************************************************************************/
void printfB8(uint8_t* buff, uint32_t length)
{
	uint32_t uiI;

	for(uiI=0;uiI<length;uiI++)
	{
		printf("%.2x ",buff[uiI]);	
	}
	printf("\n");
}

void APP_LIN_Master_TX(UART_HandleTypeDef *huart)
{
    uint8_t Tx_Buf[8],Tx_Len;
    
    Tx_Len = 0;
    Tx_Buf[Tx_Len++] = 0x11;
    Tx_Buf[Tx_Len++] = 0x22;
    Tx_Buf[Tx_Len++] = 0x33;
    Tx_Buf[Tx_Len++] = 0x44;
    Tx_Buf[Tx_Len++] = 0x55;
    Tx_Buf[Tx_Len++] = 0x66;
    Tx_Buf[Tx_Len++] = 0x77;
    Tx_Buf[Tx_Len++] = 0x88;
   
	while(1)
	{
        printfS("'APP_LIN_Master_TX'Tx:\r\n");
#ifdef UART_TEST_LIN1D3
        UART_LIN_Master_Transmit(huart,UART_LIN_V1D3,0x03,Tx_Buf,Tx_Len);
#else
        UART_LIN_Master_Transmit(huart, UART_LIN_V2DX, 0x03, Tx_Buf, Tx_Len);
#endif        
        printfB8( (uint8_t*)Tx_Buf, Tx_Len);           
		System_Delay(0x2000000);
	}
}

void APP_LIN_Master_RX(UART_HandleTypeDef *huart)
{
    uint8_t Tx_Buf[16], Tx_Len, Rx_Buf[16], Rx_Len;
    
	while(1)
	{
        printfS("'APP_LIN_Master_TX'Tx:Head.\r\n");
        
        Tx_Len = 0;
        
#ifdef UART_TEST_LIN1D3
        UART_LIN_Master_Transmit(huart,UART_LIN_V1D3,0x03,Tx_Buf,Tx_Len);
        Rx_Len = UART_LIN_Master_Receive(huart,UART_LIN_V1D3,0x03,Rx_Buf, 200);
#else        
        UART_LIN_Master_Transmit(huart,UART_LIN_V2DX,0x03,Tx_Buf,Tx_Len);
        Rx_Len = UART_LIN_Master_Receive(huart,UART_LIN_V2DX,0x03,Rx_Buf, 200);
#endif        
        if(Rx_Len)
        {
            if(Rx_Len != 0xFF)
            {
                printfS("'APP_LIN_Master_TX'Rx:\r\n");
                printfB8( (uint8_t*)Rx_Buf, Rx_Len);
            }
            else
                printfS("Failed check sum error.\r\n");
        }
        
		System_Delay(0x2000000);
	}
}


void APP_LIN_Slave(UART_HandleTypeDef *huart)
{
    uint8_t Tx_Buf[16], Tx_Len, Rx_Buf[16], Rx_Len;
    
    Tx_Len = 0;
    Tx_Buf[Tx_Len++] = 0x11;
    Tx_Buf[Tx_Len++] = 0x22;
    Tx_Buf[Tx_Len++] = 0x33;
    Tx_Buf[Tx_Len++] = 0x44;
    Tx_Buf[Tx_Len++] = 0x55;
    Tx_Buf[Tx_Len++] = 0x66;
    Tx_Buf[Tx_Len++] = 0x77;
    Tx_Buf[Tx_Len++] = 0x88;
   
	while(1)
	{        
#ifdef UART_TEST_LIN1D3
        Rx_Len = UART_LIN_Slave_Receive(huart,UART_LIN_V1D3,Rx_Buf, 200);
#else
        Rx_Len = UART_LIN_Slave_Receive(huart, UART_LIN_V2DX, Rx_Buf, 200);
#endif
        if(Rx_Len)
        {
            if(Rx_Len != 0xFF)
            {
                printfS("'APP_LIN_Slave'Rx:\r\n");
                printfB8( (uint8_t*)Rx_Buf, Rx_Len);
            }
            else
                printfS("Failed check sum error.\r\n");
        
            if(Rx_Len<=3)
            {
#ifdef UART_TEST_LIN1D3
                UART_LIN_Slave_Transmit(huart,UART_LIN_V1D3,Rx_Buf[2],Tx_Buf,Tx_Len);
#else
                UART_LIN_Slave_Transmit(huart,UART_LIN_V2DX,Rx_Buf[2],Tx_Buf,Tx_Len);
#endif
                printfS("'APP_LIN_Slave'Tx:\r\n");
                printfB8( (uint8_t*)Tx_Buf, Tx_Len);
            }
        }
   	}
}
/*********************************************************************************
* Function    : APP_LIN_Test
* Description : 
* Input       : 
* Output      : 
**********************************************************************************/
void APP_LIN_Test(enum_TEST_MODE_t fe_Mode)
{
    printfS("---------- LIN Test ----------\r\n");
    
    UartLINHandle.Instance = UART1;
        
    switch (fe_Mode)
    {
        case TEST_MASTER_TX: 
            APP_LIN_Master_TX(&UartLINHandle);
            break; 
        
        case TEST_MASTER_RX: 
            APP_LIN_Master_RX(&UartLINHandle);
            break;
        
        case TEST_SLAVE: 
            APP_LIN_Slave(&UartLINHandle);
            break; 

        default: break; 
    }
}
