/*
  ******************************************************************************
  * @file    main.c
  * @brief   main source File.
  ******************************************************************************
*/
#include "app.h"

GPIO_InitTypeDef GPIO_InitStruct;
UART_InitTypeDef UARTx_InitStruc;

/************************************************************************
 * function   : Uart_Init
 * Description: Uart Initiation. 
 ************************************************************************/ 
void Uart_Init(uint32_t Baudrate) 
{
	  //Enable GPIO and UART Clock
	  System_Module_Enable(EN_UART2);
	  System_Module_Enable(EN_GPIOAB);
	  //Config GPIO
	  /* A9:Tx  A10:Rx */
	  GPIO_InitStruct.Pin       = GPIO_PIN_2 | GPIO_PIN_3;
	  GPIO_InitStruct.Mode      = GPIO_MODE_AF_PP;
	  GPIO_InitStruct.Pull      = GPIO_PULLUP;
	  GPIO_InitStruct.Alternate = GPIO_FUNCTION_2;
	  GPIO_Init(GPIOA, &GPIO_InitStruct);
	  //UART Config
      UARTx_InitStruc.UART_BaudRate    = Baudrate;  
      UARTx_InitStruc.UART_WordLength  = UART_WORDLENGTH_8B;
	  UARTx_InitStruc.UART_StopBits    = UART_STOPBITS_1;
      UARTx_InitStruc.UART_Parity      = UART_PARITY_NONE;
      UARTx_InitStruc.UART_Mode        = UART_MODE_TX_RX_DEBUG;
      UARTx_InitStruc.UART_HardwareFlowControl =UART_HWCONTROL_NONE;    
      UART_Init(UART2,&UARTx_InitStruc);
      //Enable UART
      UART_Cmd(UART2,ENABLE);  
    
      /* UART_DEBUG_ENABLE control printfS */     
      printfS("MCU is running, HCLK=%dHz, PCLK=%dHz\n", System_Get_SystemClock(), System_Get_APBClock());       
}

/*********************************************************************************
* Function    : main
* Description : 
**********************************************************************************/
int main(void)
{
    System_Init();
    Uart_Init(115200);
	
    APP_Test();  
  
	
    while(1)
    {

    }
}

