/*
  ******************************************************************************
  * @file    fxx_it.c
  * @brief   fxx_it source File.
  ******************************************************************************
*/

#include "fxx_it.h"


extern volatile uint32_t g_iwdtIRQFlag;

/******************************************************************************
*@brief : EXTI handler
*@param : none
*@return: none
******************************************************************************/
void EXTI_IRQHandler(void)
{
    if((EXTI->PDR & IWDT_EXTI_LINE) == IWDT_EXTI_LINE)
    {
        IWDT_FeedDog();
        printfS("EXTI->PDR = 0x%08x\r\n", EXTI->PDR);
        EXTI->PDR = IWDT_EXTI_LINE;
        g_iwdtIRQFlag = 19;
    }
}




