/*
  ******************************************************************************
  * @file    APP.c
  * @author  Chris_Kyle
  * @version V1.0.0
  * @date    2020
  * @brief   GPIO demo source code.
  ******************************************************************************
*/

#include "app.h"

GPIO_InitTypeDef GPIO_InitStructure;
EXTI_InitTypeDef EXTI_InitStructure;

/*********************************************************************************
* Function    : EXTI_Test
* Description : EXTI_Test
* Input       : 
* Output       : 
**********************************************************************************/
void EXTI_Test()
{
    printfS("This is EXTI Test \r\n");
    
    /* Enable CLK */	
    System_Module_Enable(KEY1_EXTI_CLK);
    System_Module_Enable(EN_EXTI);
    
    /* Config GPIO */	
    GPIO_InitStructure.Pin       = KEY1_EXTI_Pin;
    GPIO_InitStructure.Mode      = GPIO_MODE_INPUT;
    GPIO_InitStructure.Pull      = GPIO_PULLUP;
    GPIO_InitStructure.Alternate = GPIO_FUNCTION_0;
    GPIO_Init(KEY1_EXTI_Port, &GPIO_InitStructure);
    
   /* Enable EXTI Interrupt */	
    NVIC_ClearPendingIRQ(EXTI_IRQn);
    NVIC_EnableIRQ(EXTI_IRQn);  
    
    /* Select EXTI SOURCE  */
    EXTI_LineConfig(KEY1_INT_EXTI_PORTSOURCE, KEY1_INT_EXTI_PINSOURCE); 
    
   /* Select EXTI_Line  */
    EXTI_InitStructure.EXTI_Line = KEY1_INT_EXTI_LINE;
    /* EXTI MODE   EXTI_MODE_INTERRUPT */
    EXTI_InitStructure.EXTI_Mode = EXTI_MODE_INTERRUPT;
    /* EXTI_Trigger   EXTI_TRIGGER_FALLING*/
    EXTI_InitStructure.EXTI_Trigger = EXTI_TRIGGER_FALLING;
    EXTI_InitStructure.EXTI_LineCmd = ENABLE;
    EXTI_Init(&EXTI_InitStructure);
    
    System_Delay_MS(3000);

    while (1) 
    {
        printfS("MCU Enter Lowpower, Press User Button To Wakeup MCU!\n"); 
        System_Enter_Stop_Mode(STOPENTRY_WFI);
        printfS("MCU is Runing \r\n");   
        System_Delay_MS(1000);
        printfS("MCU is Runing \r\n");
        System_Delay_MS(1000);
        printfS("MCU is Runing \r\n");
        System_Delay_MS(1000);

    }
    
}
