/*
  ******************************************************************************
  * @file    fxx_it.c
  * @brief   fxx_it source File.
  ******************************************************************************
*/

#include "fxx_std.h"
#include "fxx_it.h"

extern __IO uint32_t gu32_ITC_Conunt;    // transfer complete interrupt count
extern __IO uint32_t gu32_IE_Conunt;     // transfer error interrupt count
extern void ADC_IRQProcess(void);

/*********************************************************************************
* Function    : GPIOAB_IRQHandler
* Description : 
* Input       : 
* Outpu       : 
* Author      : Chris_Kyle                         Date : 2021
**********************************************************************************/
void GPIOAB_IRQHandler(void)
{
 
}

/*********************************************************************************
* Function    : GPIOCD_IRQHandler  
* Description : 
* Input       : 
* Outpu       : 
* Author      : Chris_Kyle                         Date : 2021
**********************************************************************************/
void GPIOCD_IRQHandler(void)
{
               
}

/************************************************************************
 * function   : ADC_IRQHandler
 * Description: adc interrupt service routine. 
 * input : 
 *         none
 * return: none
 ************************************************************************/
void ADC_IRQHandler(void)
{
    ADC_IRQProcess();
    NVIC_ClearPendingIRQ(ADC_IRQn); 
}

/************************************************************************
 * function   : DMA_IRQHandler
 * Description: DMA Interrupt Handler. 
 ************************************************************************/ 
void DMA_IRQHandler(void)
{
    /* Test on DMA Channel2 Transfer Complete interrupt */
    if(DMA_GetITStatus(DMA_IT_FLAG_TC2))
    {
        /* Clear DMA Channel2 Transfer Complete and Global interrupt pending bits */
        DMA_ClearITPendingBit(DMA_IT_FLAG_TC2);
        gu32_ITC_Conunt++;
    }
    else if(DMA_GetITStatus(DMA_IT_FLAG_TE2))
    {
        /* Clear DMA Channel2 error interrupt pending bits */
        DMA_ClearITPendingBit(DMA_IT_FLAG_TE2);
        gu32_IE_Conunt++;
    }
}

