#include "fxx_std.h"

extern ADC_InitTypeDef     ADC_InitStruct;

/******************************** ADC results flag define for BSP level*******************************/
#define BSP_ADC_EOC_FLAG            0x80000000
#define BSP_ADC_JEOC_FLAG           0x40000000
#define BSP_ADC_AWD_FLAG            0x20000000

/*
 * @brief  ADC Status structures definition
 */
typedef enum
{
    ADC_OK       = 0x00U,
    ADC_ERROR    = 0x01U,
    ADC_BUSY     = 0x02U,
    ADC_TIMEOUT  = 0x03U
}ADC_StatusTypeDef;

ADC_StatusTypeDef ADC_Polling(uint32_t* pData, uint32_t Length, uint32_t Timeout);
ADC_StatusTypeDef ADC_DMA_Convert(uint32_t* pData, uint32_t Length);
uint32_t ADC_GetVrefP(void);
void ADC_Init_Gpio(void);
void ADC_Init_Polling_Nchannels(void);
void ADC_Init_Dma_Diff_Nchannels(void);
void ADC_Init_Dma_Single_Nchannels(void);
void ADC_Init_IT_Injected_WatchDog(void);
void ADC_Init_IT_Injected_TimTrig(void);

