/*
  ******************************************************************************
  * @file    fxx_it.c
  * @brief   fxx_it source File.
  ******************************************************************************
*/

#include "fxx_it.h"

extern volatile uint32_t gu32_SystemCount; 
extern volatile uint32_t g_IRQFlag;

/*********************************************************************************
* Function    : HardFault_Handler
* Description : Hard Fault handle, while(1) loop, wait for debug 
* Input       : none 
* Output      : none   
* Author      : xwl                           
**********************************************************************************/  
void HardFault_Handler(void)
{
    while(1);   
} 


/*********************************************************************************
* Function    : SysTick_Handler
* Description : System tick handler
* Input       : none 
* Output      : none 
* Author      : xwl                         
**********************************************************************************/
void SysTick_Handler(void)
{
    gu32_SystemCount++;  
}


/******************************************************************************
*@brief : WDT interrupt function 
*@param : none
*@return: none
******************************************************************************/
void WDT_IRQHandler(void)
{ 
    if(SET == WDT_GetFlagStatus(WDT_FLAG_RIS))
    {
        printfS("WDT->RIS = 0x%x\r\n", WDT->RIS);
        /* ιжϱ־ */
        WDT_FeedDog();
        NVIC_ClearPendingIRQ(WDT_IRQn);
        g_IRQFlag = 1;        
    }

}

