/*
  ******************************************************************************
  * @file    APP.h
  * @author  Chris_Kyle
  * @version V1.0.0
  * @date    2020
  * @brief   GPIO demo Header file.
  ******************************************************************************
*/
#ifndef __APP_H__
#define __APP_H__

#include "fxx_std.h"

#define DMA_TX_SIZE         256
#define UART_TX_BUF_SIZE	512
#define UART_RX_BUF_SIZE	512
#define BUF_SIZE    (512)
extern uint8_t RxBuffer[];
extern uint8_t TxBuffer[];
extern volatile uint32_t rx_cnt;
extern uint32_t read_size;
extern volatile uint32_t tx_cnt;
extern uint32_t send_size;
extern uint8_t fifo_level_minus1;

typedef struct
{
	UART_TypeDef *uart;	            /* ӦĴָ */	
	uint8_t *pTxBuf;			    /* ͻ */
	uint8_t *pRxBuf;			    /* ջ */
	uint32_t lu32_TxBufSize;	    /* ͻС */
	uint32_t lu32_RxBufSize;	    /* ջС */
	uint32_t lu32_TxWrite;		    /* ͻдָ */
	uint32_t lu32_TxRead;		    /* ͻָ */
	uint32_t lu32_RxWrite;		    /* ջдָ */
	uint32_t lu32_RxRead;		    /* ջָ */
	void (*SendOverFunc)(void); 	/* ϵĻصָ */
	void (*ReciveNewFunc)(void);	/* յݵĻصָ */
}Type_UART_t;



typedef struct _UART_HandleTypeDef
{
    UART_TypeDef            *Instance;                /*!< UART registers base address        */

    //UART_InitTypeDef         Init;                    /*!< UART communication parameters      */

    uint32_t                 TxSize;             /*!< UART Transmit parameters in interrupt  */
    __IO uint32_t            TxCount;
    uint8_t                 *TxData;
    
    uint32_t                 RxSize;             /*!< UART Receive parameters in interrupt  */
    __IO uint32_t            RxCount; 
    uint32_t                 fifo_level_minus1;   
    uint8_t                 *RxData;  
    
    
    __IO uint8_t             TxBusy;  
    __IO uint8_t             RxBusy;  
    
	__IO uint32_t           ErrorCode;                /*!<UART Error Code */
    
    void (*RxCpltCallback)(struct _UART_HandleTypeDef* huart);
    void (*TxCpltCallback)(struct _UART_HandleTypeDef* huart);
    void (*ErrorCallback)(struct _UART_HandleTypeDef* huart);
    

}UART_HandleTypeDef;

/*
 * @brief  SPI Status structures definition
 */
typedef enum
{
    UART_OK       = 0x00U,
    UART_ERROR    = 0x01U,
    UART_BUSY     = 0x02U,
    UART_TIMEOUT  = 0x03U
}UART_StatusTypeDef;

typedef enum
{
    TEST_LOOP,
    TEST_UART_IT,
    TEST_DMA
}enum_TEST_MODE_t;

//vars
extern Type_UART_t g_UART2Handle;
extern UART_HandleTypeDef UartHandle;

//functions
void UartSend(enum_TEST_MODE_t fe_Mode,Type_UART_t *pUart, uint8_t *SendBuf, uint32_t DataLen);

void UartIRQ(Type_UART_t *pUart);

void APP_Uart_Test(enum_TEST_MODE_t fe_Mode);

#endif
