/*
  ******************************************************************************
  * @file    fxx_it.c
  * @brief   fxx_it source File.
  ******************************************************************************
*/

#include "fxx_it.h"


extern volatile uint32_t gu32_SystemCount; 

/*********************************************************************************
* Function    : HardFault_Handler
* Description : Hard Fault handle, while(1) loop, wait for debug 
* Input       : none 
* Output      : none   
* Author      : xwl                           
**********************************************************************************/  
void HardFault_Handler(void)
{
    while(1);   
} 


/*********************************************************************************
* Function    : SysTick_Handler
* Description : System tick handler
* Input       : none 
* Output      : none 
* Author      : xwl                         
**********************************************************************************/
void SysTick_Handler(void)
{
    gu32_SystemCount++;  
}


/*********************************************************************************
* Function    : TIM6_IRQHandler
* Description : TIM6 update interrupt 
* Input       : none 
* Output      : none 
* Author      : xwl                         
**********************************************************************************/
void TIM6_IRQHandler(void)
{
	if (TIM6->SR & TIMER_SR_UIF)
	{
		TIM6_Update_IRQ();       
        TIM6->SR &= (~BIT0);    
	}
	
}


