/*
 **********************************************************************
 * Copyright (c)  2008 - 2024, Shanghai AisinoChip Co.,Ltd .
 * @file        main.c    
 * @version     V1.0.0
 * @date        2024  
 * @author      Aisinochip Firmware Team  
 * @brief       UART Test Main File 
 **********************************************************************
 */
#include "app.h" 
#include "fxx_std.h"   

     


GPIO_InitTypeDef GPIO_InitStruct;
UART_InitTypeDef UART2_InitStruc;

/************************************************************************
 * function   : Uart_Init
 * Description: Uart Initiation. 
 ************************************************************************/ 
void Uart_Init(uint32_t Baudrate) 
{
	  //Enable GPIO and UART Clock
	  System_Module_Enable(EN_UART2);
	  System_Module_Enable(EN_GPIOAB); 
	  //Config GPIO
	  /* A2:Tx  A3:Rx */
	  GPIO_InitStruct.Pin       = GPIO_PIN_2 | GPIO_PIN_3;  
	  GPIO_InitStruct.Mode      = GPIO_MODE_AF_PP;
	  GPIO_InitStruct.Pull      = GPIO_PULLUP;
	  GPIO_InitStruct.Alternate = GPIO_FUNCTION_2;
	  GPIO_Init(GPIOA, &GPIO_InitStruct);
	  //UART Config
      UART2_InitStruc.UART_BaudRate    = Baudrate;  
      UART2_InitStruc.UART_WordLength  = UART_WORDLENGTH_8B;
	  UART2_InitStruc.UART_StopBits    = UART_STOPBITS_1;
      UART2_InitStruc.UART_Parity      = UART_PARITY_NONE;
      UART2_InitStruc.UART_Mode        = UART_MODE_TX_RX_DEBUG;
      UART2_InitStruc.UART_HardwareFlowControl =UART_HWCONTROL_NONE;    
      UART_Init(UART2,&UART2_InitStruc); 
      //Enable UART
      UART_Cmd(UART2, ENABLE);  
    
      /* UART_DEBUG_ENABLE control printfS */     
      printfS("MCU is running, HCLK=%dHz, PCLK=%dHz\n", System_Get_SystemClock(), System_Get_APBClock());       
}



/*********************************************************************************
* Function    : main
* Description : The application entry point.
* Input       : None
* Output      : None
**********************************************************************************/
int main(void)
{
    System_Init(); 
    
    Uart_Init(UART_BAUD_RATE);  
    
    Timer_PWM_Output_Test();  
}

