/*
  ******************************************************************************
  * @file    fxx_it.c
  * @brief   fxx_it source File.
  ******************************************************************************
*/

#include "fxx_it.h"

extern volatile uint32_t gu32_SystemCount; 

extern bool g32sFlag;
extern bool galarmFlag;
extern bool gtemperFlag1;
extern bool gtemperFlag2;

/*********************************************************************************
* Function    : HardFault_Handler
* Description : Hard Fault handle, while(1) loop, wait for debug 
* Input       : none 
* Output      : none   
* Author      : xwl                           
**********************************************************************************/  
void HardFault_Handler(void)
{
    while(1);   
} 


/*********************************************************************************
* Function    : SysTick_Handler
* Description : System tick handler
* Input       : none 
* Output      : none 
* Author      : xwl                         
**********************************************************************************/
void SysTick_Handler(void)
{
    gu32_SystemCount++;  
}


/*********************************************************************************
* Function    : RTC_IRQHandler
* Description : RTC Interrupt Handler
**********************************************************************************/
void RTC_IRQHandler(void)
{
    printfS("RTC->SR = 0x%08x\r\n", RTC->SR);
    if(SET == RTC_GetITStatus(RTC_IT_FLAG_ALM)) 
    {
        RTC_ClearITPendingBit(RTC_IT_FLAG_ALM);

        galarmFlag = true;
    }
    
    if(SET == RTC_GetITStatus(RTC_IT_FLAG_32S)) 
    {
        RTC_ClearITPendingBit(RTC_IT_FLAG_32S);

        g32sFlag = true;
    }
    
    if(SET == RTC_GetITStatus(RTC_IT_FLAG_STP1R)) 
    {
        RTC_ClearITPendingBit(RTC_IT_FLAG_STP1R);
        
        gtemperFlag1 = true;
    }
    
    if(SET == RTC_GetITStatus(RTC_IT_FLAG_STP2F)) 
    {
        RTC_ClearITPendingBit(RTC_IT_FLAG_STP2F);
        
        gtemperFlag2 = true;
    }
    RTC_ClearFlag(RTC_IT_FLAG_ALL);
}

