/*
  ******************************************************************************
  * Copyright (c)  2008 - 2024, Shanghai AisinoChip Co.,Ltd .
  * @file    APP.c 
  * @version V1.0.0
  * @date    2024
  * @author  Aisinochip Firmware Team  
  * @brief   OPA demo source code.
  ******************************************************************************        
*/
#include "app.h"  


void OPA_IO_Init(void)
{
    GPIO_InitTypeDef    GPIO_OPA;
	GPIO_OPA.Mode      = GPIO_MODE_ANALOG;

	GPIO_OPA.Pin       = GPIO_PIN_6 | GPIO_PIN_5;
	GPIO_Init(GPIOB, &GPIO_OPA);
	GPIO_OPA.Pin       = GPIO_PIN_5;//OPA1_OUT
	GPIO_Init(GPIOC, &GPIO_OPA);
	
	GPIO_OPA.Pin       = GPIO_PIN_3 | GPIO_PIN_1;
	GPIO_Init(GPIOB, &GPIO_OPA);
	GPIO_OPA.Pin       = GPIO_PIN_0;//OPA2_OUT
	GPIO_Init(GPIOB, &GPIO_OPA);
	
	
	GPIO_OPA.Pin       = GPIO_PIN_7 | GPIO_PIN_5;
	GPIO_Init(GPIOA, &GPIO_OPA);
	GPIO_OPA.Pin       = GPIO_PIN_6;//OPA2_OUT
	GPIO_Init(GPIOA, &GPIO_OPA);
}

/************************************************************************
 * function   : OPA_Init
 * Description: OPA Initiation. 
 ************************************************************************/ 
void OPA_Init_App(void)
{
	OPA_InitTypeDef OPA_Init_Strct;
	
    OPA_Init_Strct.VinPSel = OPA_CSR1_VINPSEL_PB6;
    OPA_Init_Strct.VinMSel = OPA_CSR1_VINMSEL_PB5;
    OPA_Init_Strct.TrimEn = OPA_CSR_TRIM_ENABLE;

    OPA_Init(OPA1,&OPA_Init_Strct);

    OPA_Init_Strct.VinPSel = OPA_CSR2_VINPSEL_PB3;
    OPA_Init_Strct.VinMSel = OPA_CSR2_VINMSEL_PB1;
    OPA_Init_Strct.TrimEn = OPA_CSR_TRIM_ENABLE;

    OPA_Init(OPA2,&OPA_Init_Strct);

    OPA_Init_Strct.VinPSel = OPA_CSR3_VINPSEL_PA7;
    OPA_Init_Strct.VinMSel = OPA_CSR3_VINMSEL_PA5;
    OPA_Init_Strct.TrimEn = OPA_CSR_TRIM_ENABLE;

    OPA_Init(OPA3,&OPA_Init_Strct);
}

/************************************************************************
 * function   : OPA_Test
 * Description: OPA 1,2,3 enable. 
 *              OPA trim enable. 
 ************************************************************************/ 
void OPA_Test(void)
{
    printfS("OPA Test is Ready!!! \r\n");

	OPA_IO_Init();
    OPA_Init_App();
    
    printfS("OPA Inition OK!\r\n");
}
