
/******************************************************************************
*@file  : fxx_wdt.h
*@brief : Header file of WDT SPL module.
******************************************************************************/

#ifndef __FXX_WDT_H__
#define __FXX_WDT_H__


#include "fxx_std.h"



/***************  Bits definition for WDT_LOAD register  *********************/

#define WDT_LOAD_LOAD_Pos                       ( 0U )
#define WDT_LOAD_LOAD_Msk                       ( 0xFFFFFFFFU << WDT_LOAD_LOAD_Pos )
#define WDT_LOAD_LOAD                           ( WDT_LOAD_LOAD_Msk )


/***************  Bits definition for WDT_COUNT register  ********************/

#define WDT_COUNT_COUNT_Pos                     ( 0U )
#define WDT_COUNT_COUNT_Msk                     ( 0xFFFFFFFFU << WDT_COUNT_COUNT_Pos )
#define WDT_COUNT_COUNT                         ( WDT_COUNT_COUNT_Msk )


/***************  Bits definition for WDT_CTRL register  *********************/

#define WDT_CTRL_EN_Pos                         ( 7U )
#define WDT_CTRL_EN_Msk                         ( 0x1U << WDT_CTRL_EN_Pos )
#define WDT_CTRL_EN                             ( WDT_CTRL_EN_Msk )

#define WDT_CTRL_MODE_Pos                       ( 6U )
#define WDT_CTRL_MODE_Msk                       ( 0x1U << WDT_CTRL_MODE_Pos )
#define WDT_CTRL_MODE                           ( WDT_CTRL_MODE_Msk )

#define WDT_CTRL_INTEN_Pos                      ( 4U )
#define WDT_CTRL_INTEN_Msk                      ( 0x1U << WDT_CTRL_INTEN_Pos )
#define WDT_CTRL_INTEN                          ( WDT_CTRL_INTEN_Msk )

#define WDT_CTRL_DIVISOR_Pos                    ( 0U )
#define WDT_CTRL_DIVISOR_Msk                    ( 0x7U << WDT_CTRL_DIVISOR_Pos )
#define WDT_CTRL_DIVISOR                        ( WDT_CTRL_DIVISOR_Msk )
#define WDT_CTRL_DIVISOR_0                      ( 0x1U << WDT_CTRL_DIVISOR_Pos )
#define WDT_CTRL_DIVISOR_1                      ( 0x2U << WDT_CTRL_DIVISOR_Pos )
#define WDT_CTRL_DIVISOR_2                      ( 0x4U << WDT_CTRL_DIVISOR_Pos )


/***************  Bits definition for WDT_FEED register  *********************/

#define WDT_FEED_FEED_Pos                       ( 0U )
#define WDT_FEED_FEED_Msk                       ( 0xFFFFFFFFU << WDT_FEED_FEED_Pos )
#define WDT_FEED_FEED                           ( WDT_FEED_FEED_Msk )


/***************  Bits definition for WDT_INTCLRTIME register  ***************/

#define WDT_INTCLRTIME_INTCLRT_Pos              ( 0U )
#define WDT_INTCLRTIME_INTCLRT_Msk              ( 0xFFFFU << WDT_INTCLRTIME_INTCLRT_Pos )
#define WDT_INTCLRTIME_INTCLRT                  ( WDT_INTCLRTIME_INTCLRT_Msk )


/***************  Bits definition for WDT_RIS register  **********************/

#define WDT_RIS_WDTRIS_Pos                      ( 0U )
#define WDT_RIS_WDTRIS_Msk                      ( 0x1U << WDT_RIS_WDTRIS_Pos )
#define WDT_RIS_WDTRIS                          ( WDT_RIS_WDTRIS_Msk )


/** @defgroup WDT_Cmd
  * @{
  */

#define WDT_CMD_FEED_WATCHDOG                   (0xAA55A55AU)
/**
  * @}
  */
  
/** @defgroup WDT_Clock_Prescaler
  * @{
  */

#define WDT_CLOCK_PRESCALER_1                   (0U)
#define WDT_CLOCK_PRESCALER_2                   (WDT_CTRL_DIVISOR_0)
#define WDT_CLOCK_PRESCALER_4                   (WDT_CTRL_DIVISOR_1)
#define WDT_CLOCK_PRESCALER_8                   (WDT_CTRL_DIVISOR_1 | WDT_CTRL_DIVISOR_0)
#define WDT_CLOCK_PRESCALER_16                  (WDT_CTRL_DIVISOR_2)
#define WDT_CLOCK_PRESCALER_32                  (WDT_CTRL_DIVISOR_2 | WDT_CTRL_DIVISOR_0)
#define WDT_CLOCK_PRESCALER_64                  (WDT_CTRL_DIVISOR_2 | WDT_CTRL_DIVISOR_1)
#define WDT_CLOCK_PRESCALER_128                 (WDT_CTRL_DIVISOR_2 | WDT_CTRL_DIVISOR_1 | WDT_CTRL_DIVISOR_0)
#define IS_WDT_PRESCALER(__PRESCALER__)         (((__PRESCALER__) == WDT_CLOCK_PRESCALER_1)     || \
                                                ((__PRESCALER__) == WDT_CLOCK_PRESCALER_2)      || \
                                                ((__PRESCALER__) == WDT_CLOCK_PRESCALER_4)      || \
                                                ((__PRESCALER__) == WDT_CLOCK_PRESCALER_8)      || \
                                                ((__PRESCALER__) == WDT_CLOCK_PRESCALER_16)     || \
                                                ((__PRESCALER__) == WDT_CLOCK_PRESCALER_32)     || \
                                                ((__PRESCALER__) == WDT_CLOCK_PRESCALER_64)     || \
                                                ((__PRESCALER__) == WDT_CLOCK_PRESCALER_128))
/**
  * @}
  */
  
/** @defgroup WDT_Mode
  * @{
  */
#define WDT_MODE_RESET                          (0U)
#define WDT_MODE_INTERRUPT                      (WDT_CTRL_MODE)
#define IS_WDT_MODE(__MODE__)                   (((__MODE__) == WDT_MODE_RESET)     || \
                                                ((__MODE__) == WDT_MODE_INTERRUPT))
/**
  * @}
  */
  
/** @defgroup WDT_Flag
  * @{
  */
#define WDT_FLAG_RIS                            (WDT_RIS_WDTRIS)
#define IS_WDT_FLAGS(__FLAG__)                  ((__FLAG__) == WDT_FLAG_RIS)
/**
  * @}
  */
  
/** @defgroup WDT_IntClearTime
  * @{
  */
#define IS_WDT_INTCLRTIME(__TIME__)             ((__TIME__) <= 0xFFFFU)
/**
  * @}
  */

/** @defgroup WDT_Reload
  * @{
  */
#define IS_WDT_RELOAD(__RELOAD__)               ((__RELOAD__) <= 0xFFFFFFFFU)
/**
  * @}
  */
  
/** @defgroup WDT_InterruptState
  * @{
  */
#define WDT_INTERRUPT_DISABLE                   (0U)
#define WDT_INTERRUPT_ENABLE                    (WDT_CTRL_INTEN)
#define IS_WDT_INTERRUPT_STATE(_STATE_)         (((_STATE_) == WDT_INTERRUPT_DISABLE)   || \
                                                ((_STATE_) == WDT_INTERRUPT_ENABLE))
/**
  * @}
  */
  
  
/** @defgroup WDT_State
  * @{
  */
#define WDT_STATE_DISABLE                       (0U)
#define WDT_STATE_ENABLE                        (1U)
#define IS_WDT_STATE(_STATE_)                   (((_STATE_) == WDT_STATE_DISABLE)   || \
                                                ((_STATE_) == WDT_STATE_ENABLE))
/**
  * @}
  */ 
  
/* Exported functions --------------------------------------------------------*/
void WDT_DeInit(void);
void IWDT_ResetCmd(uint32_t NewState);
void WDT_Cmd(uint32_t NewState);
void WDT_SetPrescaler(uint32_t Prescaler);
void WDT_SetMode(uint32_t Mode);
void WDT_ITCmd(uint32_t NewState);
void WDT_SetLoadValue(uint32_t Load);
uint32_t WDT_GetCounterValue(void);
void WDT_SetITClrTime(uint32_t ITClrTime);
void WDT_FeedDog(void);
FlagStatus WDT_GetFlagStatus(uint32_t Flag);





#endif


