/******************************************************************************
*@file  : fxx_rtc.h
*@brief : Header file of RTC SPL module.
******************************************************************************/

#ifndef __FXX_RTC_H__
#define __FXX_RTC_H__

#include "fxx_std.h"


/****************  Bit definition for RTC IE Register  ***********************/
#define RTC_IE_STP2R_Pos                        ( 16U )
#define RTC_IE_STP2R_Msk                        ( 0x1U << RTC_IE_STP2R_Pos )
#define RTC_IE_STP2R                            ( RTC_IE_STP2R_Msk )

#define RTC_IE_STP2F_Pos                        ( 15U )
#define RTC_IE_STP2F_Msk                        ( 0x1U << RTC_IE_STP2F_Pos )
#define RTC_IE_STP2F                            ( RTC_IE_STP2F_Msk )

#define RTC_IE_STP1R_Pos                        ( 14U )
#define RTC_IE_STP1R_Msk                        ( 0x1U << RTC_IE_STP1R_Pos)
#define RTC_IE_STP1R                            ( RTC_IE_STP1R_Msk )

#define RTC_IE_STP1F_Pos                        ( 13U )
#define RTC_IE_STP1F_Msk                        ( 0x1U << RTC_IE_STP1F_Pos )
#define RTC_IE_STP1F                            ( RTC_IE_STP1F_Msk )

#define RTC_IE_ADJ32_Pos                        ( 12U ) 
#define RTC_IE_ADJ32_Msk                        ( 0x1U << RTC_IE_ADJ32_Pos)
#define RTC_IE_ADJ32                            ( RTC_IE_ADJ32_Msk )

#define RTC_IE_ALM_Pos                          ( 11U )   
#define RTC_IE_ALM_Msk                          ( 0x1U << RTC_IE_ALM_Pos )
#define RTC_IE_ALM                              ( RTC_IE_ALM_Msk )

#define RTC_IE_1KHZ_Pos                         ( 10U )
#define RTC_IE_1KHZ_Msk                         ( 0x1U << RTC_IE_1KHZ_Pos)
#define RTC_IE_1KHZ                             ( RTC_IE_1KHZ_Msk )

#define RTC_IE_256HZ_Pos                        ( 9U )
#define RTC_IE_256HZ_Msk                        ( 0x1U << RTC_IE_256HZ_Pos )
#define RTC_IE_256HZ                            ( RTC_IE_256HZ_Msk )

#define RTC_IE_64HZ_Pos                         ( 8U )
#define RTC_IE_64HZ_Msk                         ( 0x1U << RTC_IE_64HZ_Pos )
#define RTC_IE_64HZ                             ( RTC_IE_64HZ_Msk )

#define RTC_IE_16HZ_Pos                         ( 7U )
#define RTC_IE_16HZ_Msk                         ( 0x1U << RTC_IE_16HZ_Pos )
#define RTC_IE_16HZ                             ( RTC_IE_16HZ_Msk )

#define RTC_IE_8HZ_Pos                          ( 6U )
#define RTC_IE_8HZ_Msk                          ( 0x1U << RTC_IE_8HZ_Pos )
#define RTC_IE_8HZ                              ( RTC_IE_8HZ_Msk )

#define RTC_IE_4HZ_Pos                          ( 5U )
#define RTC_IE_4HZ_Msk                          ( 0x1U << RTC_IE_4HZ_Pos)
#define RTC_IE_4HZ                              ( RTC_IE_4HZ_Msk )

#define RTC_IE_2HZ_Pos                          ( 4U )
#define RTC_IE_2HZ_Msk                          ( 0x1U << RTC_IE_2HZ_Pos )
#define RTC_IE_2HZ                              ( RTC_IE_2HZ_Msk )

#define RTC_IE_SEC_Pos                          ( 3U )
#define RTC_IE_SEC_Msk                          ( 0x1U << RTC_IE_SEC_Pos )
#define RTC_IE_SEC                              ( RTC_IE_SEC_Msk )

#define RTC_IE_MIN_Pos                          ( 2U )
#define RTC_IE_MIN_Msk                          ( 0x1U << RTC_IE_MIN_Pos )
#define RTC_IE_MIN                              ( RTC_IE_MIN_Msk )

#define RTC_IE_HOUR_Pos                         ( 1U )
#define RTC_IE_HOUR_Msk                         ( 0x1U << RTC_IE_HOUR_Pos )
#define RTC_IE_HOUR                             ( RTC_IE_HOUR_Msk )

#define RTC_IE_DATE_Pos                         ( 0U )
#define RTC_IE_DATE_Msk                         ( 0x1U << RTC_IE_DATE_Pos )
#define RTC_IE_DATE                             ( RTC_IE_DATE_Msk )

/****************  Bit definition for RTC SR Register  ***********************/
#define RTC_SR_STP2R_Pos                        ( 16U )
#define RTC_SR_STP2R_Msk                        ( 0x1U << RTC_SR_STP2R_Pos )
#define RTC_SR_STP2R                            ( RTC_SR_STP2R_Msk )

#define RTC_SR_STP2F_Pos                        ( 15U )
#define RTC_SR_STP2F_Msk                        ( 0x1U << RTC_SR_STP2F_Pos )
#define RTC_SR_STP2F                            ( RTC_SR_STP2F_Msk )

#define RTC_SR_STP1R_Pos                        ( 14U )
#define RTC_SR_STP1R_Msk                        ( 0x1U << RTC_SR_STP1R_Pos )
#define RTC_SR_STP1R                            ( RTC_SR_STP1R_Msk )

#define RTC_SR_STP1F_Pos                        ( 13U )
#define RTC_SR_STP1F_Msk                        ( 0x1U << RTC_SR_STP1F_Pos )
#define RTC_SR_STP1F                            ( RTC_SR_STP1F_Msk )

#define RTC_SR_ADJ32_Pos                        ( 12U )
#define RTC_SR_ADJ32_Msk                        ( 0x1U << RTC_SR_ADJ32_Pos ) 
#define RTC_SR_ADJ32                            ( RTC_SR_ADJ32_Msk )

#define RTC_SR_ALM_Pos                          ( 11U )   
#define RTC_SR_ALM_Msk                          ( 0x1U << RTC_SR_ALM_Pos )
#define RTC_SR_ALM                              ( RTC_SR_ALM_Msk )

#define RTC_SR_1KHZ_Pos                         ( 10U )
#define RTC_SR_1KHZ_Msk                         ( 0x1 << RTC_SR_1KHZ_Pos )
#define RTC_SR_1KHZ                             ( RTC_SR_1KHZ_Msk )

#define RTC_SR_256HZ_Pos                        ( 9U )
#define RTC_SR_256HZ_Msk                        ( 0x1U << RTC_SR_256HZ_Pos )
#define RTC_SR_256HZ                            ( RTC_SR_256HZ_Msk )

#define RTC_SR_64HZ_Pos                         ( 8U )
#define RTC_SR_64HZ_Msk                         ( 0x1U << RTC_SR_64HZ_Pos )
#define RTC_SR_64HZ                             ( RTC_SR_64HZ_Msk )

#define RTC_SR_16HZ_Pos                         ( 7U )
#define RTC_SR_16HZ_Msk                         ( 0x1U << RTC_SR_16HZ_Pos )
#define RTC_SR_16HZ                             ( RTC_SR_16HZ_Msk )

#define RTC_SR_8HZ_Pos                          ( 6U )
#define RTC_SR_8HZ_Msk                          ( 0x1U << RTC_SR_8HZ_Pos )
#define RTC_SR_8HZ                              ( RTC_SR_8HZ_Msk )

#define RTC_SR_4HZ_Pos                          ( 5U )
#define RTC_SR_4HZ_Msk                          ( 0x1U << RTC_SR_4HZ_Pos)
#define RTC_SR_4HZ                              ( RTC_SR_4HZ_Msk )

#define RTC_SR_2HZ_Pos                          ( 4U )
#define RTC_SR_2HZ_Msk                          ( 0x1U << RTC_SR_2HZ_Pos)
#define RTC_SR_2HZ                              ( RTC_SR_2HZ_Msk )

#define RTC_SR_SEC_Pos                          ( 3U )
#define RTC_SR_SEC_Msk                          (0x1U << RTC_SR_SEC_Pos )
#define RTC_SR_SEC                              ( RTC_SR_SEC_Msk )

#define RTC_SR_MIN_Pos                          ( 2U )
#define RTC_SR_MIN_Msk                          ( 0x1U << RTC_SR_MIN_Pos )
#define RTC_SR_MIN                              ( RTC_SR_MIN_Msk )

#define RTC_SR_HOUR_Pos                         ( 1U )
#define RTC_SR_HOUR_Msk                         ( 0x1U << RTC_SR_HOUR_Pos )
#define RTC_SR_HOUR                             ( RTC_SR_HOUR_Msk )

#define RTC_SR_DATE_Pos                         ( 0U )
#define RTC_SR_DATE_Msk                         ( 0x1U << RTC_SR_DATE_Pos )
#define RTC_SR_DATE                             ( RTC_SR_DATE_Msk )

/****************  Bit definition for RTC ALM Register  ***********************/
#define RTC_ALM_ALMWDS_Pos                      ( 31U )
#define RTC_ALM_ALMWDS_Msk                      ( 0x1U << RTC_ALM_ALMWDS_Pos )
#define RTC_ALM_ALMWDS                          ( RTC_ALM_ALMWDS_Msk )

#define RTC_ALM_ALMWEEK_DAY_Pos                 ( 24U )
#define RTC_ALM_ALMWEEK_DAY_Msk                 ( 0x7FU << RTC_ALM_ALMWEEK_DAY_Pos )
#define RTC_ALM_ALMWEEK_DAY                     ( RTC_ALM_ALMWEEK_DAY_Msk )


#define RTC_ALM_ALMHOUR_Pos                     ( 16U )
#define RTC_ALM_ALMHOUR_Msk                     ( 0x3FU << RTC_ALM_ALMHOUR_Pos )
#define RTC_ALM_ALMHOUR                         ( RTC_ALM_ALMHOUR_Msks )

#define RTC_ALM_ALMMIN_Pos                      ( 8U )
#define RTC_ALM_ALMMIN_Msk                      ( 0x7FU << RTC_ALM_ALMMIN_Pos )
#define RTC_ALM_ALMMIN                          ( RTC_ALM_ALMMIN_Msk )

#define RTC_ALM_ALMSEC_Pos                      ( 0U )
#define RTC_ALM_ALMSEC_Msk                      ( 0x7FU << RTC_ALM_ALMSEC_Pos )
#define RTC_ALM_ALMSEC                          ( RTC_ALM_ALMSEC_Msk )

/****************  Bit definition for RTC CR Register  ***********************/
#define RTC_CR_TAMPFLTCLK_Pos                   ( 22U )
#define RTC_CR_TAMPFLTCLK_Msk                   ( 0x1U << RTC_CR_TAMPFLTCLK_Pos )
#define RTC_CR_TAMPFLTCLK                       ( RTC_CR_TAMPFLTCLK_Msk )

#define RTC_CR_TS2EDGE_Pos                      ( 21U )
#define RTC_CR_TS2EDGE_Msk                      ( 0x1U << RTC_CR_TS2EDGE_Pos )
#define RTC_CR_TS2EDGE                          ( RTC_CR_TS2EDGE_Msk )

#define RTC_CR_TAMP2FLT_Pos                     ( 19U )
#define RTC_CR_TAMP2FLT_Msk                     ( 0x3U << RTC_CR_TAMP2FLT_Pos )
#define RTC_CR_TAMP2FLT                         ( RTC_CR_TAMP2FLT_Msk )
#define RTC_CR_TAMP2FLT_0                       ( 0x1U << RTC_CR_TAMP2FLT_Pos )
#define RTC_CR_TAMP2FLT_1                       ( 0x2U << RTC_CR_TAMP2FLT_Pos )

#define RTC_CR_TAMP2FLTEN_Pos                   ( 18U )
#define RTC_CR_TAMP2FLTEN_Msk                   ( 0x1U << RTC_CR_TAMP2FLTEN_Pos)
#define RTC_CR_TAMP2FLTEN                       ( RTC_CR_TAMP2FLTEN_Msk )

#define RTC_CR_TAMP2FCLR_Pos                    ( 17U )
#define RTC_CR_TAMP2FCLR_Msk                    ( 0x1U << RTC_CR_TAMP2FCLR_Pos )
#define RTC_CR_TAMP2FCLR                        ( RTC_CR_TAMP2FCLR_Msk )

#define RTC_CR_TAMP2RCLR_Pos                    ( 16U )
#define RTC_CR_TAMP2RCLR_Msk                    ( 0x1U << RTC_CR_TAMP2RCLR_Pos )
#define RTC_CR_TAMP2RCLR                        ( RTC_CR_TAMP2RCLR_Msk )

#define RTC_CR_TS1EDGE_Pos                      ( 15U )
#define RTC_CR_TS1EDGE_Msk                      ( 0x1U << RTC_CR_TS1EDGE_Pos )
#define RTC_CR_TS1EDGE                          ( RTC_CR_TS1EDGE_Msk )

#define RTC_CR_TAMP1FLT_Pos                     ( 13U )
#define RTC_CR_TAMP1FLT_Msk                     ( 0x3U << RTC_CR_TAMP1FLT_Pos )
#define RTC_CR_TAMP1FLT                         ( RTC_CR_TAMP1FLT_Msk )
#define RTC_CR_TAMP1FLT_0                       ( 0x1U << RTC_CR_TAMP1FLT_Pos )
#define RTC_CR_TAMP1FLT_1                       ( 0x2U << RTC_CR_TAMP1FLT_Pos )

#define RTC_CR_TAMP1FLTEN_Pos                   ( 12U )
#define RTC_CR_TAMP1FLTEN_Msk                   ( 0x1U << RTC_CR_TAMP1FLTEN_Pos)
#define RTC_CR_TAMP1FLTEN                       ( RTC_CR_TAMP1FLTEN_Msk )

#define RTC_CR_ALM_MKSD_Pos                     ( 11U )
#define RTC_CR_ALM_MKSD_Msk                     ( 0x1U << RTC_CR_ALM_MKSD_Pos )
#define RTC_CR_ALM_MKSD                         ( RTC_CR_ALM_MKSD_Msk )

#define RTC_CR_ALM_MSKH_Pos                     ( 10U )
#define RTC_CR_ALM_MSKH_Msk                     ( 0x1U << RTC_CR_ALM_MSKH_Pos )
#define RTC_CR_ALM_MSKH                         ( RTC_CR_ALM_MSKH_Msk )

#define RTC_CR_ALM_MSKM_Pos                     ( 9U )
#define RTC_CR_ALM_MSKM_Msk                     ( 0x1U << RTC_CR_ALM_MSKM_Pos )
#define RTC_CR_ALM_MSKM                         ( RTC_CR_ALM_MSKM_Msk )

#define RTC_CR_TAMP1FCLR_Pos                    ( 8U )
#define RTC_CR_TAMP1FCLR_Msk                    ( 0x1U << RTC_CR_TAMP1FCLR_Pos )
#define RTC_CR_TAMP1FCLR                        ( RTC_CR_TAMP1FCLR_Msk )

#define RTC_CR_TAMP1RCLR_Pos                    ( 7U )
#define RTC_CR_TAMP1RCLR_Msk                    ( 0x1U << RTC_CR_TAMP1RCLR_Pos )
#define RTC_CR_TAMP1RCLR                        ( RTC_CR_TAMP1RCLR_Msk )

#define RTC_CR_TAMP2EN_Pos                      ( 6U )
#define RTC_CR_TAMP2EN_Msk                      ( 0x1U << RTC_CR_TAMP2EN_Pos )
#define RTC_CR_TAMP2EN                          ( RTC_CR_TAMP2EN_Msk )

#define RTC_CR_TAMP1EN_Pos                      ( 5U )
#define RTC_CR_TAMP1EN_Msk                      ( 0x1U << RTC_CR_TAMP1EN_Pos )
#define RTC_CR_TAMP1EN                          ( RTC_CR_TAMP1EN_Msk )

#define RTC_CR_ALM_EN_Pos                       ( 4U )
#define RTC_CR_ALM_EN_Msk                       ( 0x1U << RTC_CR_ALM_EN_Pos )
#define RTC_CR_ALM_EN                           ( RTC_CR_ALM_EN_Msk )

#define RTC_CR_FSEL_Pos                         ( 0U )
#define RTC_CR_FSEL_Msk                         ( 0xFU << RTC_CR_FSEL_Pos )
#define RTC_CR_FSEL                             ( RTC_CR_FSEL_Msk )
#define RTC_CR_FSEL_0                           ( 0x1U << RTC_CR_FSEL_Pos )
#define RTC_CR_FSEL_1                           ( 0x2U << RTC_CR_FSEL_Pos )
#define RTC_CR_FSEL_2                           ( 0x4U << RTC_CR_FSEL_Pos )
#define RTC_CR_FSEL_3                           ( 0x8U << RTC_CR_FSEL_Pos )

/****************  Bit definition for RTC ADJUST Register  ***********************/
#define RTC_ADJUST_ADJSIGN_Pos                  ( 9U )
#define RTC_ADJUST_ADJSIGN_Msk                  ( 0x1U << RTC_ADJUST_ADJSIGN_Pos )
#define RTC_ADJUST_ADJSIGN                      ( RTC_ADJUST_ADJSIGN_Msk )

#define RTC_ADJUST_ADJVALUE_Pos                 ( 0U )
#define RTC_ADJUST_ADJVALUE_Msk                 ( 0x1FFU << RTC_ADJUST_ADJVALUE_Pos )
#define RTC_ADJUST_ADJVALUE                     ( RTC_ADJUST_ADJVALUE_Msk )

/** @defgroup RTC write enable
  * @{
  */
#define RTC_WRITE_ENABLE                        (0xCA53CA53U)
#define RTC_WRITE_DISABLE                       (0U)
/**
  * @}
  */ 
  
/** @defgroup RTC_State
  * @{
  */
#define RTC_STATE_DISABLE                       (0U)
#define RTC_STATE_ENABLE                        (1U)
#define IS_RTC_STATE(_STATE_)                   (((_STATE_) == RTC_STATE_DISABLE)  || \
                                                ((_STATE_) == RTC_STATE_ENABLE))
/**
  * @}
  */ 

/** @defgroup RTC Alarm week or day mode Definitions 
  * @{
  */
#define RTC_ALARM_WEEK                          (0U) 
#define RTC_ALARM_DAY                           (RTC_ALM_ALMWDS)
#define IS_RTC_ALARM_MODE(__MODE__)             (((__MODE__) == RTC_ALARM_WEEK) || \
                                                ((__MODE__) == RTC_ALARM_DAY))
/**
  * @}
  */ 

/** @defgroup RTC Alarm Mask Definitions 
  * @{
  */ 
#define RTC_ALARM_MASK_NONE                     (0U)
#define RTC_AlLARM_MASK_MIN                     (RTC_CR_ALM_MSKM)
#define RTC_ALARM_MASK_HOUR                     (RTC_CR_ALM_MSKH)
#define RTC_ALARM_MASK_WEEKDAY                  (RTC_CR_ALM_MKSD)
#define RTC_ALARM_MASK_ALL                      (RTC_CR_ALM_MSKM | RTC_CR_ALM_MSKH | RTC_CR_ALM_MKSD)
#define IS_ALARM_MASK(__MASK__)                 (((__MASK__) == RTC_ALARM_MASK_NONE)    || \
                                                ((__MASK__) == RTC_AlLARM_MASK_MIN)     || \
                                                ((__MASK__) == RTC_ALARM_MASK_HOUR)     || \
                                                ((__MASK__) == RTC_ALARM_MASK_WEEKDAY)  || \
                                                ((__MASK__) <= RTC_ALARM_MASK_ALL))

/**
  * @}
  */ 



/** @defgroup RTC Time Definitions 
  * @{
  */                                                 
#define IS_RTC_HOUR(__HOUR__)                   ((__HOUR__) <= 0x23)
#define IS_RTC_MINUTE(__MIN__)                  ((__MIN__) <= 0x59)
#define IS_RTC_SECOND(__SEC__)                  ((__SEC__) <= 0x59)  
/**
  * @}
  */  

/** @defgroup RTC Date Definitions 
  * @{
  */ 
#define IS_RTC_YEAR(__YEAR__)                   ((__YEAR__) <= 0x99)
#define IS_RTC_MONTH(__MONTH__)                 ((__MONTH__) <= 0x12)
#define IS_RTC_DAY(__DAY__)                     ((__DAY__) <= 0x31)
#define IS_RTC_WEEK(__WEEK__)                   ((__WEEK__) <= 0x07)
/**
  * @}
  */                                        

/** @defgroup RTC Input parameter format_definitions 
  * @{
  */ 
#define RTC_FORMAT_DECIMAL                      (0U)
#define RTC_FORMAT_BCD                          (1U)
#define IS_RTC_FORMAT(__FORMAT__)               (((__FORMAT__) == RTC_FORMAT_DECIMAL)   || \
                                                ((__FORMAT__) == RTC_FORMAT_BCD))

/**
  * @}
  */ 

/** @defgroup RTC Clock Source
  * @{
  */
#define RTC_CLOCK_RC32K                         (0U)
#define RTC_CLOCK_XTL                           (1U)  
#define IS_RTC_CLOCKSRC(__SRC__)                (((__SRC__) == RTC_CLOCK_RC32K) || \
                                                ((__SRC__) == RTC_CLOCK_XTL))
/**
  * @}
  */                                            

/** @defgroup RTC Interrupts and flags Definitions 
  * @{
  */ 
#define RTC_IT_FLAG_DATE                        (RTC_SR_DATE)  
#define RTC_IT_FLAG_HOUR                        (RTC_SR_HOUR)  
#define RTC_IT_FLAG_MIN                         (RTC_SR_MIN)  
#define RTC_IT_FLAG_SEC                         (RTC_SR_SEC) 
#define RTC_IT_FLAG_2HZ                         (RTC_SR_2HZ) 
#define RTC_IT_FLAG_4HZ                         (RTC_SR_4HZ) 
#define RTC_IT_FLAG_8HZ                         (RTC_SR_8HZ)    
#define RTC_IT_FLAG_16HZ                        (RTC_SR_16HZ)  
#define RTC_IT_FLAG_64HZ                        (RTC_SR_64HZ)  
#define RTC_IT_FLAG_256HZ                       (RTC_SR_256HZ)  
#define RTC_IT_FLAG_1KHZ                        (RTC_SR_1KHZ)  
#define RTC_IT_FLAG_ALM                         (RTC_SR_ALM)  
#define RTC_IT_FLAG_32S                         (RTC_SR_ADJ32)  
#define RTC_IT_FLAG_STP1F                       (RTC_SR_STP1F)  
#define RTC_IT_FLAG_STP1R                       (RTC_SR_STP1R)  
#define RTC_IT_FLAG_STP2F                       (RTC_SR_STP2F)  
#define RTC_IT_FLAG_STP2R                       (RTC_SR_STP2R)  
#define RTC_IT_FLAG_ALL                         (0x1FFFFU)
#define IS_RTC_IT_FLAG(__FLAG__)                (((__FLAG__) == RTC_IT_FLAG_DATE)   || \
                                                ((__FLAG__) == RTC_IT_FLAG_HOUR)    || \
                                                ((__FLAG__) == RTC_IT_FLAG_MIN)     || \
                                                ((__FLAG__) == RTC_IT_FLAG_SEC)     || \
                                                ((__FLAG__) == RTC_IT_FLAG_2HZ)     || \
                                                ((__FLAG__) == RTC_IT_FLAG_4HZ)     || \
                                                ((__FLAG__) == RTC_IT_FLAG_8HZ)     || \
                                                ((__FLAG__) == RTC_IT_FLAG_16HZ)    || \
                                                ((__FLAG__) == RTC_IT_FLAG_64HZ)    || \
                                                ((__FLAG__) == RTC_IT_FLAG_256HZ)   || \
                                                ((__FLAG__) == RTC_IT_FLAG_1KHZ)    || \
                                                ((__FLAG__) == RTC_IT_FLAG_ALM)     || \
                                                ((__FLAG__) == RTC_IT_FLAG_32S)     || \
                                                ((__FLAG__) == RTC_IT_FLAG_STP1F)   || \
                                                ((__FLAG__) == RTC_IT_FLAG_STP1R)   || \
                                                ((__FLAG__) == RTC_IT_FLAG_STP2F)   || \
                                                ((__FLAG__) == RTC_IT_FLAG_STP2R)   || \
                                                ((__FLAG__) <= RTC_IT_FLAG_ALL))   
/**
  * @}
  */ 
  

/** @defgroup RTC Output selection Definitions 
  * @{
  */ 
#define RTC_FSEL_NONE                           (0U)  
#define RTC_FSEL_SECOND_CARRY                   (2U)
#define RTC_FSEL_MINUTE_CARRY                   (3U)
#define RTC_FSEL_HOUR_CARRY                     (4U)
#define RTC_FSEL_DAY_CARRY                      (5U)
#define RTC_FSEL_ALARM_MATCH                    (6U)
#define RTC_FSEL_32S_SQUARE                     (7U)
#define RTC_FSEL_REVERSE_SECOND_CARRY           (9U)
#define RTC_FSEL_REVERSE_MINUTE_CARRY           (10U)
#define RTC_FSEL_REVERSE_HOUR_CARRY             (11U)
#define RTC_FSEL_REVERSE_DAY_CARRY              (12U)
#define RTC_FSEL_REVERSE_ALARM_MATCH            (13U)
#define RTC_FSEL_REVERSE_SECOND_SQUARE          (15U)
#define IS_RTC_FSEL(__OUT__)                    (((__OUT__) == RTC_FSEL_NONE)                   || \
                                                ((__OUT__) == RTC_FSEL_SECOND_CARRY)            || \
                                                ((__OUT__) == RTC_FSEL_MINUTE_CARRY)            || \
                                                ((__OUT__) == RTC_FSEL_HOUR_CARRY)              || \
                                                ((__OUT__) == RTC_FSEL_DAY_CARRY)               || \
                                                ((__OUT__) == RTC_FSEL_ALARM_MATCH)             || \
                                                ((__OUT__) == RTC_FSEL_32S_SQUARE)              || \
                                                ((__OUT__) == RTC_FSEL_REVERSE_SECOND_CARRY)    || \
                                                ((__OUT__) == RTC_FSEL_REVERSE_MINUTE_CARRY)    || \
                                                ((__OUT__) == RTC_FSEL_REVERSE_HOUR_CARRY)      || \
                                                ((__OUT__) == RTC_FSEL_REVERSE_DAY_CARRY)       || \
                                                ((__OUT__) == RTC_FSEL_REVERSE_ALARM_MATCH)     || \
                                                ((__OUT__) == RTC_FSEL_REVERSE_SECOND_SQUARE))

/**
  * @}
  */

/** @defgroup RTC Digital Calibration Definitions 
  * @{
  */ 
#define RTC_ADJUST_POSITIVE                     (0U) 
#define RTC_ADJUST_NEGATIVE                     (RTC_ADJUST_ADJSIGN)
#define IS_RTC_ADJUST_SIGN(__SIGN__)            (((__SIGN__) == RTC_ADJUST_POSITIVE)    || \
                                                ((__SIGN__) == RTC_ADJUST_NEGATIVE))
#define IS_RTC_ADJUST_VALUE(__VAL__)            ((__VAL__) <= 0x1FF)
/**
  * @}
  */   

/** @defgroup RTC Tamper Trigger edge Definitions 
  * @{
  */ 
#define RTC_TAMPER_RISING                       (0U)
#define RTC_TAMPER_FALLING                      (1U)
#define IS_RTC_TAMPER_EDGE(__EDGE__)            (((__EDGE__) == RTC_TAMPER_RISING)  || \
                                                ((__EDGE__) == RTC_TAMPER_FALLING))       
/**
  * @}
  */ 

/** @defgroup RTC Tamper Filter Definitions 
  * @{
  */ 
#define RTC_TAMPER_FILTER_1                     (0U) 
#define RTC_TAMPER_FILTER_2                     (1U)
#define RTC_TAMPER_FILTER_4                     (2U)                                    
#define RTC_TAMPER_FILTER_8                     (3U) 
#define IS_RTC_TAMPER_FILTER(__FLT__)           (((__FLT__) == RTC_TAMPER_FILTER_1) || \
                                                ((__FLT__) == RTC_TAMPER_FILTER_2)  || \
                                                ((__FLT__) == RTC_TAMPER_FILTER_4)  || \
                                                ((__FLT__) == RTC_TAMPER_FILTER_8))
/**
  * @}
  */ 
  
  /** @defgroup RTC Tamper Filter status 
  * @{
  */ 
#define RTC_TAMPER_FILTER_DISABLE               (0U) 
#define RTC_TAMPER_FILTER_ENABLE                (1U)
#define IS_RTC_TAMPER_FILTER_STATE(__STATE__)   (((__STATE__) == RTC_TAMPER_FILTER_DISABLE) || \
                                                ((__STATE__) == RTC_TAMPER_FILTER_ENABLE))
/**
  * @}
  */ 

/** @defgroup RTC Tamper clock Definitions 
  * @{
  */ 
#define RTC_TAMPER_CLOCK_RTCCLK                 (0U)                                                                   
#define RTC_TAMPER_CLOCK_64HZ                   (RTC_CR_TAMPFLTCLK) 
#define IS_RTC_TAMPER_FILTER_CLOCK(__CLK__)     (((__CLK__) == RTC_TAMPER_CLOCK_RTCCLK) || \
                                                ((__CLK__) == RTC_TAMPER_CLOCK_64HZ))
/**
  * @}
  */

/** @defgroup RTC Tamper Definitions 
  * @{
  */ 
#define RTC_TAMPER_1                            (RTC_CR_TAMP1EN)
#define RTC_TAMPER_2                            (RTC_CR_TAMP2EN)
#define IS_RTC_TAMPER(__TAMPER__)               (((__TAMPER__) == RTC_TAMPER_1) || \
                                                ((__TAMPER__) == RTC_TAMPER_2))
/**
  * @}
  */
  
/** @defgroup RTC Tamper clear backup Definitions
  * @{
  */ 
#define RTC_TAMPER_CLEAR_DISABLE                (0U)
#define RTC_TAMPER_CLEAR_ENABLE                 (1U)
#define IS_RTC_TAMPER_CLEAR(__CLEAR__)          (((__CLEAR__) == RTC_TAMPER_CLEAR_DISABLE)  || \
                                                ((__CLEAR__) == RTC_TAMPER_CLEAR_ENABLE))
/**
  * @}
  */

  
/** @defgroup RTC_Backup_Registers_Definitions 
* @{
*/

#define RTC_BACKUP_0                            (0U)
#define RTC_BACKUP_1                            (1U)
#define RTC_BACKUP_2                            (2U)
#define RTC_BACKUP_3                            (3U)
#define RTC_BACKUP_4                            (4U)
#define IS_RTC_BACKUP(__BKP__)                  (((__BKP__) == RTC_BACKUP_0)    || \
                                                ((__BKP__) == RTC_BACKUP_1)     || \
                                                ((__BKP__) == RTC_BACKUP_2)     || \
                                                ((__BKP__) == RTC_BACKUP_3)     || \
                                                ((__BKP__) == RTC_BACKUP_4))
/**
  * @}
  */ 
  



/**
  * @brief  RTC Configuration Structure definition
  */
typedef struct
{
    uint32_t ClockSource;           /*!< The RTC Clock Source to be configured.*/

    uint32_t Compensation;          /*!< The RTC Clock Compensation to be configured.*/

    uint32_t CompensationValue;     /*!< The RTC Clock Compensation Value to be configured.*/
}RTC_InitTypeDef;


/**
  * @brief  RTC Date structure definition
  */
typedef struct
{
    uint8_t Year;       /*!< Specifies the RTC Year. */

    uint8_t Month;      /*!< Specifies the RTC Month. */

    uint8_t Day;       /*!< Specifies the RTC Day. */

    uint8_t Week;       /*!< Specifies the RTC Week. */
}RTC_DateTypeDef;
/**
  * @}
  */

/**
  * @brief  RTC Time structure definition
  */
typedef struct
{
    uint8_t Hour;       /*!< Specifies the RTC Hour. */

    uint8_t Minute;     /*!< Specifies the RTC Minute. */

    uint8_t Second;     /*!< Specifies the RTC Second. */
}RTC_TimeTypeDef;
/**
  * @}
  */

/**
  * @brief  RTC Alarm structure definition
  */
typedef struct
{
    RTC_TimeTypeDef RTC_AlarmTime;      /*!< Specifies the RTC Alarm Time members. */

    uint32_t RTC_AlarmMask;             /*!< Specifies the RTC Alarm Masks. */

    uint32_t RTC_AlarmMode;             /*!< Specifies the RTC Alarm is on Day or Week. */

    uint32_t RTC_AlarmDayOrWeek;        /*!< Specifies the RTC Alarm Day/Week. */
}RTC_AlarmTypeDef;
/**
  * @}
  */

/**
  * @brief  RTC Temper structure definition
  */
typedef struct 
{
    uint32_t u32_TemperEdge;    /*!< Specifies the RTC Temper edge select. */

    uint32_t u32_InterruptEN;   /*!< Specifies the RTC Temper interrupt enable.*/

    uint32_t u32_ClearBackup;   /*!< Specifies the RTC Temper clear backup register. */
                                       
    uint32_t u32_FilterClk;     /*!< Specifies the RTC Temper Filter Clock select. */

    uint32_t u32_Filter;        /*!< Specifies the RTC Temper Filter select.*/
}RTC_TemperTypeDef;
  
  

/* Exported functions --------------------------------------------------------*/

void RTC_DeInit(void);
void RTC_Init(uint32_t ClockSource);
void RTC_WriteProtectionCmd(uint32_t NewState);
void RTC_SetTime(uint32_t Format, RTC_TimeTypeDef* TimeStruct);
void RTC_TimeStructInit(RTC_TimeTypeDef* TimeStruct);
void RTC_GetTime(uint32_t Format, RTC_TimeTypeDef* TimeStruct);
void RTC_SetDate(uint32_t Format, RTC_DateTypeDef* DateStruct);
void RTC_DateStructInit(RTC_DateTypeDef* DateStruct);
void RTC_GetDate(uint32_t Format, RTC_DateTypeDef* DateStruct);
void RTC_SetAlarm(uint32_t Format, RTC_AlarmTypeDef* AlarmStruct);
void RTC_AlarmStructInit(RTC_AlarmTypeDef* AlarmStruct);
void RTC_GetAlarm(uint32_t Format, RTC_AlarmTypeDef* AlarmStruct);
void RTC_AlarmCmd(uint32_t NewState);
void RTC_FselOutputConfig(uint32_t Output);
void RTC_AdjustConfig(uint32_t AdjustSign, uint32_t AdjustValue);
void RTC_TamperTriggerEdgeConfig(uint32_t Tamper, uint32_t TamperEdge);
void RTC_TamperCmd(uint32_t Tamper, uint32_t NewState);
void RTC_TamperFilterCmd(uint32_t Tamper, uint32_t FilterState);
void RTC_TamperFilterPeriodConfig(uint32_t Tamper, uint32_t FilterPeriod);
void RTC_TamperFilterClockConfig(uint32_t FilterClock);
void RTC_TamperFallingClearBackpConfig(uint32_t Tamper, uint32_t TamperClear);
void RTC_TamperRasingClearBackpConfig(uint32_t Tamper, uint32_t TamperClear);
void RTC_WriteBackupRegister(uint32_t number, uint32_t Data);
uint32_t RTC_ReadBackupRegister(uint32_t number);
void RTC_ITConfig(uint32_t RTC_IT, uint32_t NewState);
FlagStatus RTC_GetFlagStatus(uint32_t RTC_FLAG);
void RTC_ClearFlag(uint32_t RTC_FLAG);
ITStatus RTC_GetITStatus(uint32_t RTC_IT);
void RTC_ClearITPendingBit(uint32_t RTC_IT);
uint8_t RTC_DecimalToBcd(uint8_t Value);
uint8_t RTC_BcdToDecimal(uint8_t Value);








#endif   


/************************ (C) COPYRIGHT AISINOCHIP *****END OF FILE****/




  
  

