
/******************************************************************************
*@file  : fxx_pmu.h
*@brief : Header file of PMU SPL module.
******************************************************************************/

#ifndef __FXX_PMU_H__
#define __FXX_PMU_H__

#include "fxx_std.h"

/****************  Bit definition for PMU CR Register  ***********************/
#define PMU_CR_WUFILEN2_6_Pos               ( 25U )
#define PMU_CR_WUFILEN2_6_Msk               ( 0x1FU << PMU_CR_WUFILEN2_6_Pos )
#define PMU_CR_WUFILEN2_6                   ( PMU_CR_WUFILEN2_6_Msk )
#define PMU_CR_WUFILEN2_6_0                 ( 0x1U << PMU_CR_WUFILEN2_6_Pos )
#define PMU_CR_WUFILEN2_6_1                 ( 0x2U << PMU_CR_WUFILEN2_6_Pos )
#define PMU_CR_WUFILEN2_6_2                 ( 0x4U << PMU_CR_WUFILEN2_6_Pos )
#define PMU_CR_WUFILEN2_6_3                 ( 0x8U << PMU_CR_WUFILEN2_6_Pos )
#define PMU_CR_WUFILEN2_6_4                 ( 0x10U << PMU_CR_WUFILEN2_6_Pos )

#define PMU_CR_WUFILEN1_Pos                 ( 24U )
#define PMU_CR_WUFILEN1_Msk                 ( 0x1U << PMU_CR_WUFILEN1_Pos )
#define PMU_CR_WUFILEN1                     ( PMU_CR_WUFILEN1_Msk )

#define PMU_CR_EWUP2_6_Pos                  ( 17U )
#define PMU_CR_EWUP2_6_Msk                  ( 0x1FU << PMU_CR_EWUP2_6_Pos )
#define PMU_CR_EWUP2_6                      ( PMU_CR_EWUP2_6_Msk )
#define PMU_CR_EWUP2_6_0                    ( 0x1U << PMU_CR_EWUP2_6_Pos )
#define PMU_CR_EWUP2_6_1                    ( 0x2U << PMU_CR_EWUP2_6_Pos )
#define PMU_CR_EWUP2_6_2                    ( 0x4U << PMU_CR_EWUP2_6_Pos )
#define PMU_CR_EWUP2_6_3                    ( 0x5U << PMU_CR_EWUP2_6_Pos )
#define PMU_CR_EWUP2_6_4                    ( 0x10U << PMU_CR_EWUP2_6_Pos )

#define PMU_CR_EWUP1_Pos                    ( 16U )
#define PMU_CR_EWUP1_Msk                    ( 0x1U << PMU_CR_EWUP1_Pos )
#define PMU_CR_EWUP1                        ( PMU_CR_EWUP1_Msk )

#define PMU_CR_BORRST_EN_Pos                ( 12U ) 
#define PMU_CR_BORRST_EN_Msk                ( 0x1U << PMU_CR_BORRST_EN_Pos )
#define PMU_CR_BORRST_EN                    ( PMU_CR_BORRST_EN_Msk ) 

#define PMU_CR_WK_TIME_Pos                  ( 9U ) 
#define PMU_CR_WK_TIME_Msk                  ( 0x7U << PMU_CR_WK_TIME_Pos )
#define PMU_CR_WK_TIME                      ( PMU_CR_WK_TIME_Msk ) 
#define PMU_CR_WK_TIME_0                    ( 0x1U << PMU_CR_WK_TIME_Pos ) 
#define PMU_CR_WK_TIME_1                    ( 0x2U << PMU_CR_WK_TIME_Pos )
#define PMU_CR_WK_TIME_2                    ( 0x4U << PMU_CR_WK_TIME_Pos )

#define PMU_CR_STB_EN_Pos                   ( 8U ) 
#define PMU_CR_STB_EN_Msk                   ( 0x1U << PMU_CR_STB_EN_Pos )
#define PMU_CR_STB_EN                       ( PMU_CR_STB_EN_Msk ) 

#define PMU_CR_BDRST_EN_Pos                 ( 6U ) 
#define PMU_CR_BDRST_EN_Msk                 ( 0x1U << PMU_CR_BDRST_EN_Pos )
#define PMU_CR_BDRST_EN                     ( PMU_CR_BDRST_EN_Msk ) 

#define PMU_CR_RTCEN_Pos                    ( 5U ) 
#define PMU_CR_RTCEN_Msk                    ( 0x1U << PMU_CR_RTCEN_Pos )
#define PMU_CR_RTCEN                        ( PMU_CR_RTCEN_Msk ) 

#define PMU_CR_RTCSEL_Pos                   ( 2U ) 
#define PMU_CR_RTCSEL_Msk                   ( 0x3U << PMU_CR_RTCSEL_Pos )
#define PMU_CR_RTCSEL                       ( PMU_CR_RTCSEL_Msk ) 
#define PMU_CR_RTCSEL_0                     ( 0x1U << PMU_CR_RTCSEL_Pos ) 
#define PMU_CR_RTCSEL_1                     ( 0x2U << PMU_CR_RTCSEL_Pos )

#define PMU_CR_CWUF_Pos                     ( 1U ) 
#define PMU_CR_CWUF_Msk                     ( 0x1U << PMU_CR_CWUF_Pos )
#define PMU_CR_CWUF                         ( PMU_CR_CWUF_Msk ) 

#define PMU_CR_CSBF_Pos                     ( 1U ) 
#define PMU_CR_CSBF_Msk                     ( 0x1U << PMU_CR_CSBF_Pos )
#define PMU_CR_CSBF                         ( PMU_CR_CSBF_Msk )


/****************  Bit definition for PMU SR Register  ***********************/
#define PMU_SR_BORN_Pos                     ( 16U )
#define PMU_SR_BORN_Msk                     ( 0x1U << PMU_SR_BORN_Pos )
#define PMU_SR_BORN                         (PMU_SR_BORN_Msk)

#define PMU_SR_BORWUF_Pos                   ( 13U )
#define PMU_SR_BORWUF_Msk                   ( 0x1U << PMU_SR_BORWUF_Pos )
#define PMU_SR_BORWUF                       ( PMU_SR_BORWUF_Msk )
 
#define PMU_SR_IWDTWUF_Pos                  ( 12U )
#define PMU_SR_IWDTWUF_Msk                  ( 0x1U << PMU_SR_IWDTWUF_Pos )
#define PMU_SR_IWDTWUF                      ( PMU_SR_IWDTWUF_Msk )

#define PMU_SR_RSTWUF_Pos                   ( 11U )
#define PMU_SR_RSTWUF_Msk                   ( 0x1U << PMU_SR_RSTWUF_Pos )
#define PMU_SR_RSTWUF                       ( PMU_SR_RSTWUF_Msk ) 

#define PMU_SR_RTCWUF_Pos                   ( 10U )
#define PMU_SR_RTCWUF_Msk                   ( 0x1U << PMU_SR_RTCWUF_Pos ) 
#define PMU_SR_RTCWUF                       ( PMU_SR_RTCWUF_Msk )

#define PMU_SR_WUPF2_6_Pos                  ( 2U ) 
#define PMU_SR_WUPF2_6_Msk                  ( 0x1FU << PMU_SR_WUPF2_6_Pos ) 
#define PMU_SR_WUPF2_6                      ( PMU_SR_WUPF2_6_Msk )
#define PMU_SR_WUPF2_6_0                    ( 0x1U << PMU_SR_WUPF2_6_Pos )
#define PMU_SR_WUPF2_6_1                    ( 0x2U << PMU_SR_WUPF2_6_Pos )
#define PMU_SR_WUPF2_6_2                    ( 0x4U << PMU_SR_WUPF2_6_Pos )
#define PMU_SR_WUPF2_6_3                    ( 0x8U << PMU_SR_WUPF2_6_Pos ) 
#define PMU_SR_WUPF2_6_4                    ( 0x10U << PMU_SR_WUPF2_6_Pos ) 

#define PMU_SR_WUPF1_Pos                    ( 1U )
#define PMU_SR_WUPF1_Msk                    ( 0x1U << PMU_SR_WUPF1_Pos )
#define PMU_SR_WUPF1                        ( PMU_SR_WUPF1_Msk )

#define PMU_SR_SBF_Pos                      ( 0U )
#define PMU_SR_SBF_Msk                      ( 0x1U << PMU_SR_SBF_Pos )
#define PMU_SR_SBF                          ( PMU_SR_SBF_Msk )


/****************  Bit definition for PMU IOSEL Register  ***********************/
#define PMU_IOSEL_PC15_VALUE_Pos            ( 10U )
#define PMU_IOSEL_PC15_VALUE_Msk            ( 0x1U << PMU_IOSEL_PC15_VALUE_Pos ) 
#define PMU_IOSEL_PC15_VALUE                ( PMU_IOSEL_PC15_VALUE_Msk )

#define PMU_IOSEL_PC14_VALUE_Pos            ( 9U )
#define PMU_IOSEL_PC14_VALUE_Msk            ( 0x1U << PMU_IOSEL_PC14_VALUE_Pos )
#define PMU_IOSEL_PC14_VALUE                ( PMU_IOSEL_PC14_VALUE_Msk )

#define PMU_IOSEL_PC13_VALUE_Pos            ( 8U )
#define PMU_IOSEL_PC13_VALUE_Msk            ( 0x1U << PMU_IOSEL_PC13_VALUE_Pos )
#define PMU_IOSEL_PC13_VALUE                ( PMU_IOSEL_PC13_VALUE_Msk )

#define PMU_IOSEL_PC15_SEL_Pos              ( 5U )
#define PMU_IOSEL_PC15_SEL_Msk              ( 0x3U << PMU_IOSEL_PC15_SEL_Pos )
#define PMU_IOSEL_PC15_SEL                  ( PMU_IOSEL_PC15_SEL_Msk )
#define PMU_IOSEL_PC15_SEL_0                ( 0x1U << PMU_IOSEL_PC15_SEL_Pos ) 
#define PMU_IOSEL_PC15_SEL_1                ( 0x2U << PMU_IOSEL_PC15_SEL_Pos )

#define PMU_IOSEL_PC14_SEL_Pos              ( 3U )
#define PMU_IOSEL_PC14_SEL_Msk              ( 0x3U << PMU_IOSEL_PC14_SEL_Pos )
#define PMU_IOSEL_PC14_SEL                  ( PMU_IOSEL_PC14_SEL_Msk ) 
#define PMU_IOSEL_PC14_SEL_0                ( 0x1U << PMU_IOSEL_PC14_SEL_Pos ) 
#define PMU_IOSEL_PC14_SEL_1                ( 0x2U << PMU_IOSEL_PC14_SEL_Pos )

#define PMU_IOSEL_PC13_SEL_Pos              ( 0U )
#define PMU_IOSEL_PC13_SEL_Msk              ( 0x3U << PMU_IOSEL_PC13_SEL_Pos )
#define PMU_IOSEL_PC13_SEL                  ( PMU_IOSEL_PC13_SEL_Msk )
#define PMU_IOSEL_PC13_SEL_0                ( 0x1U << PMU_IOSEL_PC13_SEL_Pos )
#define PMU_IOSEL_PC13_SEL_1                ( 0x2U << PMU_IOSEL_PC13_SEL_Pos )

/****************  Bit definition for PMU IOCR Register  ***********************/
#define PMU_IOCR_PC15_ADS_Pos               ( 22U )
#define PMU_IOCR_PC15_ADS_Msk               ( 0x1U << PMU_IOCR_PC15_ADS_Pos ) 
#define PMU_IOCR_PC15_ADS                   ( PMU_IOCR_PC15_ADS_Msk )

#define PMU_IOCR_PC15_IE_Pos                ( 21U )
#define PMU_IOCR_PC15_IE_Msk                ( 0x1U << PMU_IOCR_PC15_IE_Pos ) 
#define PMU_IOCR_PC15_IE                    ( PMU_IOCR_PC15_IE_Msk )

#define PMU_IOCR_PC15_SMT_Pos               ( 20U )
#define PMU_IOCR_PC15_SMT_Msk               ( 0x1U << PMU_IOCR_PC15_SMT_Pos ) 
#define PMU_IOCR_PC15_SMT                   ( PMU_IOCR_PC15_SMT_Msk )

#define PMU_IOCR_PC15_STH_Pos               ( 18U )
#define PMU_IOCR_PC15_STH_Msk               ( 0x3U << PMU_IOCR_PC15_STH_Pos ) 
#define PMU_IOCR_PC15_STH                   ( PMU_IOCR_PC15_STH_Msk )
#define PMU_IOCR_PC15_STH_0                 ( 0x1U << PMU_IOCR_PC15_STH_Pos ) 
#define PMU_IOCR_PC15_STH_1                 ( 0x2U << PMU_IOCR_PC15_STH_Pos )

#define PMU_IOCR_PC15_PD_Pos                ( 17U )
#define PMU_IOCR_PC15_PD_Msk                ( 0x1U << PMU_IOCR_PC15_PD_Pos ) 
#define PMU_IOCR_PC15_PD                    ( PMU_IOCR_PC15_PD_Msk )

#define PMU_IOCR_PC15_PU_Pos                ( 16U )
#define PMU_IOCR_PC15_PU_Msk                ( 0x1U << PMU_IOCR_PC15_PU_Pos ) 
#define PMU_IOCR_PC15_PU                    ( PMU_IOCR_PC15_PU_Msk )

#define PMU_IOCR_PC14_ADS_Pos               ( 14U )
#define PMU_IOCR_PC14_ADS_Msk               ( 0x1U << PMU_IOCR_PC14_ADS_Pos ) 
#define PMU_IOVR_PC14_ADS                   ( PMU_IOCR_PC14_ADS_Msk )

#define PMU_IOCR_PC14_IE_Pos                ( 13U )
#define PMU_IOCR_PC14_IE_Msk                ( 0x1U << PMU_IOCR_PC14_IE_Pos ) 
#define PMU_IOCR_PC14_IE                    ( PMU_IOCR_PC14_IE_Msk )

#define PMU_IOCR_PC14_SMT_Pos               ( 12U )
#define PMU_IOCR_PC14_SMT_Msk               ( 0x1U << PMU_IOCR_PC14_SMT_Pos ) 
#define PMU_IOCR_PC14_SMT                   ( PMU_IOCR_PC14_SMT_Msk )

#define PMU_IOCR_PC14_STH_Pos               ( 10U )
#define PMU_IOCR_PC14_STH_Msk               ( 0x3U << PMU_IOCR_PC14_STH_Pos ) 
#define PMU_IOCR_PC14_STH                   ( PMU_IOCR_PC14_STH_Msk )
#define PMU_IOCR_PC14_STH_0                 ( 0x1U << PMU_IOCR_PC14_STH_Pos ) 
#define PMU_IOCR_PC14_STH_1                 ( 0x2U << PMU_IOCR_PC14_STH_Pos )

#define PMU_IOCR_PC14_PD_Pos                ( 9U )
#define PMU_IOCR_PC14_PD_Msk                ( 0x1U << PMU_IOCR_PC14_PD_Pos ) 
#define PMU_IOCR_PC14_PD                    ( PMU_IOCR_PC14_PD_Msk )

#define PMU_IOCR_PC14_PU_Pos                ( 8U )
#define PMU_IOCR_PC14_PU_Msk                ( 0x1U << PMU_IOCR_PC14_PU_Pos ) 
#define PMU_IOCR_PC14_PU                    ( PMU_IOCR_PC14_PU_Msk )

#define PMU_IOCR_PC13_ADS_Pos               ( 6U )
#define PMU_IOCR_PC13_ADS_Msk               ( 0x1U << PMU_IOCR_PC13_ADS_Pos ) 
#define PMU_IOCR_PC13_ADS                   ( PMU_IOCR_PC13_ADS_Msk )

#define PMU_IOCR_PC13_IE_Pos                ( 5U )
#define PMU_IOCR_PC13_IE_Msk                ( 0x1U << PMU_IOCR_PC13_IE_Pos ) 
#define PMU_IOCR_PC13_IE                    ( PMU_IOCR_PC13_IE_Msk )

#define PMU_IOCR_PC13_SMT_Pos               ( 4U )
#define PMU_IOCR_PC13_SMT_Msk               ( 0x1U << PMU_IOCR_PC13_SMT_Pos ) 
#define PMU_IOCR_PC13_SMT                   ( PMU_IOCR_PC13_SMT_Msk )

#define PMU_IOCR_PC13_STH_Pos               ( 2U )
#define PMU_IOCR_PC13_STH_Msk               ( 0x3U << PMU_IOCR_PC13_STH_Pos ) 
#define PMU_IOCR_PC13_STH                   ( PMU_IOCR_PC13_STH_Msk )
#define PMU_IOCR_PC13_STH_0                 ( 0x1U << PMU_IOCR_PC13_STH_Pos ) 
#define PMU_IOCR_PC13_STH_1                 ( 0x2U << PMU_IOCR_PC13_STH_Pos )

#define PMU_IOCR_PC13_PD_Pos                ( 1U )
#define PMU_IOCR_PC13_PD_Msk                ( 0x1U << PMU_IOCR_PC13_PD_Pos ) 
#define PMU_IOCR_PC13_PD                    ( PMU_IOCR_PC13_PD_Msk )

#define PMU_IOCR_PC13_PU_Pos                ( 0U )
#define PMU_IOCR_PC13_PU_Msk                ( 0x1U << PMU_IOCR_PC13_PU_Pos ) 
#define PMU_IOCR_PC13_PU                    ( PMU_IOCR_PC13_PU_Msk )

/****************  Bit definition for PMU ANACR Register  ***********************/
#define PMU_ANACR_TRIM_REGU18_Pos           ( 27U )
#define PMU_ANACR_TRIM_REGU18_Msk           ( 0x7U << PMU_ANACR_TRIM_REGU18_Pos ) 
#define PMU_ANACR_TRIM_REGU18               ( PMU_ANACR_TRIM_REGU18_Msk )

#define PMU_ANACR_EN_REGU18_Pos             ( 26U )
#define PMU_ANACR_EN_REGU18_Msk             ( 0x1U << PMU_ANACR_EN_REGU18_Pos ) 
#define PMU_ANACR_EN_REGU18                 ( PMU_ANACR_EN_REGU18_Msk )

#define PMU_ANACR_BOR_CFG_Pos               ( 24U )
#define PMU_ANACR_BOR_CFG_Msk               ( 0x3U << PMU_ANACR_BOR_CFG_Pos ) 
#define PMU_ANACR_BOR_CFG                   ( PMU_ANACR_BOR_CFG_Msk )
#define PMU_ANACR_BOR_CFG_0                 ( 0x1U << PMU_ANACR_BOR_CFG_Pos ) 
#define PMU_ANACR_BOR_CFG_1                 ( 0x2U << PMU_ANACR_BOR_CFG_Pos )

#define PMU_ANACR_BOR_EN_Pos                ( 23U )
#define PMU_ANACR_BOR_EN_Msk                ( 0x3U << PMU_ANACR_BOR_EN_Pos ) 
#define PMU_ANACR_BOR_EN                    ( PMU_ANACR_BOR_EN_Msk )

#define PMU_ANACR_LPBGR_TRIM_Pos            ( 20U )
#define PMU_ANACR_LPBGR_TRIM_Msk            ( 0x7U << PMU_ANACR_LPBGR_TRIM_Pos ) 
#define PMU_ANACR_LPBGR_TRIM                ( PMU_ANACR_LPBGR_TRIM_Msk )

#define PMU_ANACR_RC32K_TRIM_Pos            ( 10U )
#define PMU_ANACR_RC32K_TRIM_Msk            ( 0x3FU << PMU_ANACR_RC32K_TRIM_Pos ) 
#define PMU_ANACR_RC32K_TRIM                ( PMU_ANACR_RC32K_TRIM_Msk )

#define PMU_ANACR_RC32KRDY_Pos              ( 9U )
#define PMU_ANACR_RC32KRDY_Msk              ( 0x1U << PMU_ANACR_RC32KRDY_Pos ) 
#define PMU_ANACR_RC32KRDY                  ( PMU_ANACR_RC32KRDY_Msk )

#define PMU_ANACR_RC32KEN_Pos               ( 8U )
#define PMU_ANACR_RC32KEN_Msk               ( 0x1U << PMU_ANACR_RC32KEN_Pos ) 
#define PMU_ANACR_RC32KEN                   ( PMU_ANACR_RC32KEN_Msk )

#define PMU_ANACR_XTLDRV_Pos                ( 3U )
#define PMU_ANACR_XTLDRV_Msk                ( 0x7U << PMU_ANACR_XTLDRV_Pos ) 
#define PMU_ANACR_XTLDRV                    ( PMU_ANACR_XTLDRV_Msk )
#define PMU_ANACR_XTLDRV_0                  ( 0x1U << PMU_ANACR_XTLDRV_Pos )
#define PMU_ANACR_XTLDRV_1                  ( 0x2U << PMU_ANACR_XTLDRV_Pos )
#define PMU_ANACR_XTLDRV_2                  ( 0x4U << PMU_ANACR_XTLDRV_Pos )

#define PMU_ANACR_XTLBYP_Pos                ( 2U )
#define PMU_ANACR_XTLBYP_Msk                ( 0x1U << PMU_ANACR_XTLBYP_Pos ) 
#define PMU_ANACR_XTLBYP                    ( PMU_ANACR_XTLBYP_Msk )

#define PMU_ANACR_XTLRDY_Pos                ( 1U )
#define PMU_ANACR_XTLRDY_Msk                ( 0x1U << PMU_ANACR_XTLRDY_Pos ) 
#define PMU_ANACR_XTLRDY                    ( PMU_ANACR_XTLRDY_Msk )

#define PMU_ANACR_XTLEN_Pos                 ( 0U )
#define PMU_ANACR_XTLEN_Msk                 ( 0x1U << PMU_ANACR_XTLEN_Pos ) 
#define PMU_ANACR_XTLEN                     ( PMU_ANACR_XTLEN_Msk )

/****************  Bit definition for PMU CR2 Register  ***********************/
#define PMU_CR2_WUPOL2_6_Pos                ( 1U )
#define PMU_CR2_WUPOL2_6_Msk                ( 0x1FU << PMU_CR2_WUPOL2_6_Pos ) 
#define PMU_CR2_WUPOL2_6                    ( PMU_CR2_WUPOL2_6_Msk )
#define PMU_CR2_WUPOL2_6_0                  ( 0x1U << PMU_CR2_WUPOL2_6_Pos )
#define PMU_CR2_WUPOL2_6_1                  ( 0x2U << PMU_CR2_WUPOL2_6_Pos ) 
#define PMU_CR2_WUPOL2_6_2                  ( 0x4U << PMU_CR2_WUPOL2_6_Pos ) 
#define PMU_CR2_WUPOL2_6_3                  ( 0x8U << PMU_CR2_WUPOL2_6_Pos ) 
#define PMU_CR2_WUPOL2_6_4                  ( 0x10U << PMU_CR2_WUPOL2_6_Pos ) 

#define PMU_CR2_WUPOL1_Pos                  ( 0U )
#define PMU_CR2_WUPOL1_Msk                  ( 0x1U << PMU_CR2_WUPOL1_Pos ) 
#define PMU_CR2_WUPOL1                      ( PMU_CR2_WUPOL1_Msk )


/** @brief  TIMEOUT
  */
#define PMU_RC32K_READY_TIMEOUT             (0xFFFU)
#define PMU_RC32K_UNREADY_TIMEOUT           (0xFFU)
#define PMU_XTL_READY_TIMEOUT               (0xFFFFU)
#define PMU_XTL_UNREADY_TIMEOUT             (0xFFFU)
/**
  * @}
  */

/** @defgroup PMU_State
  * @{
  */
#define PMU_STATE_DISABLE                   (0U)
#define PMU_STATE_ENABLE                    (1U)
#define IS_PMU_STATE(_STATE_)               (((_STATE_) == PMU_STATE_DISABLE)  || \
                                            ((_STATE_) == PMU_STATE_ENABLE))
/**
  * @}
  */ 

  
/** @defgroup PMU BOR detection Voltage 
  * @{
  */ 
#define PMU_BORVOLTAGE_2V_2V1               (0U)
#define PMU_BORVOLTAGE_2V2_2V3              (PMU_ANACR_BOR_CFG_0)
#define PMU_BORVOLTAGE_2V49_2V61            (PMU_ANACR_BOR_CFG_1)
#define PMU_BORVOLTAGE_2V77_2V9             (PMU_ANACR_BOR_CFG_0 | PMU_ANACR_BOR_CFG_1)
#define IS_PMU_BOR_VOLTAGE(__VOLTAGE__)     (((__VOLTAGE__) == PMU_BORVOLTAGE_2V_2V1)   || \
                                            ((__VOLTAGE__) == PMU_BORVOLTAGE_2V2_2V3)   || \
                                            ((__VOLTAGE__) == PMU_BORVOLTAGE_2V49_2V61) || \
                                            ((__VOLTAGE__) == PMU_BORVOLTAGE_2V77_2V9))
/**
  * @}
  */

/** @defgroup PMU Wakeup Pin
  * @{
  */
#define PMU_WAKEUP_PIN1                     (0x01U)
#define PMU_WAKEUP_PIN2                     (0x02U)
#define PMU_WAKEUP_PIN3                     (0x04U)
#define PMU_WAKEUP_PIN4                     (0x08U)
#define PMU_WAKEUP_PIN5                     (0x10U)
#define PMU_WAKEUP_PIN6                     (0x20U)
#define IS_PMU_WAKEUP_PIN(__PIN__)          (((__PIN__) == PMU_WAKEUP_PIN1) || \
                                            ((__PIN__) == PMU_WAKEUP_PIN2)  || \
                                            ((__PIN__) == PMU_WAKEUP_PIN3)  || \
                                            ((__PIN__) == PMU_WAKEUP_PIN4)  || \
                                            ((__PIN__) == PMU_WAKEUP_PIN5)  || \
                                            ((__PIN__) == PMU_WAKEUP_PIN6)) 
/**
  * @}
  */ 

/** @defgroup PMU Wakeup polarity
  * @{
  */
#define PMU_WAKEUP_POLARITY_RASING          (0U)
#define PMU_WAKEUP_POLARITY_FALLING         (1U)                      
#define IS_PMU_WAKEUP_POLARITY(__POL__)     (((__POL__) == PMU_WAKEUP_POLARITY_RASING)  || \
                                            ((__POL__) == PMU_WAKEUP_POLARITY_FALLING)) 
/**
  * @}
  */ 

/** @defgroup PMU lowpower mode entry 
  * @{
  */
#define PMU_LOWPOWRENTRY_WFI                (1U)
#define PMU_LOWPOWRENTRY_WFE                (2U)
#define IS_PMU_LOWPOWR_ENTRY(__ENTRY__)     (((__ENTRY__) == PMU_LOWPOWRENTRY_WFI) || \
                                            ((__ENTRY__) == PMU_LOWPOWRENTRY_WFE))
/**
  * @}
  */  

/** @defgroup PMU Wakeup wait time
  * @{
  */
#define PMU_STANDBYWAKEWAIT_1               (0U)
#define PMU_STANDBYWAKEWAIT_2               (PMU_CR_WK_TIME_0)
#define PMU_STANDBYWAKEWAIT_3               (PMU_CR_WK_TIME_1)
#define PMU_STANDBYWAKEWAIT_4               (PMU_CR_WK_TIME_0 | PMU_CR_WK_TIME_1)
#define PMU_STANDBYWAKEWAIT_5               (PMU_CR_WK_TIME_2)
#define PMU_STANDBYWAKEWAIT_6               (PMU_CR_WK_TIME_0 | PMU_CR_WK_TIME_2)
#define PMU_STANDBYWAKEWAIT_7               (PMU_CR_WK_TIME_1 | PMU_CR_WK_TIME_2)
#define PMU_STANDBYWAKEWAIT_NONE            (PMU_CR_WK_TIME_0 | PMU_CR_WK_TIME_1 | PMU_CR_WK_TIME_2)                          
#define IS_PMU_STANDBY_WAIT(__WAIT__)       (((__WAIT__) == PMU_STANDBYWAKEWAIT_1)  || \
                                            ((__WAIT__) == PMU_STANDBYWAKEWAIT_2)   || \
                                            ((__WAIT__) == PMU_STANDBYWAKEWAIT_3)   || \
                                            ((__WAIT__) == PMU_STANDBYWAKEWAIT_4)   || \
                                            ((__WAIT__) == PMU_STANDBYWAKEWAIT_5)   || \
                                            ((__WAIT__) == PMU_STANDBYWAKEWAIT_6)   || \
                                            ((__WAIT__) == PMU_STANDBYWAKEWAIT_7)   || \
                                            ((__WAIT__) == PMU_STANDBYWAKEWAIT_NONE)) 
/**
  * @}
  */   

/** @defgroup PMU Flag 
  * @{
  */
#define PMU_FLAG_SB                         (PMU_SR_SBF)
#define PMU_FLAG_WUPF1                      (PMU_SR_WUPF1)
#define PMU_FLAG_WUPF2                      (PMU_SR_WUPF2_6_0)
#define PMU_FLAG_WUPF3                      (PMU_SR_WUPF2_6_1)
#define PMU_FLAG_WUPF4                      (PMU_SR_WUPF2_6_2)
#define PMU_FLAG_WUPF5                      (PMU_SR_WUPF2_6_3)
#define PMU_FLAG_WUPF6                      (PMU_SR_WUPF2_6_4)
#define PMU_FLAG_RTC                        (PMU_SR_RTCWUF)
#define PMU_FLAG_RST                        (PMU_SR_RSTWUF)
#define PMU_FLAG_IWDT                       (PMU_SR_IWDTWUF)
#define PMU_FLAG_BOR                        (PMU_SR_BORWUF)
#define PMU_FLAG_ALL                        (0x0000FFFFU)
#define IS_PMU_FLAG(__FLAG__)               ((__FLAG__) <= PMU_FLAG_ALL)

/**
  * @}
  */

/** @defgroup STANDBY domain IO  
  * @{
  */
#define PMU_PIN_PC13                        (0U)
#define PMU_PIN_PC14                        (3U)
#define PMU_PIN_PC15                        (5U)
#define IS_PMU_PIN(PIN)                     (((PIN) == PMU_PIN_PC13)    || \
                                            ((PIN) == PMU_PIN_PC14)     || \
                                            ((PIN) == PMU_PIN_PC15))
/**
  * @}
  */

/** @defgroup PMU domain IO function selection  
  * @{
  */
#define PMU_PIN_FUNCTION_GPIO               (0U)
#define PMU_PIN_FUNCTION_PC14_PC15_VALUE    (1U)
#define PMU_PIN_FUNCTION_PC13_RTC_SIGNAL    (1U)
#define PMU_PIN_FUNCTION_PC13_TAMPER        (2U)
#define PMU_PIN_FUNCTION_PC13_VALUE         (3U)
#define IS_PMU_PIN_FUNCTION(__FUNC__)       (((__FUNC__) == PMU_PIN_FUNCTION_GPIO)              || \
                                            ((__FUNC__) == PMU_PIN_FUNCTION_PC14_PC15_VALUE)    || \
                                            ((__FUNC__) == PMU_PIN_FUNCTION_PC13_RTC_SIGNAL)    || \
                                            ((__FUNC__) == PMU_PIN_FUNCTION_PC13_TAMPER)        || \
                                            ((__FUNC__) == PMU_PIN_FUNCTION_PC13_VALUE))
/**
  * @}
  */

/** @defgroup PMU domain IO Pin Value 
  * @{
  */
#define PMU_PIN_VALUE_0                     (0U)
#define PMU_PIN_VALUE_1                     (1U)
#define IS_PMU_PIN_VALUE(__VALUE__)         (((__VALUE__) == PMU_PIN_VALUE_0) || \
                                            ((__VALUE__) == PMU_PIN_VALUE_1))
/**
  * @}
  */
  
/** @defgroup PMU domain IO mode 
  * @{
  */
#define PMU_PIN_DIGITAL                     (0U)
#define PMU_PIN_ANALOG                      (1U)
#define IS_PMU_PIN_MODE(__MODE__)           (((__MODE__) == PMU_PIN_DIGITAL)    || \
                                            ((__MODE__) == PMU_PIN_ANALOG))
/**
  * @}
  */

/** @defgroup PMU domain IO Pin (PC13) output mode 
  * @{
  */
#define PMU_PIN_PC13_OD                     (0U)
#define PMU_PIN_PC13_PP                     (1U)
#define IS_PMU_PIN_PC13_OUTPUT(__MODE__)    (((__MODE__) == PMU_PIN_PC13_OD) || \
                                            ((__MODE__) == PMU_PIN_PC13_PP))
/**
  * @}
  */

/** @defgroup PMU domain IO pull 
  * @{
  */
#define PMU_PIN_PULLUP                      (1U)
#define PMU_PIN_PULLDOWN                    (2U)
#define IS_PMU_PIN_PULL(__PULL__)           (((__PULL__) == PMU_PIN_PULLUP) || \
                                            ((__PULL__) == PMU_PIN_PULLDOWN))
/**
  * @}
  */  

/**
  * @brief  RTC clock
  */
#define PMU_RTC_CLK_RC32K                   (0U)  
#define PMU_RTC_CLK_XTL                     (PMU_CR_RTCSEL_0)  
#define IS_PMU_RTC_CLK(__CLK__)             (((__CLK__) == PMU_RTC_CLK_RC32K)   || \
                                            ((__CLK__) == PMU_RTC_CLK_XTL))
/**
  * @}
  */ 
  
/** @defgroup XTL power mode
  * @{
  */
#define PMU_XTL_NORMAL                      (0U)
#define PMU_XTL_LOWPOWER                    (PMU_ANACR_XTLDRV_2)
#define IS_PMU_XTL_MODE(__MODE__)           (((__MODE__) == PMU_XTL_NORMAL)  || \
                                            ((__MODE__) == PMU_XTL_LOWPOWER))
/**
  * @}
  */ 

/** @defgroup XTL drive capability
  * @{
  */
#define PMU_XTL_DRIVE_LOW                   (0U)
#define PMU_XTL_DRIVE_HIGH                  (PMU_ANACR_XTLDRV_0 | PMU_ANACR_XTLDRV_1)
#define IS_PMU_XTL_DRIVE(__DRIVE__)         (((__DRIVE__) == PMU_XTL_DRIVE_LOW) || \
                                            ((__DRIVE__) == PMU_XTL_DRIVE_HIGH))
/**
  * @}
  */ 



/* Exported functions --------------------------------------------------------*/

void PMU_DeInit(void);
void PMU_Init(void);
void PMU_BORVoltageConfig(uint32_t PMU_BORVoltage);
void PMU_BORCmd(uint32_t NewState);
void PMU_BORResetCmd(uint32_t NewState);
void PMU_WakeupPinCmd(uint32_t PMU_WakeupPinx, uint32_t NewState);
void PMU_WakeupPinFilterCmd(uint32_t PMU_WakeupPinx, uint32_t NewState);
void PMU_WakeupPinPolarityConfig(uint32_t PMU_WakeupPinx, uint32_t PMU_WakeupPolarity);
void PMU_EnterSleepMode(uint8_t PMU_SleepEntry);
void PMU_EnterStopMode(uint8_t PMU_StopEntry);
void PMU_EnterStandbyMode(uint8_t PMU_StandbyEntry);
void PMU_SetStandbyWakeWaitTime(uint32_t PMU_StandbyWaitTime);
FlagStatus PMU_GetFlagStatus(uint32_t PMU_Flag);
void PMU_ClearFlag(uint32_t PMU_Flag);
void PMU_PMUDomainPinFunction(uint32_t PMU_Pin, uint32_t PMU_Func);
void PMU_SetPMUDomainPinValue(uint32_t PMU_Pin, uint32_t PMU_PinValue);
uint32_t PMU_GetPMUDomainPinValue(uint32_t PMU_Pin);
void PMU_PMUDomainPinMode(uint32_t PMU_Pin, uint32_t PMU_Mode);
void PMU_PMUDomainPinPC13OutputType(uint32_t type);
void PMU_PMUDomainPinPull(uint32_t PMU_Pin, uint32_t PMU_Pull);
uint8_t PMU_RC32KCmd(uint32_t NewState);
uint8_t PMU_XTLCmd(uint32_t NewState);
void PMU_XTLDriveConfig(uint32_t mode, uint32_t drive);
void PMU_XTLBypassCmd(uint32_t NewState);
void PMU_RTCClkCmd(uint32_t NewState);
void PMU_RTCClkSelect(uint32_t clock);     





  


#endif


/************************ (C) COPYRIGHT AISINOCHIP *****END OF FILE****/





