
/******************************************************************************
*@file  : fxx_iwdt.h
*@brief : Header file of IWDT SPL module.
******************************************************************************/

#ifndef __FXX_IWDT_H__
#define __FXX_IWDT_H__

#include "fxx_std.h"


/****************  Bit definition for IWDT register  ***********************/
/***************  Bits definition for IWDT_CMDR register  ********************/

#define IWDT_CMDR_CMD_Pos                       ( 0U )
#define IWDT_CMDR_CMD_Msk                       ( 0xFFFFU << IWDT_CMDR_CMD_Pos )
#define IWDT_CMDR_CMD                           ( IWDT_CMDR_CMD_Msk )


/***************  Bits definition for IWDT_PR register  **********************/

#define IWDT_PR_PR_Pos                          ( 0U )
#define IWDT_PR_PR_Msk                          ( 0x7U << IWDT_PR_PR_Pos )
#define IWDT_PR_PR                              ( IWDT_PR_PR_Msk )
#define IWDT_PR_PR_0                            ( 0x1U << IWDT_PR_PR_Pos )
#define IWDT_PR_PR_1                            ( 0x2U << IWDT_PR_PR_Pos )
#define IWDT_PR_PR_2                            ( 0x4U << IWDT_PR_PR_Pos )


/***************  Bits definition for IWDT_RLR register  *********************/

#define IWDT_RLR_PL_Pos                         ( 0U )
#define IWDT_RLR_PL_Msk                         ( 0xFFFU << IWDT_RLR_PL_Pos )
#define IWDT_RLR_PL                             ( IWDT_RLR_PL_Msk )


/***************  Bits definition for IWDT_SR register  **********************/

#define IWDT_SR_RLF_Pos                         ( 4U )
#define IWDT_SR_RLF_Msk                         ( 0x1U << IWDT_SR_RLF_Pos )
#define IWDT_SR_RLF                             ( IWDT_SR_RLF_Msk )

#define IWDT_SR_WTU_Pos                         ( 3U )
#define IWDT_SR_WTU_Msk                         ( 0x1U << IWDT_SR_WTU_Pos )
#define IWDT_SR_WTU                             ( IWDT_SR_WTU_Msk )

#define IWDT_SR_WVU_Pos                         ( 2U )
#define IWDT_SR_WVU_Msk                         ( 0x1U << IWDT_SR_WVU_Pos )
#define IWDT_SR_WVU                             ( IWDT_SR_WVU_Msk )

#define IWDT_SR_RVU_Pos                         ( 1U )
#define IWDT_SR_RVU_Msk                         ( 0x1U << IWDT_SR_RVU_Pos )
#define IWDT_SR_RVU                             ( IWDT_SR_RVU_Msk )

#define IWDT_SR_PVU_Pos                         ( 0U )
#define IWDT_SR_PVU_Msk                         ( 0x1U << IWDT_SR_PVU_Pos )
#define IWDT_SR_PVU                             ( IWDT_SR_PVU_Msk )


/***************  Bits definition for IWDT_WINR register  ********************/

#define IWDT_WINR_WIN_Pos                       ( 0U )
#define IWDT_WINR_WIN_Msk                       ( 0xFFFU << IWDT_WINR_WIN_Pos )
#define IWDT_WINR_WIN                           ( IWDT_WINR_WIN_Msk )


/***************  Bits definition for IWDT_WUTR register  ********************/

#define IWDT_WUTR_WUT_Pos                       ( 0U )
#define IWDT_WUTR_WUT_Msk                       ( 0xFFFU << IWDT_WUTR_WUT_Pos )
#define IWDT_WUTR_WUT                           ( IWDT_WUTR_WUT_Msk )
          


/** @defgroup IWDT_Cmd
  * @{
  */
#define IWDT_CMD_ENABLE                         (0xCCCCU)
#define IWDT_CMD_WRITE_ENABLE                   (0x5555U)
#define IWDT_CMD_WRITE_DISABLE                  (0x0000U)
#define IWDT_CMD_WAKEUP_ENABLE                  (0x6666U)
#define IWDT_CMD_WAKEUP_DISABLE                 (0x9999U)
#define IWDT_CMD_RELOAD                         (0xAAAAU)
#define IWDT_CMD_DISABLE                        (0xEF01ABCD)
/**
  * @}
  */
  
/** @defgroup IWDT_Clock_Prescaler
  * @{
  */
#define IWDT_CLOCK_PRESCALER_4                  (0U)
#define IWDT_CLOCK_PRESCALER_8                  (1U)
#define IWDT_CLOCK_PRESCALER_16                 (2U)
#define IWDT_CLOCK_PRESCALER_32                 (3U)
#define IWDT_CLOCK_PRESCALER_64                 (4U)
#define IWDT_CLOCK_PRESCALER_128                (5U)
#define IWDT_CLOCK_PRESCALER_256                (6U)
#define IWDT_CLOCK_PRESCALER_256_1              (7U)
#define IS_IWDT_PRESCALER(__PRESCALER__)        (((__PRESCALER__) == IWDT_CLOCK_PRESCALER_4)    || \
                                                ((__PRESCALER__) == IWDT_CLOCK_PRESCALER_8)     || \
                                                ((__PRESCALER__) == IWDT_CLOCK_PRESCALER_16)    || \
                                                ((__PRESCALER__) == IWDT_CLOCK_PRESCALER_32)    || \
                                                ((__PRESCALER__) == IWDT_CLOCK_PRESCALER_64)    || \
                                                ((__PRESCALER__) == IWDT_CLOCK_PRESCALER_128)   || \
                                                ((__PRESCALER__) == IWDT_CLOCK_PRESCALER_256)   || \
                                                ((__PRESCALER__) == IWDT_CLOCK_PRESCALER_256_1))
/**
  * @}
  */
  
/** @defgroup IWDT_Flag
  * @{
  */
#define IWDT_FLAG_PVU                           (IWDT_SR_PVU)
#define IWDT_FLAG_RVU                           (IWDT_SR_RVU)
#define IWDT_FLAG_WVU                           (IWDT_SR_WVU)
#define IWDT_FLAG_WTU                           (IWDT_SR_WTU)
#define IWDT_FLAG_RLF                           (IWDT_SR_RLF)
#define IS_IWDT_FLAGS(__FLAGS__)                (((__FLAGS__) == IWDT_FLAG_PVU)     || \
                                                ((__FLAGS__) == IWDT_FLAG_RVU)      || \
                                                ((__FLAGS__) == IWDT_FLAG_WVU)      || \
                                                ((__FLAGS__) == IWDT_FLAG_WTU)      || \
                                                ((__FLAGS__) == IWDT_FLAG_RLF))
/**
  * @}
  */
  
/**
  * @brief   IWDT EXTI Line number
  */ 
#define IWDT_EXTI_LINE                          (EXTI_LINE_19)

/**
  * @brief   IWDT max value
  */
  
#define IWDT_MAX_VALUE                          (0x0FFFU)
#define IS_IWDT_RELOAD(__RELOAD__)              ((__RELOAD__) <= IWDT_MAX_VALUE)
#define IS_IWDT_WINDOW(__WINDOW__)              ((__WINDOW__) <= IWDT_MAX_VALUE)
#define IS_IWDT_WAKEUP(__WAKEUP__)              ((__WAKEUP__) <= IWDT_MAX_VALUE)
/**
  * @}
  */
  
/** @defgroup IWDT_TIMEOUT
  * @{
  */
  
#define IWDT_PVU_TIMEOUT                        (30U)
#define IWDT_RVU_TIMEOUT                        (30U)
#define IWDT_WVU_TIMEOUT                        (30U)
#define IWDT_WTU_TIMEOUT                        (30U)
#define IWDT_RLF_TIMEOUT                        (30U)

/**
  * @}
  */
  
/** @defgroup IWDT_State
  * @{
  */
#define IWDT_STATE_DISABLE                      (0U)
#define IWDT_STATE_ENABLE                       (1U)
#define IS_IWDT_STATE(_STATE_)                  (((_STATE_) == IWDT_STATE_DISABLE)  || \
                                                ((_STATE_) == IWDT_STATE_ENABLE))
/**
  * @}
  */  
  
/* Exported functions --------------------------------------------------------*/

void IWDT_WriteAccessCmd(uint32_t NewState);
void IWDT_WakeupCmd(uint32_t NewState);
void IWDT_ResetCmd(uint32_t NewState);
void IWDT_Cmd(uint32_t NewState);
void IWDT_FeedDog(void);
void IWDT_SetPrescaler(uint32_t Prescaler);
void IWDT_SetReload(uint32_t Reload);
void IWDT_SetWindow(uint32_t Window);
void IWDT_SetWakeup(uint32_t Wakeup);
void IWDT_Refresh(void);
FlagStatus IWDT_GetFlagStatus(uint32_t Flag);








#endif


