/***********************************************************************
*@file  : fxx_hrng.h
*@brief : Header file of HRNG SPL module.
 ***********************************************************************/
#ifndef __HRNG_H__
#define __HRNG_H__
#include "fxx_std.h"
	 

/*********************************************************************************
* Function Name  : HRNG_Initial
* Description    : intial hrng module
* Input          : None
* Output         : None
* Return         : None
*********************************************************************************/
void HRNG_Initial(void);

/*********************************************************************************
* Function Name  : HRNG_Source_Disable
* Description    : disable hrng source 
* Input          : None
* Output         : None
* Return         : None
*********************************************************************************/
void HRNG_Source_Disable(void);
	
/*********************************************************************************
* Function Name  : HRNG_GetHrng
* Description    : get random number
* Input          : byte_len :  the byte length of random number
* Output         : *hdata   :  the start address of random number the size must be 16bytes
* Return         : 0: hrng data is ok; 1: hrng data is bad
*********************************************************************************/
UINT8 HRNG_GetHrng(UINT8 *hdata, UINT32 byte_len);

#endif



