
/******************************************************************************
*@file  : fxx_comp.h
*@brief : COMP SPL module driver header file.
*@ver   : 1.0.0
*@date  : 2022.10.20
******************************************************************************/

#ifndef __fxx_COMP_H__
#define __fxx_COMP_H__

#include "fxx_std.h"

/***************  Bits definition for COMP_CR  **********************/

#define COMP_CR_LOCK_Pos                                   ( 31U )
#define COMP_CR_LOCK_Msk                                   ( 0x1UL << COMP_CR_LOCK_Pos )
#define COMP_CR_LOCK                                       ( COMP_CR_LOCK_Msk )

#define COMP_CR_BLANKTIME_Pos                              ( 29U )
#define COMP_CR_BLANKTIME_Msk                              ( 0x3UL << COMP_CR_BLANKTIME_Pos )
#define COMP_CR_BLANKTIME                                  ( COMP_CR_BLANKTIME_Msk )
#define COMP_CR_BLANKTIME_0                                ( 0x1UL << COMP_CR_BLANKTIME_Pos )
#define COMP_CR_BLANKTIME_1                                ( 0x2UL << COMP_CR_BLANKTIME_Pos )

#define COMP_CR_CRV_CFG_Pos                                ( 25U )
#define COMP_CR_CRV_CFG_Msk                                ( 0xfUL << COMP_CR_CRV_CFG_Pos )
#define COMP_CR_CRV_CFG                                    ( COMP_CR_CRV_CFG_Msk )
#define COMP_CR_CRV_CFG_0                                  ( 0x1UL << COMP_CR_CRV_CFG_Pos )
#define COMP_CR_CRV_CFG_1                                  ( 0x2UL << COMP_CR_CRV_CFG_Pos )
#define COMP_CR_CRV_CFG_2                                  ( 0x4UL << COMP_CR_CRV_CFG_Pos )
#define COMP_CR_CRV_CFG_3                                  ( 0x8UL << COMP_CR_CRV_CFG_Pos )

#define COMP_CR_CRV_SEL_Pos                                ( 24U )
#define COMP_CR_CRV_SEL_Msk                                ( 0x1UL << COMP_CR_CRV_SEL_Pos )
#define COMP_CR_CRV_SEL                                    ( COMP_CR_CRV_SEL_Msk )

#define COMP_CR_CRV_EN_Pos                                 ( 23U )
#define COMP_CR_CRV_EN_Msk                                 ( 0x1UL << COMP_CR_CRV_EN_Pos )
#define COMP_CR_CRV_EN                                     ( COMP_CR_CRV_EN_Msk )

#define COMP_CR_WINMODE_Pos                                ( 22U )
#define COMP_CR_WINMODE_Msk                                ( 0x1UL << COMP_CR_WINMODE_Pos )
#define COMP_CR_WINMODE                                    ( COMP_CR_WINMODE_Msk )

#define COMP_CR_WINOUT_Pos                                 ( 21U )
#define COMP_CR_WINOUT_Msk                                 ( 0x1UL << COMP_CR_WINOUT_Pos )
#define COMP_CR_WINOUT                                     ( COMP_CR_WINOUT_Msk )

#define COMP_CR_POLARITY_Pos                               ( 20U )
#define COMP_CR_POLARITY_Msk                               ( 0x1UL << COMP_CR_POLARITY_Pos )
#define COMP_CR_POLARITY                                   ( COMP_CR_POLARITY_Msk )

#define COMP_CR_FLTEN_Pos                                  ( 19U )
#define COMP_CR_FLTEN_Msk                                  ( 0x1UL << COMP_CR_FLTEN_Pos )
#define COMP_CR_FLTEN                                      ( COMP_CR_FLTEN_Msk )

#define COMP_CR_FLTTIME_Pos                                ( 16U )
#define COMP_CR_FLTTIME_Msk                                ( 0x7UL << COMP_CR_FLTTIME_Pos )
#define COMP_CR_FLTTIME                                    ( COMP_CR_FLTTIME_Msk )
#define COMP_CR_FLTTIME_0                                  ( 0x1UL << COMP_CR_FLTTIME_Pos )
#define COMP_CR_FLTTIME_1                                  ( 0x2UL << COMP_CR_FLTTIME_Pos )
#define COMP_CR_FLTTIME_2                                  ( 0x4UL << COMP_CR_FLTTIME_Pos )

#define COMP_CR_BLANKSEL_Pos                               ( 12U )
#define COMP_CR_BLANKSEL_Msk                               ( 0xfUL << COMP_CR_BLANKSEL_Pos )
#define COMP_CR_BLANKSEL                                   ( COMP_CR_BLANKSEL_Msk )
#define COMP_CR_BLANKSEL_0                                 ( 0x1UL << COMP_CR_BLANKSEL_Pos )
#define COMP_CR_BLANKSEL_1                                 ( 0x2UL << COMP_CR_BLANKSEL_Pos )
#define COMP_CR_BLANKSEL_2                                 ( 0x4UL << COMP_CR_BLANKSEL_Pos )
#define COMP_CR_BLANKSEL_3                                 ( 0x8UL << COMP_CR_BLANKSEL_Pos )

#define COMP_CR_INPSEL_Pos                                 ( 8U )
#define COMP_CR_INPSEL_Msk                                 ( 0xfUL << COMP_CR_INPSEL_Pos )
#define COMP_CR_INPSEL                                     ( COMP_CR_INPSEL_Msk )
#define COMP_CR_INPSEL_0                                   ( 0x1UL << COMP_CR_INPSEL_Pos )
#define COMP_CR_INPSEL_1                                   ( 0x2UL << COMP_CR_INPSEL_Pos )
#define COMP_CR_INPSEL_2                                   ( 0x4UL << COMP_CR_INPSEL_Pos )
#define COMP_CR_INPSEL_3                                   ( 0x8UL << COMP_CR_INPSEL_Pos )

#define COMP_CR_INMSEL_Pos                                 ( 4U )
#define COMP_CR_INMSEL_Msk                                 ( 0xfUL << COMP_CR_INMSEL_Pos )
#define COMP_CR_INMSEL                                     ( COMP_CR_INMSEL_Msk )
#define COMP_CR_INMSEL_0                                   ( 0x1UL << COMP_CR_INMSEL_Pos )
#define COMP_CR_INMSEL_1                                   ( 0x2UL << COMP_CR_INMSEL_Pos )
#define COMP_CR_INMSEL_2                                   ( 0x4UL << COMP_CR_INMSEL_Pos )
#define COMP_CR_INMSEL_3                                   ( 0x8UL << COMP_CR_INMSEL_Pos )

#define COMP_CR_HYS_Pos                                    ( 1U )
#define COMP_CR_HYS_Msk                                    ( 0x7UL << COMP_CR_HYS_Pos )
#define COMP_CR_HYS                                        ( COMP_CR_HYS_Msk )
#define COMP_CR_HYS_0                                      ( 0x1UL << COMP_CR_HYS_Pos )
#define COMP_CR_HYS_1                                      ( 0x2UL << COMP_CR_HYS_Pos )
#define COMP_CR_HYS_2                                      ( 0x4UL << COMP_CR_HYS_Pos )

#define COMP_CR_EN_Pos                                     ( 0U )
#define COMP_CR_EN_Msk                                     ( 0x1UL << COMP_CR_EN_Pos )
#define COMP_CR_EN                                         ( COMP_CR_EN_Msk )

/***************  Bits definition for COMP_SR  **********************/

#define COMP_SR_REV_Pos                                     ( 4U )
#define COMP_SR_REV_Msk                                     ( 0xfffffffUL << COMP_SR_REV_Pos )
#define COMP_SR_REV                                         ( COMP_SR_REV_Msk )

#define COMP_SR_VCOUT2_ORG_Pos                              ( 3U )
#define COMP_SR_VCOUT2_ORG_Msk                              ( 0x1UL << COMP_SR_VCOUT2_ORG_Pos )
#define COMP_SR_VCOUT2_ORG                                  ( COMP_SR_VCOUT2_ORG_Msk )

#define COMP_SR_VCOUT1_ORG_Pos                              ( 2U )
#define COMP_SR_VCOUT1_ORG_Msk                              ( 0x1UL << COMP_SR_VCOUT1_ORG_Pos )
#define COMP_SR_VCOUT1_ORG                                  ( COMP_SR_VCOUT1_ORG_Msk )

#define COMP_SR_VCOUT2_Pos                                  ( 1U )
#define COMP_SR_VCOUT2_Msk                                  ( 0x1UL << COMP_SR_VCOUT2_Pos )
#define COMP_SR_VCOUT2                                      ( COMP_SR_VCOUT2_Msk )

#define COMP_SR_VCOUT1_Pos                                  ( 0U )
#define COMP_SR_VCOUT1_Msk                                  ( 0x1UL << COMP_SR_VCOUT1_Pos )
#define COMP_SR_VCOUT1                                      ( COMP_SR_VCOUT1_Msk )

#define COMP1        (0x00)
#define COMP2        (0x04)

typedef struct
{
    uint32_t            InPSel;         //input plus select
    uint32_t            InMSel;         //input minus select
    uint32_t            Polarity;       //polarity 
    uint32_t            HYS;            //Hysteresis window
    uint32_t            BlankSel;       //blank source select
    uint32_t            WinMode;        //window mode input plus select
    uint32_t            WinOut;         //window mode output xor
    uint32_t            FltEn;          //filt enable
    uint32_t            FltTime;        //filt time
    uint32_t            CrvEn;          //reference voltage divide enable 
    uint32_t            CrvSel;         //reference voltage source select
    uint32_t            CrvCfg;         //reference voltage divider factor config 
	uint32_t			BlankTime;
}COMP_InitTypeDef;



#define COMP_CRVSEL_AVDD                    (0U)       
#define COMP_CRVSEL_VREF                    (COMP_CR_CRV_SEL)  

#define COMP_CRV_DISABLE                    (0U)       
#define COMP_CRV_ENABLE                     (COMP_CR_CRV_EN)   

#define COMP_WINMODE_SELF_INP               (0U)       
#define COMP_WINMODE_ANOTHER_INP            (COMP_CR_WINMODE)   

#define COMP_WINOUT_DIRECT                  (0U)       
#define COMP_WINOUT_XOR                     (COMP_CR_WINOUT)       
   

#define COMP_POLARITY_NOINVERT              (0U)   
#define COMP_POLARITY_INVERT                (COMP_CR_POLARITY)   

#define COMP_FLT_DISABLE                    (0U)       
#define COMP_FLT_ENABLE                     (COMP_CR_FLTEN)   

#define COMP_FLTTIME_1CLK                   (0U)   
#define COMP_FLTTIME_2CLK                   (1U << COMP_CR_FLTTIME_Pos)   
#define COMP_FLTTIME_4CLK                   (2U << COMP_CR_FLTTIME_Pos)   
#define COMP_FLTTIME_16CLK                  (3U << COMP_CR_FLTTIME_Pos)   
#define COMP_FLTTIME_64CLK                  (4U << COMP_CR_FLTTIME_Pos)   
#define COMP_FLTTIME_256CLK                 (5U << COMP_CR_FLTTIME_Pos)   
#define COMP_FLTTIME_1024CLK                (6U << COMP_CR_FLTTIME_Pos)   
#define COMP_FLTTIME_4095CLK                (7U << COMP_CR_FLTTIME_Pos)   
   
#define COMP_BLANKSEL_NONE                  (0U)
#define COMP_BLANKSEL_S1                    (1U << COMP_CR_BLANKSEL_Pos)   
#define COMP_BLANKSEL_S2                    (2U << COMP_CR_BLANKSEL_Pos) 
#define COMP_BLANKSEL_S3                    (3U << COMP_CR_BLANKSEL_Pos) 
#define COMP_BLANKSEL_S4                    (4U << COMP_CR_BLANKSEL_Pos) 
#define COMP_BLANKSEL_S5                    (5U << COMP_CR_BLANKSEL_Pos) 
#define COMP_BLANKSEL_S6                    (6U << COMP_CR_BLANKSEL_Pos) 
#define COMP_BLANKSEL_S7                    (7U << COMP_CR_BLANKSEL_Pos) 
#define COMP_BLANKSEL_S8                    (8U << COMP_CR_BLANKSEL_Pos) 
#define COMP_BLANKSEL_S9                    (9U << COMP_CR_BLANKSEL_Pos) 
#define COMP_BLANKSEL_S10                    (10U << COMP_CR_BLANKSEL_Pos) 
#define COMP_BLANKSEL_S11                    (11U << COMP_CR_BLANKSEL_Pos) 
#define COMP_BLANKSEL_S12                    (12U << COMP_CR_BLANKSEL_Pos) 
#define COMP_BLANKSEL_S13                    (13U << COMP_CR_BLANKSEL_Pos) 
#define COMP_BLANKSEL_S14                    (14U << COMP_CR_BLANKSEL_Pos) 
#define COMP_BLANKSEL_S15                    (15U << COMP_CR_BLANKSEL_Pos) 


#define COMP_INPSEL_P0                      (0U)   
#define COMP_INPSEL_P1                      (1U << COMP_CR_INPSEL_Pos)
#define COMP_INPSEL_P2                      (2U << COMP_CR_INPSEL_Pos)

#define COMP_INMSEL_P0                      (0U)   
#define COMP_INMSEL_P1                      (1U << COMP_CR_INMSEL_Pos)
#define COMP_INMSEL_P2						(2U << COMP_CR_INMSEL_Pos)
#define COMP_INMSEL_VREF_AVDD               (3U << COMP_CR_INMSEL_Pos)

 
#define COMP_HYS_NONE                       (0U) 
#define COMP_HYS_4                       (4U << COMP_CR_HYS_Pos) 
#define COMP_HYS_5                       (5U << COMP_CR_HYS_Pos) 
#define COMP_HYS_6                       (6U << COMP_CR_HYS_Pos) 
#define COMP_HYS_7                       (7U << COMP_CR_HYS_Pos) 

/** @defgroup COMP_OutputLevel
  * @{
  */ 
/* When output polarity is not inverted, comparator output is high when
   the non-inverting input is at a higher voltage than the inverting input */
#define COMP_OutputLevel_High                   ((uint32_t)0x00000001)
/* When output polarity is not inverted, comparator output is low when
   the non-inverting input is at a lower voltage than the inverting input*/
#define COMP_OutputLevel_Low                    ((uint32_t)0x00000000)

/**
  * @}
  */ 

#define IS_COMP_COMPx(_COMPx_)              (((_COMPx_) == COMP1) || \
                                             ((_COMPx_) == COMP2))

#define IS_COMP_CRVCFG(_CRVCFG_)            ((_CRVCFG_) <= 15U)

#define IS_COMP_CRVSEL(_CRVSEL_)            (((_CRVSEL_) == COMP_CRVSEL_AVDD) || \
                                             ((_CRVSEL_) == COMP_CRVSEL_VREF))
                                             
#define IS_COMP_CRVEN(_CRVEN_)              (((_CRVEN_) == COMP_CRV_DISABLE) || \
                                             ((_CRVEN_) == COMP_CRV_ENABLE))
                                       
#define IS_COMP_WINMODE(_WINMODE_)          (((_WINMODE_) == COMP_WINMODE_SELF_INP) || \
                                             ((_WINMODE_) == COMP_WINMODE_ANOTHER_INP))
                                           
#define IS_COMP_WINOUT(_WINOUT_)            (((_WINOUT_) == COMP_WINOUT_DIRECT) || \
                                             ((_WINOUT_) == COMP_WINOUT_XOR))
                                           
#define IS_COMP_POLARITY(_POLARITY_)        (((_POLARITY_) == COMP_POLARITY_NOINVERT) || \
                                             ((_POLARITY_) == COMP_POLARITY_INVERT))

#define IS_COMP_FLTEN(_FLTEN_)              (((_FLTEN_) == COMP_FLT_DISABLE) || \
                                             ((_FLTEN_) == COMP_FLT_ENABLE))

#define IS_COMP_FLTTIME(_FLTTIME_)          (((_FLTTIME_) == COMP_FLTTIME_1CLK) || \
                                             ((_FLTTIME_) == COMP_FLTTIME_2CLK) || \
                                             ((_FLTTIME_) == COMP_FLTTIME_4CLK) || \
                                             ((_FLTTIME_) == COMP_FLTTIME_16CLK) || \
                                             ((_FLTTIME_) == COMP_FLTTIME_64CLK) || \
                                             ((_FLTTIME_) == COMP_FLTTIME_256CLK) || \
                                             ((_FLTTIME_) == COMP_FLTTIME_1024CLK) || \
                                             ((_FLTTIME_) == COMP_FLTTIME_4095CLK))

#define IS_COMP_BLANKSEL(_BLANKSEL_)        (((_BLANKSEL_) == COMP_BLANKSEL_NONE) || \
                                             ((_BLANKSEL_) == COMP_BLANKSEL_S1) || \
                                             ((_BLANKSEL_) == COMP_BLANKSEL_S2) || \
                                             ((_BLANKSEL_) == COMP_BLANKSEL_S3) || \
                                             ((_BLANKSEL_) == COMP_BLANKSEL_S4) || \
                                             ((_BLANKSEL_) == COMP_BLANKSEL_S5) || \
                                             ((_BLANKSEL_) == COMP_BLANKSEL_S6) || \
                                             ((_BLANKSEL_) == COMP_BLANKSEL_S7) || \
                                             ((_BLANKSEL_) == COMP_BLANKSEL_S8) || \
                                             ((_BLANKSEL_) == COMP_BLANKSEL_S9) || \
                                             ((_BLANKSEL_) == COMP_BLANKSEL_S10) || \
                                             ((_BLANKSEL_) == COMP_BLANKSEL_S11) || \
                                             ((_BLANKSEL_) == COMP_BLANKSEL_S12) || \
                                             ((_BLANKSEL_) == COMP_BLANKSEL_S13) || \
                                             ((_BLANKSEL_) == COMP_BLANKSEL_S14) || \
                                             ((_BLANKSEL_) == COMP_BLANKSEL_S15))

#define IS_COMP_INPSEL(_INPSEL_)            (((_INPSEL_) == COMP_INPSEL_P0) || \
                                             ((_INPSEL_) == COMP_INPSEL_P1) || \
                                             ((_INPSEL_) == COMP_INPSEL_P2))   

#define IS_COMP_INMSEL(_INMSEL_)            (((_INMSEL_) == COMP_INMSEL_P0) || \
                                             ((_INMSEL_) == COMP_INMSEL_P1) || \
                                             ((_INMSEL_) == COMP_INMSEL_P2) || \
                                             ((_INMSEL_) == COMP_INMSEL_VREF_AVDD))

#define IS_COMP_HYS(_HYS_)                  (((_HYS_) == COMP_HYS_NONE) || \
                                             ((_HYS_) == COMP_HYS_4) || \
                                             ((_HYS_) == COMP_HYS_5) || \
                                             ((_HYS_) == COMP_HYS_6) || \
                                             ((_HYS_) == COMP_HYS_7))
                                             
                                             
void COMP_Init(uint32_t COMP_Selection, COMP_InitTypeDef* COMP_InitStruct);
void COMP_Cmd(uint32_t COMP_Selection, FunctionalState NewState);
void COMP_DeInit(uint32_t COMP_Selection);
uint32_t COMP_GetOutputLevel(uint32_t COMP_Selection);
void COMP_LockConfig(uint32_t COMP_Selection);
void COMP_StructInit(COMP_InitTypeDef* COMP_InitStruct);
#endif

