/******************************************************************************
*@file  : fxx_adc.h
*@brief : Header file of ADC SPL module.
******************************************************************************/

#ifndef __FXX_ADC_H__
#define __FXX_ADC_H__

#include "fxx_std.h"




/***************  Bits definition for ADC_SR register  ***********************/
#define ADC_SR_AWD_Pos                          ( 5U )
#define ADC_SR_AWD_Msk                          ( 0x1U << ADC_SR_AWD_Pos )
#define ADC_SR_AWD                              ( ADC_SR_AWD_Msk )

#define ADC_SR_OVERF_Pos                        ( 4U )
#define ADC_SR_OVERF_Msk                        ( 0x1U << ADC_SR_OVERF_Pos )
#define ADC_SR_OVERF                            ( ADC_SR_OVERF_Msk )

#define ADC_SR_EOG_Pos                          ( 3U )
#define ADC_SR_EOG_Msk                          ( 0x1U << ADC_SR_EOG_Pos )
#define ADC_SR_EOG                              ( ADC_SR_EOG_Msk )

#define ADC_SR_JEOC_Pos                         ( 2U )
#define ADC_SR_JEOC_Msk                         ( 0x1U << ADC_SR_JEOC_Pos )
#define ADC_SR_JEOC                             ( ADC_SR_JEOC_Msk )

#define ADC_SR_EOC_Pos                          ( 1U )
#define ADC_SR_EOC_Msk                          ( 0x1U << ADC_SR_EOC_Pos )
#define ADC_SR_EOC                              ( ADC_SR_EOC_Msk )

#define ADC_SR_ADRDY_Pos                        ( 0U )
#define ADC_SR_ADRDY_Msk                        ( 0x1U << ADC_SR_ADRDY_Pos )
#define ADC_SR_ADRDY                            ( ADC_SR_ADRDY_Msk )


/***************  Bits definition for ADC_IE register  ***********************/
#define ADC_IE_AWDIE_Pos                        ( 5U )
#define ADC_IE_AWDIE_Msk                        ( 0x1U << ADC_IE_AWDIE_Pos )
#define ADC_IE_AWDIE                            ( ADC_IE_AWDIE_Msk )

#define ADC_IE_OVERFIE_Pos                      ( 4U )
#define ADC_IE_OVERFIE_Msk                      ( 0x1U << ADC_IE_OVERFIE_Pos )
#define ADC_IE_OVERFIE                          ( ADC_IE_OVERFIE_Msk )

#define ADC_IE_EOGIE_Pos                        ( 3U )
#define ADC_IE_EOGIE_Msk                        ( 0x1U << ADC_IE_EOGIE_Pos )
#define ADC_IE_EOGIE                            ( ADC_IE_EOGIE_Msk )

#define ADC_IE_JEOCIE_Pos                       ( 2U )
#define ADC_IE_JEOCIE_Msk                       ( 0x1U << ADC_IE_JEOCIE_Pos )
#define ADC_IE_JEOCIE                           ( ADC_IE_JEOCIE_Msk )

#define ADC_IE_EOCIE_Pos                        ( 1U )
#define ADC_IE_EOCIE_Msk                        ( 0x1U << ADC_IE_EOCIE_Pos )
#define ADC_IE_EOCIE                            ( ADC_IE_EOCIE_Msk )


/***************  Bits definition for ADC_CR1 register  **********************/
#define ADC_CR1_AWDJCH_Pos                      ( 27U )
#define ADC_CR1_AWDJCH_Msk                      ( 0x1FU << ADC_CR1_AWDJCH_Pos )
#define ADC_CR1_AWDJCH                          ( ADC_CR1_AWDJCH_Msk )
#define ADC_CR1_AWDJCH_0                        ( 0x1U << ADC_CR1_AWDJCH_Pos )
#define ADC_CR1_AWDJCH_1                        ( 0x2U << ADC_CR1_AWDJCH_Pos )
#define ADC_CR1_AWDJCH_2                        ( 0x4U << ADC_CR1_AWDJCH_Pos )
#define ADC_CR1_AWDJCH_3                        ( 0x8U << ADC_CR1_AWDJCH_Pos )
#define ADC_CR1_AWDJCH_4                        ( 0x10U << ADC_CR1_AWDJCH_Pos )

#define ADC_CR1_DISCNUM_Pos                     ( 23U )
#define ADC_CR1_DISCNUM_Msk                     ( 0xFU << ADC_CR1_DISCNUM_Pos )
#define ADC_CR1_DISCNUM                         ( ADC_CR1_DISCNUM_Msk )
#define ADC_CR1_DISCNUM_0                       ( 0x1U << ADC_CR1_DISCNUM_Pos )
#define ADC_CR1_DISCNUM_1                       ( 0x2U << ADC_CR1_DISCNUM_Pos )
#define ADC_CR1_DISCNUM_2                       ( 0x4U << ADC_CR1_DISCNUM_Pos )
#define ADC_CR1_DISCNUM_3                       ( 0x8U << ADC_CR1_DISCNUM_Pos )

#define ADC_CR1_DISCEN_Pos                      ( 22U )
#define ADC_CR1_DISCEN_Msk                      ( 0x1U << ADC_CR1_DISCEN_Pos )
#define ADC_CR1_DISCEN                          ( ADC_CR1_DISCEN_Msk )

#define ADC_CR1_CONT_Pos                        ( 21U )
#define ADC_CR1_CONT_Msk                        ( 0x1U << ADC_CR1_CONT_Pos )
#define ADC_CR1_CONT                            ( ADC_CR1_CONT_Msk )

#define ADC_CR1_SWSTART_Pos                     ( 20U )
#define ADC_CR1_SWSTART_Msk                     ( 0x1U << ADC_CR1_SWSTART_Pos )
#define ADC_CR1_SWSTART                         ( ADC_CR1_SWSTART_Msk )

#define ADC_CR1_JSWSTART_Pos                    ( 19U )
#define ADC_CR1_JSWSTART_Msk                    ( 0x1U << ADC_CR1_JSWSTART_Pos )
#define ADC_CR1_JSWSTART                        ( ADC_CR1_JSWSTART_Msk )

#define ADC_CR1_EXTSEL_Pos                      ( 16U )
#define ADC_CR1_EXTSEL_Msk                      ( 0x7U << ADC_CR1_EXTSEL_Pos )
#define ADC_CR1_EXTSEL                          ( ADC_CR1_EXTSEL_Msk )
#define ADC_CR1_EXTSEL_0                        ( 0x1U << ADC_CR1_EXTSEL_Pos )
#define ADC_CR1_EXTSEL_1                        ( 0x2U << ADC_CR1_EXTSEL_Pos )
#define ADC_CR1_EXTSEL_2                        ( 0x4U << ADC_CR1_EXTSEL_Pos )

#define ADC_CR1_JEXTSEL_Pos                     ( 13U )
#define ADC_CR1_JEXTSEL_Msk                     ( 0x7U << ADC_CR1_JEXTSEL_Pos )
#define ADC_CR1_JEXTSEL                         ( ADC_CR1_JEXTSEL_Msk )
#define ADC_CR1_JEXTSEL_0                       ( 0x1U << ADC_CR1_JEXTSEL_Pos )
#define ADC_CR1_JEXTSEL_1                       ( 0x2U << ADC_CR1_JEXTSEL_Pos )
#define ADC_CR1_JEXTSEL_2                       ( 0x4U << ADC_CR1_JEXTSEL_Pos )

#define ADC_CR1_DMA_Pos                         ( 12U )
#define ADC_CR1_DMA_Msk                         ( 0x1U << ADC_CR1_DMA_Pos )
#define ADC_CR1_DMA                             ( ADC_CR1_DMA_Msk )

#define ADC_CR1_AWDEN_Pos                       ( 11U )
#define ADC_CR1_AWDEN_Msk                       ( 0x1U << ADC_CR1_AWDEN_Pos )
#define ADC_CR1_AWDEN                           ( ADC_CR1_AWDEN_Msk )

#define ADC_CR1_JAWDEN_Pos                      ( 10U )
#define ADC_CR1_JAWDEN_Msk                      ( 0x1U << ADC_CR1_JAWDEN_Pos )
#define ADC_CR1_JAWDEN                          ( ADC_CR1_JAWDEN_Msk )

#define ADC_CR1_JEN_Pos                         ( 9U )
#define ADC_CR1_JEN_Msk                         ( 0x1U << ADC_CR1_JEN_Pos )
#define ADC_CR1_JEN                             ( ADC_CR1_JEN_Msk )

#define ADC_CR1_AWDSGL_Pos                      ( 8U )
#define ADC_CR1_AWDSGL_Msk                      ( 0x1U << ADC_CR1_AWDSGL_Pos )
#define ADC_CR1_AWDSGL                          ( ADC_CR1_AWDSGL_Msk )

#define ADC_CR1_AWDCH_Pos                       ( 0U )
#define ADC_CR1_AWDCH_Msk                       ( 0x1FU << ADC_CR1_AWDCH_Pos )
#define ADC_CR1_AWDCH                           ( ADC_CR1_AWDCH_Msk )
#define ADC_CR1_AWDCH_0                         ( 0x1U << ADC_CR1_AWDCH_Pos )
#define ADC_CR1_AWDCH_1                         ( 0x2U << ADC_CR1_AWDCH_Pos )
#define ADC_CR1_AWDCH_2                         ( 0x4U << ADC_CR1_AWDCH_Pos )
#define ADC_CR1_AWDCH_3                         ( 0x8U << ADC_CR1_AWDCH_Pos )
#define ADC_CR1_AWDCH_4                         ( 0x10U << ADC_CR1_AWDCH_Pos )


/***************  Bits definition for ADC_CR2 register  **********************/
#define ADC_CR2_FASTMOD_Pos                     ( 27U )
#define ADC_CR2_FASTMOD_Msk                     ( 0x1U << ADC_CR2_FASTMOD_Pos )
#define ADC_CR2_FASTMOD                         ( ADC_CR2_FASTMOD_Msk )

#define ADC_CR2_AFERSTN_Pos                     ( 26U )
#define ADC_CR2_AFERSTN_Msk                     ( 0x1U << ADC_CR2_AFERSTN_Pos )
#define ADC_CR2_AFERSTN                         ( ADC_CR2_AFERSTN_Msk )

#define ADC_CR2_JOVSE_Pos                       ( 25U )
#define ADC_CR2_JOVSE_Msk                       ( 0x1U << ADC_CR2_JOVSE_Pos )
#define ADC_CR2_JOVSE                           ( ADC_CR2_JOVSE_Msk )

#define ADC_CR2_JTROVS_Pos                      ( 24U )
#define ADC_CR2_JTROVS_Msk                      ( 0x1U << ADC_CR2_JTROVS_Pos )
#define ADC_CR2_JTROVS                          ( ADC_CR2_JTROVS_Msk )

#define ADC_CR2_OVSS_Pos                        ( 20U )
#define ADC_CR2_OVSS_Msk                        ( 0xFU << ADC_CR2_OVSS_Pos )
#define ADC_CR2_OVSS                            ( ADC_CR2_OVSS_Msk )
#define ADC_CR2_OVSS_0                          ( 0x1U << ADC_CR2_OVSS_Pos )
#define ADC_CR2_OVSS_1                          ( 0x2U << ADC_CR2_OVSS_Pos )
#define ADC_CR2_OVSS_2                          ( 0x4U << ADC_CR2_OVSS_Pos )
#define ADC_CR2_OVSS_3                          ( 0x8U << ADC_CR2_OVSS_Pos )

#define ADC_CR2_OVSR_Pos                        ( 17U )
#define ADC_CR2_OVSR_Msk                        ( 0x7U << ADC_CR2_OVSR_Pos )
#define ADC_CR2_OVSR                            ( ADC_CR2_OVSR_Msk )
#define ADC_CR2_OVSR_0                          ( 0x1U << ADC_CR2_OVSR_Pos )
#define ADC_CR2_OVSR_1                          ( 0x2U << ADC_CR2_OVSR_Pos )
#define ADC_CR2_OVSR_2                          ( 0x4U << ADC_CR2_OVSR_Pos )

#define ADC_CR2_OVSE_Pos                        ( 16U )
#define ADC_CR2_OVSE_Msk                        ( 0x1U << ADC_CR2_OVSE_Pos )
#define ADC_CR2_OVSE                            ( ADC_CR2_OVSE_Msk )

#define ADC_CR2_BUFSTIME_Pos                    ( 8U )
#define ADC_CR2_BUFSTIME_Msk                    ( 0xFFU << ADC_CR2_BUFSTIME_Pos )
#define ADC_CR2_BUFSTIME                        ( ADC_CR2_BUFSTIME_Msk )

#define ADC_CR2_ENBUF_Pos                       ( 7U )
#define ADC_CR2_ENBUF_Msk                       ( 0x1U << ADC_CR2_ENBUF_Pos )
#define ADC_CR2_ENBUF                           ( ADC_CR2_ENBUF_Msk )

#define ADC_CR2_DIV_Pos                         ( 3U )
#define ADC_CR2_DIV_Msk                         ( 0xFU << ADC_CR2_DIV_Pos )
#define ADC_CR2_DIV                             ( ADC_CR2_DIV_Msk )
#define ADC_CR2_DIV_0                           ( 0x1U << ADC_CR2_DIV_Pos )
#define ADC_CR2_DIV_1                           ( 0x2U << ADC_CR2_DIV_Pos )
#define ADC_CR2_DIV_2                           ( 0x4U << ADC_CR2_DIV_Pos )
#define ADC_CR2_DIV_3                           ( 0x8U << ADC_CR2_DIV_Pos )

#define ADC_CR2_ADCSTP_Pos                      ( 2U )
#define ADC_CR2_ADCSTP_Msk                      ( 0x1U << ADC_CR2_ADCSTP_Pos )
#define ADC_CR2_ADCSTP                          ( ADC_CR2_ADCSTP_Msk )

#define ADC_CR2_OVRMOD_Pos                      ( 1U )
#define ADC_CR2_OVRMOD_Msk                      ( 0x1U << ADC_CR2_OVRMOD_Pos )
#define ADC_CR2_OVRMOD                          ( ADC_CR2_OVRMOD_Msk )

#define ADC_CR2_ADCEN_Pos                       ( 0U )
#define ADC_CR2_ADCEN_Msk                       ( 0x1U << ADC_CR2_ADCEN_Pos )
#define ADC_CR2_ADCEN                           ( ADC_CR2_ADCEN_Msk )


/***************  Bits definition for ADC_SMPR1 register  ********************/
#define ADC_SMPR1_SMP7_Pos                      ( 28U )
#define ADC_SMPR1_SMP7_Msk                      ( 0xFU << ADC_SMPR1_SMP7_Pos )
#define ADC_SMPR1_SMP7                          ( ADC_SMPR1_SMP7_Msk )

#define ADC_SMPR1_SMP6_Pos                      ( 24U )
#define ADC_SMPR1_SMP6_Msk                      ( 0xFU << ADC_SMPR1_SMP6_Pos )
#define ADC_SMPR1_SMP6                          ( ADC_SMPR1_SMP6_Msk )

#define ADC_SMPR1_SMP5_Pos                      ( 20U )
#define ADC_SMPR1_SMP5_Msk                      ( 0xFU << ADC_SMPR1_SMP5_Pos )
#define ADC_SMPR1_SMP5                          ( ADC_SMPR1_SMP5_Msk )

#define ADC_SMPR1_SMP4_Pos                      ( 16U )
#define ADC_SMPR1_SMP4_Msk                      ( 0xFU << ADC_SMPR1_SMP4_Pos )
#define ADC_SMPR1_SMP4                          ( ADC_SMPR1_SMP4_Msk )

#define ADC_SMPR1_SMP3_Pos                      ( 12U )
#define ADC_SMPR1_SMP3_Msk                      ( 0xFU << ADC_SMPR1_SMP3_Pos )
#define ADC_SMPR1_SMP3                          ( ADC_SMPR1_SMP3_Msk )

#define ADC_SMPR1_SMP2_Pos                      ( 8U )
#define ADC_SMPR1_SMP2_Msk                      ( 0xFU << ADC_SMPR1_SMP2_Pos )
#define ADC_SMPR1_SMP2                          ( ADC_SMPR1_SMP2_Msk )

#define ADC_SMPR1_SMP1_Pos                      ( 4U )
#define ADC_SMPR1_SMP1_Msk                      ( 0xFU << ADC_SMPR1_SMP1_Pos )
#define ADC_SMPR1_SMP1                          ( ADC_SMPR1_SMP1_Msk )

#define ADC_SMPR1_SMP0_Pos                      ( 0U )
#define ADC_SMPR1_SMP0_Msk                      ( 0xFU << ADC_SMPR1_SMP0_Pos )
#define ADC_SMPR1_SMP0                          ( ADC_SMPR1_SMP0_Msk )


/***************  Bits definition for ADC_SMPR2 register  ********************/
#define ADC_SMPR2_SMP15_Pos                     ( 28U )
#define ADC_SMPR2_SMP15_Msk                     ( 0xFU << ADC_SMPR2_SMP15_Pos )
#define ADC_SMPR2_SMP15                         ( ADC_SMPR2_SMP15_Msk )

#define ADC_SMPR2_SMP14_Pos                     ( 24U )
#define ADC_SMPR2_SMP14_Msk                     ( 0xFU << ADC_SMPR2_SMP14_Pos )
#define ADC_SMPR2_SMP14                         ( ADC_SMPR2_SMP14_Msk )

#define ADC_SMPR2_SMP13_Pos                     ( 20U )
#define ADC_SMPR2_SMP13_Msk                     ( 0xFU << ADC_SMPR2_SMP13_Pos )
#define ADC_SMPR2_SMP13                         ( ADC_SMPR2_SMP13_Msk )

#define ADC_SMPR2_SMP12_Pos                     ( 16U )
#define ADC_SMPR2_SMP12_Msk                     ( 0xFU << ADC_SMPR2_SMP12_Pos )
#define ADC_SMPR2_SMP12                         ( ADC_SMPR2_SMP12_Msk )

#define ADC_SMPR2_SMP11_Pos                     ( 12U )
#define ADC_SMPR2_SMP11_Msk                     ( 0xFU << ADC_SMPR2_SMP11_Pos )
#define ADC_SMPR2_SMP11                         ( ADC_SMPR2_SMP11_Msk )

#define ADC_SMPR2_SMP10_Pos                     ( 8U )
#define ADC_SMPR2_SMP10_Msk                     ( 0xFU << ADC_SMPR2_SMP10_Pos )
#define ADC_SMPR2_SMP10                         ( ADC_SMPR2_SMP10_Msk )

#define ADC_SMPR2_SMP9_Pos                      ( 4U )
#define ADC_SMPR2_SMP9_Msk                      ( 0xFU << ADC_SMPR2_SMP9_Pos )
#define ADC_SMPR2_SMP9                          ( ADC_SMPR2_SMP9_Msk )

#define ADC_SMPR2_SMP8_Pos                      ( 0U )
#define ADC_SMPR2_SMP8_Msk                      ( 0xFU << ADC_SMPR2_SMP8_Pos )
#define ADC_SMPR2_SMP8                          ( ADC_SMPR2_SMP8_Msk )


/***************  Bits definition for ADC_HTR register  **********************/
#define ADC_HTR_DHT_Pos                         ( 16U )
#define ADC_HTR_DHT_Msk                         ( 0xFFFU << ADC_HTR_DHT_Pos )
#define ADC_HTR_DHT                             ( ADC_HTR_DHT_Msk )

#define ADC_HTR_HT_Pos                          ( 0U )
#define ADC_HTR_HT_Msk                          ( 0xFFFU << ADC_HTR_HT_Pos )
#define ADC_HTR_HT                              ( ADC_HTR_HT_Msk )


/***************  Bits definition for ADC_LTR register  **********************/
#define ADC_LTR_DLT_Pos                         ( 16U )
#define ADC_LTR_DLT_Msk                         ( 0xFFFU << ADC_LTR_DLT_Pos )
#define ADC_LTR_DLT                             ( ADC_LTR_DLT_Msk )

#define ADC_LTR_LT_Pos                          ( 0U )
#define ADC_LTR_LT_Msk                          ( 0xFFFU << ADC_LTR_LT_Pos )
#define ADC_LTR_LT                              ( ADC_LTR_LT_Msk )


/***************  Bits definition for ADC_SQR1 register  *********************/
#define ADC_SQR1_SQ5_Pos                        ( 25U )
#define ADC_SQR1_SQ5_Msk                        ( 0x1FU << ADC_SQR1_SQ5_Pos )
#define ADC_SQR1_SQ5                            ( ADC_SQR1_SQ5_Msk )

#define ADC_SQR1_SQ4_Pos                        ( 20U )
#define ADC_SQR1_SQ4_Msk                        ( 0x1FU << ADC_SQR1_SQ4_Pos )
#define ADC_SQR1_SQ4                            ( ADC_SQR1_SQ4_Msk )

#define ADC_SQR1_SQ3_Pos                        ( 15U )
#define ADC_SQR1_SQ3_Msk                        ( 0x1FU << ADC_SQR1_SQ3_Pos )
#define ADC_SQR1_SQ3                            ( ADC_SQR1_SQ3_Msk )

#define ADC_SQR1_SQ2_Pos                        ( 10U )
#define ADC_SQR1_SQ2_Msk                        ( 0x1FU << ADC_SQR1_SQ2_Pos )
#define ADC_SQR1_SQ2                            ( ADC_SQR1_SQ2_Msk )

#define ADC_SQR1_SQ1_Pos                        ( 5U )
#define ADC_SQR1_SQ1_Msk                        ( 0x1FU << ADC_SQR1_SQ1_Pos )
#define ADC_SQR1_SQ1                            ( ADC_SQR1_SQ1_Msk )

#define ADC_SQR1_L_Pos                          ( 0U )
#define ADC_SQR1_L_Msk                          ( 0xFU << ADC_SQR1_L_Pos )
#define ADC_SQR1_L                              ( ADC_SQR1_L_Msk )


/***************  Bits definition for ADC_SQR2 register  *********************/
#define ADC_SQR2_SQ11_Pos                       ( 25U )
#define ADC_SQR2_SQ11_Msk                       ( 0x1FU << ADC_SQR2_SQ11_Pos )
#define ADC_SQR2_SQ11                           ( ADC_SQR2_SQ11_Msk )

#define ADC_SQR2_SQ10_Pos                       ( 20U )
#define ADC_SQR2_SQ10_Msk                       ( 0x1FU << ADC_SQR2_SQ10_Pos )
#define ADC_SQR2_SQ10                           ( ADC_SQR2_SQ10_Msk )

#define ADC_SQR2_SQ9_Pos                        ( 15U )
#define ADC_SQR2_SQ9_Msk                        ( 0x1FU << ADC_SQR2_SQ9_Pos )
#define ADC_SQR2_SQ9                            ( ADC_SQR2_SQ9_Msk )

#define ADC_SQR2_SQ8_Pos                        ( 10U )
#define ADC_SQR2_SQ8_Msk                        ( 0x1FU << ADC_SQR2_SQ8_Pos )
#define ADC_SQR2_SQ8                            ( ADC_SQR2_SQ8_Msk )

#define ADC_SQR2_SQ7_Pos                        ( 5U )
#define ADC_SQR2_SQ7_Msk                        ( 0x1FU << ADC_SQR2_SQ7_Pos )
#define ADC_SQR2_SQ7                            ( ADC_SQR2_SQ7_Msk )

#define ADC_SQR2_SQ6_Pos                        ( 0U )
#define ADC_SQR2_SQ6_Msk                        ( 0x1FU << ADC_SQR2_SQ6_Pos )
#define ADC_SQR2_SQ6                            ( ADC_SQR2_SQ6_Msk )


/***************  Bits definition for ADC_SQR3 register  *********************/
#define ADC_SQR3_SQ16_Pos                       ( 20U )
#define ADC_SQR3_SQ16_Msk                       ( 0x1FU << ADC_SQR3_SQ16_Pos )
#define ADC_SQR3_SQ16                           ( ADC_SQR3_SQ16_Msk )

#define ADC_SQR3_SQ15_Pos                       ( 15U )
#define ADC_SQR3_SQ15_Msk                       ( 0x1FU << ADC_SQR3_SQ15_Pos )
#define ADC_SQR3_SQ15                           ( ADC_SQR3_SQ15_Msk )

#define ADC_SQR3_SQ14_Pos                       ( 10U )
#define ADC_SQR3_SQ14_Msk                       ( 0x1FU << ADC_SQR3_SQ14_Pos )
#define ADC_SQR3_SQ14                           ( ADC_SQR3_SQ14_Msk )

#define ADC_SQR3_SQ13_Pos                       ( 5U )
#define ADC_SQR3_SQ13_Msk                       ( 0x1FU << ADC_SQR3_SQ13_Pos )
#define ADC_SQR3_SQ13                           ( ADC_SQR3_SQ13_Msk )

#define ADC_SQR3_SQ12_Pos                       ( 0U )
#define ADC_SQR3_SQ12_Msk                       ( 0x1FU << ADC_SQR3_SQ12_Pos )
#define ADC_SQR3_SQ12                           ( ADC_SQR3_SQ12_Msk )


/***************  Bits definition for ADC_JSQR register  *********************/
#define ADC_JSQR_JSQ_Pos                        ( 5U )
#define ADC_JSQR_JSQ_Msk                        ( 0x1FU << ADC_JSQR_JSQ_Pos )
#define ADC_JSQR_JSQ                            ( ADC_JSQR_JSQ_Msk )


/***************  Bits definition for ADC_JDRX register  *********************/
#define ADC_JDRX_JCH_Pos                        ( 16U )
#define ADC_JDRX_JCH_Msk                        ( 0x1FU << ADC_JDRX_JCH_Pos )
#define ADC_JDRX_JCH                            ( ADC_JDRX_JCH_Msk )

#define ADC_JDRX_JDATA_Pos                      ( 0U )
#define ADC_JDRX_JDATA_Msk                      ( 0xFFFFU << ADC_JDRX_JDATA_Pos )
#define ADC_JDRX_JDATA                          ( ADC_JDRX_JDATA_Msk )


/***************  Bits definition for ADC_DR register  ***********************/
#define ADC_DR_CH_Pos                           ( 16U )
#define ADC_DR_CH_Msk                           ( 0x1FU << ADC_DR_CH_Pos )
#define ADC_DR_CH                               ( ADC_DR_CH_Msk )

#define ADC_DR_DATA_Pos                         ( 0U )
#define ADC_DR_DATA_Msk                         ( 0xFFFFU << ADC_DR_DATA_Pos )
#define ADC_DR_DATA                             ( ADC_DR_DATA_Msk )


/***************  Bits definition for ADC_DIFF register  *********************/
#define ADC_DIFF_DIFF7_15_Pos                   ( 7U )
#define ADC_DIFF_DIFF7_15_Msk                   ( 0x1U << ADC_DIFF_DIFF7_15_Pos )
#define ADC_DIFF_DIFF7_15                       ( ADC_DIFF_DIFF7_15_Msk )

#define ADC_DIFF_DIFF6_14_Pos                   ( 6U )
#define ADC_DIFF_DIFF6_14_Msk                   ( 0x1U << ADC_DIFF_DIFF6_14_Pos )
#define ADC_DIFF_DIFF6_14                       ( ADC_DIFF_DIFF6_14_Msk )

#define ADC_DIFF_DIFF5_13_Pos                   ( 5U )
#define ADC_DIFF_DIFF5_13_Msk                   ( 0x1U << ADC_DIFF_DIFF5_13_Pos )
#define ADC_DIFF_DIFF5_13                       ( ADC_DIFF_DIFF5_13_Msk )

#define ADC_DIFF_DIFF4_12_Pos                   ( 4U )
#define ADC_DIFF_DIFF4_12_Msk                   ( 0x1U << ADC_DIFF_DIFF4_12_Pos )
#define ADC_DIFF_DIFF4_12                       ( ADC_DIFF_DIFF4_12_Msk )

#define ADC_DIFF_DIFF3_11_Pos                   ( 3U )
#define ADC_DIFF_DIFF3_11_Msk                   ( 0x1U << ADC_DIFF_DIFF3_11_Pos )
#define ADC_DIFF_DIFF3_11                       ( ADC_DIFF_DIFF3_11_Msk )

#define ADC_DIFF_DIFF2_10_Pos                   ( 2U )
#define ADC_DIFF_DIFF2_10_Msk                   ( 0x1U << ADC_DIFF_DIFF2_10_Pos )
#define ADC_DIFF_DIFF2_10                       ( ADC_DIFF_DIFF2_10_Msk )

#define ADC_DIFF_DIFF1_9_Pos                    ( 1U )
#define ADC_DIFF_DIFF1_9_Msk                    ( 0x1U << ADC_DIFF_DIFF1_9_Pos )
#define ADC_DIFF_DIFF1_9                        ( ADC_DIFF_DIFF1_9_Msk )

#define ADC_DIFF_DIFF0_8_Pos                    ( 0U )
#define ADC_DIFF_DIFF0_8_Msk                    ( 0x1U << ADC_DIFF_DIFF0_8_Pos )
#define ADC_DIFF_DIFF0_8                        ( ADC_DIFF_DIFF0_8_Msk )


/***************  Bits definition for ADC_SIGN register  *********************/
#define ADC_SIGN_SIGN7_15_Pos                   ( 7U )
#define ADC_SIGN_SIGN7_15_Msk                   ( 0x1U << ADC_SIGN_SIGN7_15_Pos )
#define ADC_SIGN_SIGN7_15                       ( ADC_SIGN_SIGN7_15_Msk )

#define ADC_SIGN_SIGN6_14_Pos                   ( 6U )
#define ADC_SIGN_SIGN6_14_Msk                   ( 0x1U << ADC_SIGN_SIGN6_14_Pos )
#define ADC_SIGN_SIGN6_14                       ( ADC_SIGN_SIGN6_14_Msk )

#define ADC_SIGN_SIGN5_13_Pos                   ( 5U )
#define ADC_SIGN_SIGN5_13_Msk                   ( 0x1U << ADC_SIGN_SIGN5_13_Pos )
#define ADC_SIGN_SIGN5_13                       ( ADC_SIGN_SIGN5_13_Msk )

#define ADC_SIGN_SIGN4_12_Pos                   ( 4U )
#define ADC_SIGN_SIGN4_12_Msk                   ( 0x1U << ADC_SIGN_SIGN4_12_Pos )
#define ADC_SIGN_SIGN4_12                       ( ADC_SIGN_SIGN4_12_Msk )

#define ADC_SIGN_SIGN3_11_Pos                   ( 3U )
#define ADC_SIGN_SIGN3_11_Msk                   ( 0x1U << ADC_SIGN_SIGN3_11_Pos )
#define ADC_SIGN_SIGN3_11                       ( ADC_SIGN_SIGN3_11_Msk )

#define ADC_SIGN_SIGN2_10_Pos                   ( 2U )
#define ADC_SIGN_SIGN2_10_Msk                   ( 0x1U << ADC_SIGN_SIGN2_10_Pos )
#define ADC_SIGN_SIGN2_10                       ( ADC_SIGN_SIGN2_10_Msk )

#define ADC_SIGN_SIGN1_9_Pos                    ( 1U )
#define ADC_SIGN_SIGN1_9_Msk                    ( 0x1U << ADC_SIGN_SIGN1_9_Pos )
#define ADC_SIGN_SIGN1_9                        ( ADC_SIGN_SIGN1_9_Msk )

#define ADC_SIGN_SIGN0_8_Pos                    ( 0U )
#define ADC_SIGN_SIGN0_8_Msk                    ( 0x1U << ADC_SIGN_SIGN0_8_Pos )
#define ADC_SIGN_SIGN0_8                        ( ADC_SIGN_SIGN0_8_Msk )

/***************  Bits definition for ADC_TSREF register  ********************/
#define ADC_TSREF_VREF1P2EN_Pos                 ( 31U )
#define ADC_TSREF_VREF1P2EN_Msk                 ( 0x1U << ADC_TSREF_VREF1P2EN_Pos )
#define ADC_TSREF_VREF1P2EN                     ( ADC_TSREF_VREF1P2EN_Msk )

#define ADC_TSREF_HIZEN_Pos                     ( 27U )
#define ADC_TSREF_HIZEN_Msk                     ( 0x1U << ADC_TSREF_HIZEN_Pos )
#define ADC_TSREF_HIZEN                         ( ADC_TSREF_HIZEN_Msk )

#define ADC_TSREF_VREFBISEL_Pos                 ( 25U )
#define ADC_TSREF_VREFBISEL_Msk                 ( 0x3U << ADC_TSREF_VREFBISEL_Pos )
#define ADC_TSREF_VREFBISEL                     ( ADC_TSREF_VREFBISEL_Msk )
#define ADC_TSREF_VREFBISEL_0                   ( 0x1U << ADC_TSREF_VREFBISEL_Pos )
#define ADC_TSREF_VREFBISEL_1                   ( 0x2U << ADC_TSREF_VREFBISEL_Pos )

#define ADC_TSREF_VREFBIEN_Pos                  ( 24U )
#define ADC_TSREF_VREFBIEN_Msk                  ( 0x1U << ADC_TSREF_VREFBIEN_Pos )
#define ADC_TSREF_VREFBIEN                      ( ADC_TSREF_VREFBIEN_Msk )

#define ADC_TSREF_VTRIM_Pos                     ( 19U )
#define ADC_TSREF_VTRIM_Msk                     ( 0x1FU << ADC_TSREF_VTRIM_Pos )
#define ADC_TSREF_VTRIM                         ( ADC_TSREF_VTRIM_Msk )

#define ADC_TSREF_TTRIM_Pos                     ( 15U )
#define ADC_TSREF_TTRIM_Msk                     ( 0xFU << ADC_TSREF_TTRIM_Pos )
#define ADC_TSREF_TTRIM                         ( ADC_TSREF_TTRIM_Msk )

#define ADC_TSREF_ALGMEAN_Pos                   ( 9U )
#define ADC_TSREF_ALGMEAN_Msk                   ( 0x3U << ADC_TSREF_ALGMEAN_Pos )
#define ADC_TSREF_ALGMEAN                       ( ADC_TSREF_ALGMEAN_Msk )
#define ADC_TSREF_ALGMEAN_0                     ( 0x1U << ADC_TSREF_ALGMEAN_Pos )
#define ADC_TSREF_ALGMEAN_1                     ( 0x2U << ADC_TSREF_ALGMEAN_Pos )

#define ADC_TSREF_ADJTDOS_Pos                   ( 5U )
#define ADC_TSREF_ADJTDOS_Msk                   ( 0xFU << ADC_TSREF_ADJTDOS_Pos )
#define ADC_TSREF_ADJTDOS                       ( ADC_TSREF_ADJTDOS_Msk )

#define ADC_TSREF_ADJTDGA_Pos                   ( 1U )
#define ADC_TSREF_ADJTDGA_Msk                   ( 0xFU << ADC_TSREF_ADJTDGA_Pos )
#define ADC_TSREF_ADJTDGA                       ( ADC_TSREF_ADJTDGA_Msk )

#define ADC_TSREF_ENTS_Pos                      ( 0U )
#define ADC_TSREF_ENTS_Msk                      ( 0x1U << ADC_TSREF_ENTS_Pos )
#define ADC_TSREF_ENTS                          ( ADC_TSREF_ENTS_Msk )


/***************  Bits definition for ADC_SMPR3 register  ********************/
#define ADC_SMPR3_SMP20_Pos                     ( 16U )
#define ADC_SMPR3_SMP20_Msk                     ( 0xFUL << ADC_SMPR3_SMP20_Pos )
#define ADC_SMPR3_SMP20                         ( ADC_SMPR3_SMP20_Msk )

#define ADC_SMPR3_SMP19_Pos                     ( 12U )
#define ADC_SMPR3_SMP19_Msk                     ( 0xFUL << ADC_SMPR3_SMP19_Pos )
#define ADC_SMPR3_SMP19                         ( ADC_SMPR3_SMP19_Msk )

#define ADC_SMPR3_SMP18_Pos                     ( 8U )
#define ADC_SMPR3_SMP18_Msk                     ( 0xFUL << ADC_SMPR3_SMP18_Pos )
#define ADC_SMPR3_SMP18                         ( ADC_SMPR3_SMP18_Msk )

#define ADC_SMPR3_SMP17_Pos                     ( 4U )
#define ADC_SMPR3_SMP17_Msk                     ( 0xFUL << ADC_SMPR3_SMP17_Pos )
#define ADC_SMPR3_SMP17                         ( ADC_SMPR3_SMP17_Msk )

#define ADC_SMPR3_SMP16_Pos                     ( 0U )
#define ADC_SMPR3_SMP16_Msk                     ( 0xFUL << ADC_SMPR3_SMP16_Pos )
#define ADC_SMPR3_SMP16                         ( ADC_SMPR3_SMP16_Msk )


/** @brief  TIMEOUT
  */
#define ADC_READY_TIMEOUT                       (0xFFFU)
#define ADC_UNREADY_TIMEOUT                     (0xFFU)
/**
  * @}
  */

/** @defgroup ADC_State
  * @{
  */
#define ADC_STATE_DISABLE                       (0U)
#define ADC_STATE_ENABLE                        (1U)
#define IS_ADC_STATE(_STATE_)                   (((_STATE_) == ADC_STATE_DISABLE)  || \
                                                ((_STATE_) == ADC_STATE_ENABLE))
/**
  * @}
  */ 
  
/** @defgroup ADC Trig source define
  * @{
  */ 
/*  |     Trig Source           |     Regular            |      Inject             | * 
 *  |     ADC_SOFTWARE_START    |     SWSTART            |      JSWSTART           | *
 *  |     ADC_EXTERNAL_TIG1     |     TIM1_TRGO          |      TIM1_TRGO          | *
 *  |     ADC_EXTERNAL_TIG2     |     TIM1_CC4           |      TIM1_CC4           | *
 *  |     ADC_EXTERNAL_TIG3     |     RSV                |      RSV                | *
 *  |     ADC_EXTERNAL_TIG4     |     TIM3_TRGO          |      TIM3_TRGO          | *
 *  |     ADC_EXTERNAL_TIG5     |     TIM15_TRGO         |      TIM15_TRGO         | *
 *  |     ADC_EXTERNAL_TIG6     |     TIM6_TRGO          |      TIM6_TRGO          | *
 *  |     ADC_EXTERNAL_TIG7     |     EXTI_Line_11       |      EXTI_Line_11       | */
#define ADC_SOFTWARE_START                      (0U)
#define ADC_EXTERNAL_TIG1                       (1U)
#define ADC_EXTERNAL_TIG2                       (2U)
#define ADC_EXTERNAL_TIG3                       (3U)
#define ADC_EXTERNAL_TIG4                       (4U)
#define ADC_EXTERNAL_TIG5                       (5U)
#define ADC_EXTERNAL_TIG6                       (6U)
#define ADC_EXTERNAL_TIG7                       (7U)
#define IS_ADC_TRIG(__TRIG__)                   (((__TRIG__) == ADC_EXTERNAL_TIG1)  || \
                                                ((__TRIG__) == ADC_EXTERNAL_TIG2)   || \
                                                ((__TRIG__) == ADC_EXTERNAL_TIG3)   || \
                                                ((__TRIG__) == ADC_EXTERNAL_TIG4)   || \
                                                ((__TRIG__) == ADC_EXTERNAL_TIG4)   || \
                                                ((__TRIG__) == ADC_EXTERNAL_TIG6)   || \
                                                ((__TRIG__) == ADC_EXTERNAL_TIG7)   || \
                                                ((__TRIG__) == ADC_SOFTWARE_START))  
                                                
/**
  * @}
  */                                                 
                                                

/** @defgroup ADC Continuous mode
* @{
*/ 
#define ADC_CONT_DISABLE                        (0U)
#define ADC_CONT_ENABLE                         (ADC_CR1_CONT)
#define IS_ADC_CONT(__CONT__)                   (((__CONT__) == ADC_CONT_DISABLE) || \
                                                ((__CONT__) == ADC_CONT_ENABLE))
/**
  * @}
  */   
    
/** @defgroup ADC ClockPrescale 
  * @{
  */ 
#define ADC_CLOCK_DIV1                          (0U)    
#define ADC_CLOCK_DIV2                          (ADC_CR2_DIV_0)    
#define ADC_CLOCK_DIV3                          (ADC_CR2_DIV_1)    
#define ADC_CLOCK_DIV4                          (ADC_CR2_DIV_0 | ADC_CR2_DIV_1)    
#define ADC_CLOCK_DIV5                          (ADC_CR2_DIV_2)    
#define ADC_CLOCK_DIV6                          (ADC_CR2_DIV_0 | ADC_CR2_DIV_2)    
#define ADC_CLOCK_DIV7                          (ADC_CR2_DIV_1 | ADC_CR2_DIV_2)    
#define ADC_CLOCK_DIV8                          (ADC_CR2_DIV_0 | ADC_CR2_DIV_1 | ADC_CR2_DIV_2)    
#define ADC_CLOCK_DIV9                          (ADC_CR2_DIV_3)    
#define ADC_CLOCK_DIV10                         (ADC_CR2_DIV_0 | ADC_CR2_DIV_3)    
#define ADC_CLOCK_DIV11                         (ADC_CR2_DIV_1 | ADC_CR2_DIV_3)    
#define ADC_CLOCK_DIV12                         (ADC_CR2_DIV_0 | ADC_CR2_DIV_1 | ADC_CR2_DIV_3)    
#define ADC_CLOCK_DIV13                         (ADC_CR2_DIV_2 | ADC_CR2_DIV_3)    
#define ADC_CLOCK_DIV14                         (ADC_CR2_DIV_0 | ADC_CR2_DIV_2 | ADC_CR2_DIV_3)    
#define ADC_CLOCK_DIV15                         (ADC_CR2_DIV_1 | ADC_CR2_DIV_2 | ADC_CR2_DIV_3)    
#define ADC_CLOCK_DIV16                         (ADC_CR2_DIV_0 | ADC_CR2_DIV_1 | ADC_CR2_DIV_2 | ADC_CR2_DIV_3) 
#define IS_ADC_CLOCK_DIV(__DIV__)               (((__DIV__) == ADC_CLOCK_DIV1)  || \
                                                ((__DIV__) == ADC_CLOCK_DIV2)   || \
                                                ((__DIV__) == ADC_CLOCK_DIV3)   || \
                                                ((__DIV__) == ADC_CLOCK_DIV4)   || \
                                                ((__DIV__) == ADC_CLOCK_DIV5)   || \
                                                ((__DIV__) == ADC_CLOCK_DIV6)   || \
                                                ((__DIV__) == ADC_CLOCK_DIV7)   || \
                                                ((__DIV__) == ADC_CLOCK_DIV8)   || \
                                                ((__DIV__) == ADC_CLOCK_DIV9)   || \
                                                ((__DIV__) == ADC_CLOCK_DIV10)  || \
                                                ((__DIV__) == ADC_CLOCK_DIV11)  || \
                                                ((__DIV__) == ADC_CLOCK_DIV12)  || \
                                                ((__DIV__) == ADC_CLOCK_DIV13)  || \
                                                ((__DIV__) == ADC_CLOCK_DIV14)  || \
                                                ((__DIV__) == ADC_CLOCK_DIV15)  || \
                                                ((__DIV__) == ADC_CLOCK_DIV16))
/**
  * @}
  */
  


/** @defgroup ADC analog watchdog selection
  * @{
  */
#define ADC_ANALOGWDG_NONE                      (0U) 
#define ADC_ANALOGWDG_RCH_SINGLE                (ADC_CR1_AWDSGL | ADC_CR1_AWDEN)   
#define ADC_ANALOGWDG_JCH_SINGLE                (ADC_CR1_AWDSGL | ADC_CR1_JAWDEN)   
#define ADC_ANALOGWDG_RCH_OR_JCH_SINGLE         (ADC_CR1_AWDSGL | ADC_CR1_AWDEN | ADC_CR1_JAWDEN)   
#define ADC_ANALOGWDG_RCH_ALL                   (ADC_CR1_AWDEN)   
#define ADC_ANALOGWDG_JCH_ALL                   (ADC_CR1_JAWDEN)   
#define ADC_ANALOGWDG_RCH_AND_JCH_ALL           (ADC_CR1_AWDEN | ADC_CR1_JAWDEN)   
#define IS_ADC_ANALOG_WDG(__WDG__)              (((__WDG__) == ADC_ANALOGWDG_RCH_SINGLE)        || \
                                                ((__WDG__) == ADC_ANALOGWDG_JCH_SINGLE)         || \
                                                ((__WDG__) == ADC_ANALOGWDG_RCH_OR_JCH_SINGLE)  || \
                                                ((__WDG__) == ADC_ANALOGWDG_RCH_ALL)            || \
                                                ((__WDG__) == ADC_ANALOGWDG_JCH_ALL)            || \
                                                ((__WDG__) == ADC_ANALOGWDG_RCH_AND_JCH_ALL)    || \
                                                ((__WDG__) == ADC_ANALOGWDG_NONE))  
/**
  * @}
  */
  
/** @defgroup ADC analog watchdog thresholds 
  * @{
  */ 
#define IS_ADC_THRESHOLD(__THRESHOLD__)         ((__THRESHOLD__) <= 0xFFFU)
/**
  * @}
  */    
  
/** @defgroup ADC channel number 
* @{
*/
#define ADC_CHANNEL_0                           (0U)    
#define ADC_CHANNEL_1                           (1U)    
#define ADC_CHANNEL_2                           (2U)    
#define ADC_CHANNEL_3                           (3U)    
#define ADC_CHANNEL_4                           (4U)    
#define ADC_CHANNEL_5                           (5U)    
#define ADC_CHANNEL_6                           (6U)    
#define ADC_CHANNEL_7                           (7U)    
#define ADC_CHANNEL_8                           (8U)    
#define ADC_CHANNEL_9                           (9U)    
#define ADC_CHANNEL_10                          (10U)    
#define ADC_CHANNEL_11                          (11U)    
#define ADC_CHANNEL_12                          (12U)    
#define ADC_CHANNEL_13                          (13U)    
#define ADC_CHANNEL_14                          (14U)    
#define ADC_CHANNEL_15                          (15U)    
#define ADC_CHANNEL_TS                          (16U) 
#define ADC_CHANNEL_VABT                        (17U)          
#define ADC_CHANNEL_BGR                         (18U)    
#define ADC_CHANNEL_EXT2                        (19U)
#define ADC_CHANNEL_EXT3                        (20U)  
#define IS_ADC_CHANNEL(__CHANNEL__)             (((__CHANNEL__) == ADC_CHANNEL_0)   || \
                                                ((__CHANNEL__) == ADC_CHANNEL_1)    || \
                                                ((__CHANNEL__) == ADC_CHANNEL_2)    || \
                                                ((__CHANNEL__) == ADC_CHANNEL_3)    || \
                                                ((__CHANNEL__) == ADC_CHANNEL_4)    || \
                                                ((__CHANNEL__) == ADC_CHANNEL_5)    || \
                                                ((__CHANNEL__) == ADC_CHANNEL_6)    || \
                                                ((__CHANNEL__) == ADC_CHANNEL_7)    || \
                                                ((__CHANNEL__) == ADC_CHANNEL_8)    || \
                                                ((__CHANNEL__) == ADC_CHANNEL_9)    || \
                                                ((__CHANNEL__) == ADC_CHANNEL_10)   || \
                                                ((__CHANNEL__) == ADC_CHANNEL_11)   || \
                                                ((__CHANNEL__) == ADC_CHANNEL_12)   || \
                                                ((__CHANNEL__) == ADC_CHANNEL_13)   || \
                                                ((__CHANNEL__) == ADC_CHANNEL_14)   || \
                                                ((__CHANNEL__) == ADC_CHANNEL_15)   || \
                                                ((__CHANNEL__) == ADC_CHANNEL_TS)   || \
                                                ((__CHANNEL__) == ADC_CHANNEL_VABT) || \
                                                ((__CHANNEL__) == ADC_CHANNEL_BGR)  || \
                                                ((__CHANNEL__) == ADC_CHANNEL_EXT2) || \
                                                ((__CHANNEL__) == ADC_CHANNEL_EXT3))
/**
  * @}
  */ 

/** @defgroup Sampling time
  * @{
  */
#define ADC_SMP_CLOCK_3                         (0U)
#define ADC_SMP_CLOCK_5                         (1U)
#define ADC_SMP_CLOCK_7                         (2U)
#define ADC_SMP_CLOCK_10                        (3U)
#define ADC_SMP_CLOCK_13                        (4U)
#define ADC_SMP_CLOCK_16                        (5U)
#define ADC_SMP_CLOCK_20                        (6U)
#define ADC_SMP_CLOCK_30                        (7U)
#define ADC_SMP_CLOCK_60                        (8U)
#define ADC_SMP_CLOCK_80                        (9U)
#define ADC_SMP_CLOCK_100                       (10U)
#define ADC_SMP_CLOCK_120                       (11U)
#define ADC_SMP_CLOCK_160                       (12U)
#define ADC_SMP_CLOCK_320                       (13U)
#define ADC_SMP_CLOCK_480                       (14U)
#define ADC_SMP_CLOCK_640                       (15U)
#define IS_ADC_SMPCLOCK(__SMPCLOCK__)           (((__SMPCLOCK__) == ADC_SMP_CLOCK_3)    || \
                                                ((__SMPCLOCK__) == ADC_SMP_CLOCK_5)     || \
                                                ((__SMPCLOCK__) == ADC_SMP_CLOCK_7)     || \
                                                ((__SMPCLOCK__) == ADC_SMP_CLOCK_10)    || \
                                                ((__SMPCLOCK__) == ADC_SMP_CLOCK_13)    || \
                                                ((__SMPCLOCK__) == ADC_SMP_CLOCK_16)    || \
                                                ((__SMPCLOCK__) == ADC_SMP_CLOCK_20)    || \
                                                ((__SMPCLOCK__) == ADC_SMP_CLOCK_30)    || \
                                                ((__SMPCLOCK__) == ADC_SMP_CLOCK_60)    || \
                                                ((__SMPCLOCK__) == ADC_SMP_CLOCK_80)    || \
                                                ((__SMPCLOCK__) == ADC_SMP_CLOCK_100)   || \
                                                ((__SMPCLOCK__) == ADC_SMP_CLOCK_120)   || \
                                                ((__SMPCLOCK__) == ADC_SMP_CLOCK_160)   || \
                                                ((__SMPCLOCK__) == ADC_SMP_CLOCK_320)   || \
                                                ((__SMPCLOCK__) == ADC_SMP_CLOCK_480)   || \
                                                ((__SMPCLOCK__) == ADC_SMP_CLOCK_640))   
/**
  * @}
  */ 
  
/** @defgroup ADC sequence number
* @{
*/
#define ADC_SEQUENCE_SQ1                        (1U)
#define ADC_SEQUENCE_SQ2                        (2U)
#define ADC_SEQUENCE_SQ3                        (3U)
#define ADC_SEQUENCE_SQ4                        (4U)
#define ADC_SEQUENCE_SQ5                        (5U)
#define ADC_SEQUENCE_SQ6                        (6U)
#define ADC_SEQUENCE_SQ7                        (7U)
#define ADC_SEQUENCE_SQ8                        (8U)
#define ADC_SEQUENCE_SQ9                        (9U)
#define ADC_SEQUENCE_SQ10                       (10U)
#define ADC_SEQUENCE_SQ11                       (11U)
#define ADC_SEQUENCE_SQ12                       (12U)
#define ADC_SEQUENCE_SQ13                       (13U)
#define ADC_SEQUENCE_SQ14                       (14U)
#define ADC_SEQUENCE_SQ15                       (15U)
#define ADC_SEQUENCE_SQ16                       (16U)
#define IS_ADC_SEQUENCE(__SEQUENCE__)           (((__SEQUENCE__) == ADC_SEQUENCE_SQ1)   || \
                                                ((__SEQUENCE__) == ADC_SEQUENCE_SQ2)    || \
                                                ((__SEQUENCE__) == ADC_SEQUENCE_SQ3)    || \
                                                ((__SEQUENCE__) == ADC_SEQUENCE_SQ4)    || \
                                                ((__SEQUENCE__) == ADC_SEQUENCE_SQ5)    || \
                                                ((__SEQUENCE__) == ADC_SEQUENCE_SQ6)    || \
                                                ((__SEQUENCE__) == ADC_SEQUENCE_SQ7)    || \
                                                ((__SEQUENCE__) == ADC_SEQUENCE_SQ8)    || \
                                                ((__SEQUENCE__) == ADC_SEQUENCE_SQ9)    || \
                                                ((__SEQUENCE__) == ADC_SEQUENCE_SQ10)   || \
                                                ((__SEQUENCE__) == ADC_SEQUENCE_SQ11)   || \
                                                ((__SEQUENCE__) == ADC_SEQUENCE_SQ12)   || \
                                                ((__SEQUENCE__) == ADC_SEQUENCE_SQ13)   || \
                                                ((__SEQUENCE__) == ADC_SEQUENCE_SQ14)   || \
                                                ((__SEQUENCE__) == ADC_SEQUENCE_SQ15)   || \
                                                ((__SEQUENCE__) == ADC_SEQUENCE_SQ16))
/**
  * @}
  */     

/** @defgroup ADC regular length 
  * @{
  */ 
#define IS_ADC_REGULAR_LENGTH(__LENGTH__)       (((__LENGTH__) >= 1U) && ((__LENGTH__) <= 16U))
/**
  * @}
  */
  
  
/** @defgroup ADC regular discontinuous mode number 
  * @{
  */ 
#define IS_ADC_REGULAR_DISC_NUMBER(__NUMBER__)  ((__NUMBER__) <= 16U)
/**
  * @}
  */ 
  
/** @defgroup ADC Buffer Stability Time 
  * @{
  */ 
#define IS_ADC_BUFFER_STABILITY_TIME(__TIME__)  ((__TIME__) <= 0xFFU)
/**
  * @}
  */   
  

/** @defgroup  Oversampling Data shift
  * @{
  */
#define ADC_RIGHTBITSHIFT_NONE                  (0U) /*!< ADC oversampling no shift (sum of the ADC conversions data is not divided */
#define ADC_RIGHTBITSHIFT_1                     (1U) /*!< ADC oversampling shift of 1 (sum of the ADC conversions data is divided by 2 */
#define ADC_RIGHTBITSHIFT_2                     (2U) /*!< ADC oversampling shift of 2 (sum of the ADC conversions data is divided by 4 */
#define ADC_RIGHTBITSHIFT_3                     (3U) /*!< ADC oversampling shift of 3 (sum of the ADC conversions data is divided by 8 */
#define ADC_RIGHTBITSHIFT_4                     (4U) /*!< ADC oversampling shift of 4 (sum of the ADC conversions data is divided by 16 */
#define ADC_RIGHTBITSHIFT_5                     (5U) /*!< ADC oversampling shift of 5 (sum of the ADC conversions data is divided by 32 */
#define ADC_RIGHTBITSHIFT_6                     (6U) /*!< ADC oversampling shift of 6 (sum of the ADC conversions data is divided by 64 */
#define ADC_RIGHTBITSHIFT_7                     (7U) /*!< ADC oversampling shift of 7 (sum of the ADC conversions data is divided by 128 */
#define ADC_RIGHTBITSHIFT_8                     (8U) /*!< ADC oversampling shift of 8 (sum of the ADC conversions data is divided by 256 */
#define IS_ADC_RIGHTBITSHIFT(__SHIFT__)         (((__SHIFT__) == ADC_RIGHTBITSHIFT_NONE)    || \
                                                ((__SHIFT__) == ADC_RIGHTBITSHIFT_1)        || \
                                                ((__SHIFT__) == ADC_RIGHTBITSHIFT_2)        || \
                                                ((__SHIFT__) == ADC_RIGHTBITSHIFT_3)        || \
                                                ((__SHIFT__) == ADC_RIGHTBITSHIFT_4)        || \
                                                ((__SHIFT__) == ADC_RIGHTBITSHIFT_5)        || \
                                                ((__SHIFT__) == ADC_RIGHTBITSHIFT_6)        || \
                                                ((__SHIFT__) == ADC_RIGHTBITSHIFT_7)        || \
                                                ((__SHIFT__) == ADC_RIGHTBITSHIFT_8))
/**
  * @}
  */
  
/** @defgroup  Oversampling Ratio
  * @{
  */
#define ADC_OVERSAMPLING_RATIO_2                (0U)  /*!< ADC oversampling ratio of 2 (2 ADC conversions are performed */
#define ADC_OVERSAMPLING_RATIO_4                (1U)  /*!< ADC oversampling ratio of 4 (4 ADC conversions are performed */
#define ADC_OVERSAMPLING_RATIO_8                (2U)  /*!< ADC oversampling ratio of 8 (8 ADC conversions are performed */
#define ADC_OVERSAMPLING_RATIO_16               (3U)  /*!< ADC oversampling ratio of 16 (16 ADC conversions are performed */
#define ADC_OVERSAMPLING_RATIO_32               (4U)  /*!< ADC oversampling ratio of 32 (32 ADC conversions are performed */
#define ADC_OVERSAMPLING_RATIO_64               (5U)  /*!< ADC oversampling ratio of 64 (64 ADC conversions are performed */
#define ADC_OVERSAMPLING_RATIO_128              (6U)  /*!< ADC oversampling ratio of 128 (128 ADC conversions are performed */
#define ADC_OVERSAMPLING_RATIO_256              (7U)  /*!< ADC oversampling ratio of 256 (256 ADC conversions are performed */
#define IS_ADC_OVERSAMPLING_RATIO(__RATIO__)    (((__RATIO__) == ADC_OVERSAMPLING_RATIO_2)  || \
                                                ((__RATIO__) == ADC_OVERSAMPLING_RATIO_4)   || \
                                                ((__RATIO__) == ADC_OVERSAMPLING_RATIO_8)   || \
                                                ((__RATIO__) == ADC_OVERSAMPLING_RATIO_16)  || \
                                                ((__RATIO__) == ADC_OVERSAMPLING_RATIO_32)  || \
                                                ((__RATIO__) == ADC_OVERSAMPLING_RATIO_64)  || \
                                                ((__RATIO__) == ADC_OVERSAMPLING_RATIO_128) || \
                                                ((__RATIO__) == ADC_OVERSAMPLING_RATIO_256))
/**
  * @}
  */  

/** @defgroup overflow mode
  * @{
  */
#define ADC_OVERFLOWMODE_LAST                   (0U)  
#define ADC_OVERFLOWMODE_NEW                    (ADC_CR2_OVRMOD)
#define IS_ADC_OVERFLOW_MODE(__MODE__)          (((__MODE__) == ADC_OVERFLOWMODE_LAST)  || \
                                                ((__MODE__) == ADC_OVERFLOWMODE_NEW))
/**
  * @}
  */
  
/** @defgroup oversampling triger mode
  * @{
  */
#define ADC_OVERSAMPLING_TRIGER_MORE            (0U)  
#define ADC_OVERSAMPLING_TRIGER_ONCE            (ADC_CR2_JTROVS) 
#define IS_ADC_OVERSAMPLING_TRIGER(__MODE__)    (((__MODE__) == ADC_OVERSAMPLING_TRIGER_MORE) || \
                                                ((__MODE__) == ADC_OVERSAMPLING_TRIGER_ONCE))
/**
  * @}
  */

/** @defgroup ADC interrupts and flag definition 
  * @{
  */ 
#define ADC_FLAG_ADRDY                          (ADC_SR_ADRDY)
#define ADC_IT_FLAG_EOC                         (ADC_SR_EOC)
#define ADC_IT_FLAG_JEOC                        (ADC_SR_JEOC)   
#define ADC_IT_FLAG_EOG                         (ADC_SR_EOG)  
#define ADC_IT_FLAG_OVERF                       (ADC_SR_OVERF) 
#define ADC_IT_FLAG_AWD                         (ADC_SR_AWD)
#define ADC_IT_FLAG_ALL                         (0xFFU)    
#define IS_ADC_FLAG(__FLAG__)                   (((__FLAG__) == ADC_IT_FLAG_EOSMP)  || \
                                                ((__FLAG__) == ADC_IT_FLAG_EOC)     || \
                                                ((__FLAG__) == ADC_IT_FLAG_EOG)     || \
                                                ((__FLAG__) == ADC_IT_FLAG_OVERF)   || \
                                                ((__FLAG__) == ADC_IT_FLAG_JEOC)    || \
                                                ((__FLAG__) == ADC_IT_FLAG_JEOG)    || \
                                                ((__FLAG__) == ADC_IT_FLAG_AWD)     || \
                                                ((__FLAG__) <= ADC_IT_FLAG_ALL))   
#define IS_ADC_IT_FLAG(__FLAG__)                (((__FLAG__) == ADC_IT_FLAG_EOC)    || \
                                                ((__FLAG__) == ADC_IT_FLAG_JEOC)    || \
                                                ((__FLAG__) == ADC_IT_FLAG_EOG)     || \
                                                ((__FLAG__) == ADC_IT_FLAG_OVERF)   || \
                                                ((__FLAG__) == ADC_IT_FLAG_AWD)     || \
                                                ((__FLAG__) <= ADC_IT_FLAG_ALL))                                                     
/**
  * @}
  */ 
  
/** @defgroup Single or differential 
* @{
*/
#define ADC_SINGLE_MODE                         (0U)  
#define ADC_DIFFERENTIAL_MODE                   (1U)  
#define IS_ADC_DIFF_MODE(__MODE__)              (((__MODE__) == ADC_SINGLE_MODE) || \
                                                ((__MODE__) == ADC_DIFFERENTIAL_MODE))
/**
  * @}
  */ 
  
  /** @defgroup DIFF or SIGN channel number 
* @{
*/
#define ADC_CHANNEL_0_8                         (0U)    
#define ADC_CHANNEL_1_9                         (1U)    
#define ADC_CHANNEL_2_10                        (2U)    
#define ADC_CHANNEL_3_11                        (3U)    
#define ADC_CHANNEL_4_12                        (4U)    
#define ADC_CHANNEL_5_13                        (5U)    
#define ADC_CHANNEL_6_14                        (6U)    
#define ADC_CHANNEL_7_15                        (7U)          
#define IS_ADC_DIFF_SIGN_CHANNEL(__CHANNEL__)   (((__CHANNEL__) == ADC_CHANNEL_0_8) || \
                                                ((__CHANNEL__) == ADC_CHANNEL_1_9)  || \
                                                ((__CHANNEL__) == ADC_CHANNEL_2_10) || \
                                                ((__CHANNEL__) == ADC_CHANNEL_3_11) || \
                                                ((__CHANNEL__) == ADC_CHANNEL_4_12) || \
                                                ((__CHANNEL__) == ADC_CHANNEL_5_13) || \
                                                ((__CHANNEL__) == ADC_CHANNEL_6_14) || \
                                                ((__CHANNEL__) == ADC_CHANNEL_7_15))
/**
  * @}
  */ 

/** @defgroup Signed or unsigned number selection
* @{
*/
#define ADC_SIGN_UNSIGNED                       (0U)   
#define ADC_SIGN_SIGNED                         (1U)   
#define IS_ADC_SIGN(__MODE__)                   (((__MODE__) == ADC_SIGN_SIGNED) || \
                                                ((__MODE__) == ADC_SIGN_UNSIGNED))
/**
  * @}
  */  


/** @defgroup ADC embedded VREF voltage
* @{
*/
#define ADC_EMBEDDED_VREF_1V5                   (0U)   
#define ADC_EMBEDDED_VREF_2V0                   (ADC_TSREF_VREFBISEL_0)  
#define ADC_EMBEDDED_VREF_2V5                   (ADC_TSREF_VREFBISEL_1)  
#define IS_ADC_EMBEDDED_VREF(__VOL__)           (((__VOL__) == ADC_EMBEDDED_VREF_1V5)   || \
                                                ((__VOL__) == ADC_EMBEDDED_VREF_2V0)    || \
                                                ((__VOL__) == ADC_EMBEDDED_VREF_2V5))
/**
  * @}
  */

/** @defgroup temperature sensor conversion times
* @{
*/
#define ADC_TS_CONVERT_TIME_32                  (0U)   
#define ADC_TS_CONVERT_TIME_64                  (ADC_TSREF_ALGMEAN_0) 
#define ADC_TS_CONVERT_TIME_128                 (ADC_TSREF_ALGMEAN_1)
#define ADC_TS_CONVERT_TIME_256                 (ADC_TSREF_ALGMEAN_0 | ADC_TSREF_ALGMEAN_1)
#define IS_ADC_TS_CONVERT_TIME(__TIME__)        (((__TIME__) == ADC_TS_CONVERT_TIME_32) || \
                                                ((__TIME__) == ADC_TS_CONVERT_TIME_64)  || \
                                                ((__TIME__) == ADC_TS_CONVERT_TIME_128) || \
                                                ((__TIME__) == ADC_TS_CONVERT_TIME_256))
/**
  * @}
  */ 

/* Exported functions --------------------------------------------------------*/

void ADC_DeInit(void);
void ADC_Init(void);
void ADC_ClockConfig(uint32_t Division);
void ADC_Cmd(uint32_t NewState);
void ADC_FastModeCmd(uint32_t NewState);
void ADC_ContinuousModeCmd(uint32_t NewState);
void ADC_StopControlCmd(uint32_t NewState);
void ADC_OverflowmodeConfig(uint32_t Overflowmode);
void ADC_DifferentialConfig(uint8_t Channel, uint8_t Mode);
void ADC_SignConfig(uint8_t Channel, uint8_t Sign);
void ADC_OverSamplingConfig(uint8_t Ratio, uint8_t Shift);
void ADC_RegularOverSamplingCmd(uint32_t NewState);
void ADC_InjectOverSamplingTrigerConfig(uint32_t TrigerMode);
void ADC_InjectOverSamplingCmd(uint32_t NewState);
void ADC_AnalogWatchdogConfig(uint32_t Mode);
void ADC_AnalogWatchdogSingleThresholdConfig(uint16_t HighTh, uint16_t LowTh);
void ADC_AnalogWatchdogDifferentialThresholdConfig(uint16_t HighTh, uint16_t LowTh);
void ADC_AnalogWatchdogRegularChannelConfig(uint8_t Channel);
void ADC_AnalogWatchdogInjectChannelConfig(uint8_t Channel);
void ADC_RegularChannelConfig(uint8_t Channel, uint8_t Rank, uint8_t SampleTime);
void ADC_RegularChannelSequenceLengthConfig(uint8_t Length);
void ADC_RegularSoftwareStart(void);
FlagStatus ADC_GetRegularSoftwareStartStatus(void);
void ADC_RegularExternalTriggerConfig(uint32_t Trigger);
void ADC_DiscModeChannelCountConfig(uint8_t Number);
void ADC_DiscModeCmd(uint32_t NewState);
uint32_t ADC_GetRegularConversionValue(void);
void ADC_BufferCmd(uint32_t NewState);
void ADC_BufferStabilityTimeConfig(uint32_t Time);
void ADC_TempSensorConversionTime(uint32_t Time);
void ADC_TempSensorCmd(uint32_t NewState);
void ADC_VREF1P2Cmd(uint32_t NewState);
void ADC_DMACmd(uint32_t NewState);
void ADC_InjectedChannelConfig(uint8_t Channel, uint8_t SampleTime);
void ADC_InjectedConvertCmd(uint32_t NewState);
void ADC_InjectedExternalTriggerConfig(uint32_t Trigger);
void ADC_InjectedSoftwareStart(void);
FlagStatus ADC_GetInjectedSoftwareStartStatus(void);
uint32_t ADC_GetInjectedConversionValue(void);
void ADC_EmbeddedVREFCmd(uint32_t NewState);
void ADC_EmbeddedVREFVoltageConfig(uint32_t Voltage);
void ADC_ITConfig(uint16_t ADC_IT, uint32_t NewState);
FlagStatus ADC_GetFlagStatus(uint8_t ADC_FLAG);
void ADC_ClearFlag(uint8_t ADC_FLAG);
ITStatus ADC_GetITStatus(uint16_t ADC_IT);
void ADC_ClearITPendingBit(uint32_t ADC_IT);
                













  
  

#endif 


/************************ (C) COPYRIGHT AISINOCHIP *****END OF FILE****/






