
/******************************************************************************
*@file  : app.c
*@brief : application
******************************************************************************/

#include "app.h"


extern volatile uint32_t gu32_SystemCount;



/******************************************************************************
* @brief : app test.
* @param : None
* @return: None
******************************************************************************/
void APP_Test(void)
{
    GPIO_InitTypeDef GPIO_InitStruct;
    LVD_InitTypeDef  LVD_Init;
    
    printfS("LVD test, please adjust the voltage\r\n"); 
    
    if((SCU->RSR & BIT0) == BIT0)
    {
        SCU->RSR = BIT16;
        printfS("Last Reset Reason: LVD\r\n");         
    }
    
    System_Module_Enable(EN_GPIOCD); 
    GPIO_InitStruct.Pin       = GPIO_PIN_3;  
    GPIO_InitStruct.Mode      = GPIO_MODE_OUTPUT_PP;
    GPIO_InitStruct.Pull      = GPIO_NOPULL;
    GPIO_InitStruct.Alternate = GPIO_FUNCTION_0;
    GPIO_Init(GPIOD, &GPIO_InitStruct);
    
    /* ʹRC32K*/
    System_Enable_RC32K();

    /* LVD */
    LVD_Init.LVDEN          =  FUNC_ENABLE;         //ʹLVD
    LVD_Init.LVDRST_EN      =  FUNC_ENABLE;         //ʹLVDλ
    LVD_Init.LVD_FLTEN      =  FUNC_ENABLE;         //ʹLVDȽ˲
    LVD_Init.LVD_TRIM       =  LVD_TRIM_273;        //LVD TRIM 2.73V
    LVD_Init.LVD_FLTCLK_SEL =  FLTCLK_SEL_PCLK_32;  //FLTCLK ѡRC32K
    LVD_Init.LVD_FLT_TIME   =  LVD_FLT_TIME_4;      //FLTCLK 4
    
    System_LVD_Config(&LVD_Init);
    
    /* ѹСLVD趨ֵʱϵͳλGPIOתֹͣӡֹͣ */
    while(1)
    {
        GPIO_WriteBit(GPIOD, GPIO_PIN_3, Bit_SET);
        System_Delay_MS(250);
        GPIO_WriteBit(GPIOD, GPIO_PIN_3, Bit_RESET);
        System_Delay_MS(250);
        printfS("Tick: %u\r\n", gu32_SystemCount);
    }  
}










