/*
  ******************************************************************************
  * Copyright (c)  2008 - 2024, Shanghai AisinoChip Co.,Ltd .
  * @file    APP.c 
  * @version V1.0.0
  * @date    2024
  * @author  Aisinochip Firmware Team  
  * @brief   LPUART demo source code.
  ******************************************************************************        
*/
#include "app.h"  


/******************************************************************************
*@brief : app test
*@param : none
*@return: none
******************************************************************************/
void APP_Test(void)
{
    uint32_t data;
    GPIO_InitTypeDef  GPIO_InitStruct = {0};
    LPUART_InitTypeDef LPUART_InitStruct = {0};
    
	printfS("SPL LPUART Demo: Block Mode.\r\n");
	printfS("\r\n");
    

	#if 1
	
    // TX:PC1, RX:PC0
    System_Module_Enable(EN_GPIOCD);
    
    GPIO_InitStruct.Pin       = GPIO_PIN_1 | GPIO_PIN_0;
    GPIO_InitStruct.Mode      = GPIO_MODE_AF_PP;
    GPIO_InitStruct.Pull      = GPIO_PULLUP;
    GPIO_InitStruct.Alternate = GPIO_FUNCTION_1;

    GPIO_Init(GPIOC, &GPIO_InitStruct);
	#else
    // TX:PA2, RX:PA3
    System_Module_Enable(EN_GPIOAB);
    
    GPIO_InitStruct.Pin       = GPIO_PIN_2 | GPIO_PIN_3;
    GPIO_InitStruct.Mode      = GPIO_MODE_AF_PP;
    GPIO_InitStruct.Pull      = GPIO_PULLUP;
    GPIO_InitStruct.Alternate = GPIO_FUNCTION_6;

    GPIO_Init(GPIOA, &GPIO_InitStruct);
	#endif
    
    LPUART_SetClockSource(LPUART, LPUART_CLOCKSOURCE_RC32K);
    LPUART_SetWakeupMode(LPUART, LPUART_WAKEUPMODE_NONE);
    
    LPUART_InitStruct.BaudRate    = 9600;
    LPUART_InitStruct.WordLength  = LPUART_WORDLENGTH_8B;
    LPUART_InitStruct.StopBits    = LPUART_STOPBITS_1B;
    LPUART_InitStruct.Parity      = LPUART_PARITY_NONE;
    LPUART_InitStruct.Mode        = LPUART_MODE_TXRX;
    
    LPUART_Init(LPUART, &LPUART_InitStruct);
    
    printfS("LPUART : 115200, 8, N, 1.\r\n");
    printfS("LPUART receives data and sends back the received data.\r\n");
        
    while (1)
    {
        while (LPUART_GetFlagStatus(LPUART, LPUART_FLAG_RXF) == RESET);
        
        data = LPUART_ReceiveData(LPUART);
        
        while (LPUART_GetFlagStatus(LPUART, LPUART_IT_TXE) == RESET);
        
        LPUART_SendData(LPUART, data);
    }
}




