/*
  ******************************************************************************
  * @file    main.c
  * @brief   main source File.
  ******************************************************************************
*/
#include "app.h" 

GPIO_InitTypeDef GPIO_InitStruct;
UART_InitTypeDef UART1_InitStruc;
UART_InitTypeDef UART2_InitStruc;

/************************************************************************
 * function   : Uart_Init
 * Description: Uart Initiation. 
 ************************************************************************/ 
void Uart_Init(void) 
{    
    System_Module_Enable(EN_UART1);
    System_Module_Enable(EN_UART2);
    System_Module_Enable(EN_GPIOAB);

    GPIO_InitStruct.Pin       = GPIO_PIN_2 | GPIO_PIN_3;
    GPIO_InitStruct.Mode      = GPIO_MODE_AF_PP;
    GPIO_InitStruct.Pull      = GPIO_PULLUP;
    GPIO_InitStruct.Alternate = GPIO_FUNCTION_2;        
    GPIO_Init(GPIOA, &GPIO_InitStruct);
    
    NVIC_DisableIRQ(UART2_IRQn);
    
    UART2_InitStruc.UART_BaudRate    = 115200;  
    UART2_InitStruc.UART_WordLength  = UART_WORDLENGTH_8B;
    UART2_InitStruc.UART_StopBits    = UART_STOPBITS_1;
    UART2_InitStruc.UART_Parity      = UART_PARITY_NONE;
    UART2_InitStruc.UART_Mode        = UART_MODE_TX_RX_DEBUG;
    UART2_InitStruc.UART_HardwareFlowControl =UART_HWCONTROL_NONE;    
    UART_Init(UART2,&UART2_InitStruc); 
    //Enable UART
    UART_Cmd(UART2, ENABLE);

     /* Initialization GPIO */
    /* A9:Tx  A10:Rx */
    GPIO_InitStruct.Pin       = GPIO_PIN_9 | GPIO_PIN_10;
    GPIO_InitStruct.Mode      = GPIO_MODE_AF_PP;
    GPIO_InitStruct.Pull      = GPIO_PULLUP;
    GPIO_InitStruct.Alternate = GPIO_FUNCTION_2;
    GPIO_Init(GPIOA, &GPIO_InitStruct);
    
    NVIC_ClearPendingIRQ(UART1_IRQn);
    NVIC_SetPriority(UART1_IRQn, 5);
    NVIC_EnableIRQ(UART1_IRQn);
        
    UART1_InitStruc.UART_BaudRate    = 9600;  
    UART1_InitStruc.UART_WordLength  = UART_WORDLENGTH_8B;
    UART1_InitStruc.UART_StopBits    = UART_STOPBITS_1;
    UART1_InitStruc.UART_Parity      = UART_PARITY_NONE;
    UART1_InitStruc.UART_Mode        = UART_MODE_TX_RX;
    UART1_InitStruc.UART_HardwareFlowControl =UART_HWCONTROL_NONE;    
    UART_Init(UART1, &UART1_InitStruc); 
    //Enable UART
    UART_Cmd(UART1, ENABLE);
    
    
    // UART_DEBUG_ENABLE control printfS   
    printfS("MCU is running, HCLK=%dHz, PCLK=%dHz\n", System_Get_SystemClock(), System_Get_APBClock());       
}


/*********************************************************************************
* Function    : main
* Description : 
* Input       : 
* Output      : 
**********************************************************************************/
int main(void)
{
    System_Init();  
    
    Uart_Init();   
    
    /* Select Mode:     TEST_MASTER_TX, TEST_MASTER_RX, TEST_SLAVE */  
    APP_LIN_Test(TEST_MASTER_TX);  

    while(1)
    {

    }
}

