/***********************************************************************
 * All rights reserved.
 * Filename    : lcd_YR1618A.h
 * Description : lcd_YR1618A driver header file
 * Author(s)   : yht      
 * version     : V2.0
 * Modify date : 2024-07-03
 ***********************************************************************/
#ifndef __LCD_YR1618A_H__

#define __LCD_YR1618A_H__

#include "fxx_std.h"
#include "lcd.h"
/**
  @verbatim
================================================================================
                              YR1618A LCD ֵ
================================================================================
Ļеѹ3V   ռձ:1/4   ƫѹ:1/3   ţC0M1-COM4   SEG0-SEG1924
ֵ£
LCD:
SEG_LCD:0-19
COM1_LCD	1A	1B	2A	2B	3A	3B	4A	4B		S9	S10	5A	5B	6A	6B	7A	7B	8A	8B		S1	S14
COM2_LCD	1F	1G	2F	2G	3F	3G	4F	4G		S8	S11	5F	5G	6F	6G	7F	7G	8F	8G		S2	S16
COM3_LCD	1E	1C	2E	2C	3E	3C	4E	4C		S7	S12	5E	5C	6E	6C	7E	7C	8E	8C		S3	S15
COM4_LCD	1D	1P	2D	2P	3D	3P	4D	COLI	S6	S5	5D	5P	6D	6P	7D	7P	8D	COL2	S4	S13

ܽ
SEG_MCU		SEG_LCD
0			0
1			1
2			2
3			3
4			4
5			5
6			6
7			7
8			8
9			9
15			10
14			11
22			12
23			13
19			14
13			15
25			16
26			17
24			18
27			19
COM_MCU		COM_LCD
0			1
1			2
2			3
3			4


================================================================================
  @endverbatim
  */


#define COM_NUM_YR		4
#define SEG_NUM_YR		20

#define DIGIT_NUM_YR	8
#define P_NUM_YR		6
#define COL_NUM_YR		2
#define S_NUM_YR		16

#if (LCD_DisplayMode == 1)
//mode1
#define YR_R_1A     (0U+R0)
#define YR_R_1B     (1U+R0)
#define YR_R_2A     (2U+R0)
#define YR_R_2B     (3U+R0)
#define YR_R_3A     (4U+R0)
#define YR_R_3B     (5U+R0)
#define YR_R_4A     (6U+R0)
#define YR_R_4B     (7U+R0)
#define YR_R_S9     (8U+R0)
#define YR_R_S10    (9U+R0)
#define YR_R_5A     (15U+R0)
#define YR_R_5B     (14U+R0)
#define YR_R_6A     (22U+R0)
#define YR_R_6B     (23U+R0)
#define YR_R_7A     (19U+R0)
#define YR_R_7B     (13U+R0)
#define YR_R_8A     (25U+R0)
#define YR_R_8B     (26U+R0)
#define YR_R_S1     (24U+R0)
#define YR_R_S14    (27U+R0)
#define YR_R_1F     (0U+R1)
#define YR_R_1G     (1U+R1)
#define YR_R_2F     (2U+R1)
#define YR_R_2G     (3U+R1)
#define YR_R_3F     (4U+R1)
#define YR_R_3G     (5U+R1)
#define YR_R_4F     (6U+R1)
#define YR_R_4G     (7U+R1)
#define YR_R_S8     (8U+R1)
#define YR_R_S11    (9U+R1)
#define YR_R_5F     (15U+R1)
#define YR_R_5G     (14U+R1)
#define YR_R_6F     (22U+R1)
#define YR_R_6G     (23U+R1)
#define YR_R_7F     (19U+R1)
#define YR_R_7G     (13U+R1)
#define YR_R_8F     (25U+R1)
#define YR_R_8G     (26U+R1)
#define YR_R_S2     (24U+R1)
#define YR_R_S16    (27U+R1)
#define YR_R_1E     (0U+R2)
#define YR_R_1C     (1U+R2)
#define YR_R_2E     (2U+R2)
#define YR_R_2C     (3U+R2)
#define YR_R_3E     (4U+R2)
#define YR_R_3C     (5U+R2)
#define YR_R_4E     (6U+R2)
#define YR_R_4C     (7U+R2)
#define YR_R_S7     (8U+R2)
#define YR_R_S12    (9U+R2)
#define YR_R_5E     (15U+R2)
#define YR_R_5C     (14U+R2)
#define YR_R_6E     (22U+R2)
#define YR_R_6C     (23U+R2)
#define YR_R_7E     (19U+R2)
#define YR_R_7C     (13U+R2)
#define YR_R_8E     (25U+R2)
#define YR_R_8C     (26U+R2)
#define YR_R_S3     (24U+R2)
#define YR_R_S15    (27U+R2)
#define YR_R_1D     (0U+R3)
#define YR_R_1P     (1U+R3)
#define YR_R_2D     (2U+R3)
#define YR_R_2P     (3U+R3)
#define YR_R_3D     (4U+R3)
#define YR_R_3P     (5U+R3)
#define YR_R_4D     (6U+R3)
#define YR_R_COLI   (7U+R3)
#define YR_R_S6     (8U+R3)
#define YR_R_S5     (9U+R3)
#define YR_R_5D     (15U+R3)
#define YR_R_5P     (14U+R3)
#define YR_R_6D     (22U+R3)
#define YR_R_6P     (23U+R3)
#define YR_R_7D     (19U+R3)
#define YR_R_7P     (13U+R3)
#define YR_R_8D     (25U+R3)
#define YR_R_COL2   (26U+R3)
#define YR_R_S4     (24U+R3)
#define YR_R_S13    (27U+R3)

#elif (LCD_DisplayMode == 0)
//mode 0
#define YR_R_1A     (0U+R0)
#define YR_R_1B     (8U+R0)
#define YR_R_2A     (16U+R0)
#define YR_R_2B     (24U+R0)
#define YR_R_3A     (0U+R1)
#define YR_R_3B     (8U+R1)
#define YR_R_4A     (16U+R1)
#define YR_R_4B     (24U+R1)
#define YR_R_S9     (0U+R2)
#define YR_R_S10    (8U+R2)
#define YR_R_5A     (24U+R3)
#define YR_R_5B     (16U+R3)
#define YR_R_6A     (16U+R5)
#define YR_R_6B     (24U+R5)
#define YR_R_7A     (24U+R4)
#define YR_R_7B     (8U+R3)
#define YR_R_8A     (8U+R6)
#define YR_R_8B     (16U+R6)
#define YR_R_S1     (0U+R6)
#define YR_R_S14    (24U+R6)
#define YR_R_1F     (1U+R0)
#define YR_R_1G     (9U+R0)
#define YR_R_2F     (17U+R0)
#define YR_R_2G     (25U+R0)
#define YR_R_3F     (1U+R1)
#define YR_R_3G     (9U+R1)
#define YR_R_4F     (17U+R1)
#define YR_R_4G     (25U+R1)
#define YR_R_S8     (1U+R2)
#define YR_R_S11    (9U+R2)
#define YR_R_5F     (25U+R3)
#define YR_R_5G     (17U+R3)
#define YR_R_6F     (17U+R5)
#define YR_R_6G     (25U+R5)
#define YR_R_7F     (25U+R4)
#define YR_R_7G     (9U+R3)
#define YR_R_8F     (9U+R6)
#define YR_R_8G     (17U+R6)
#define YR_R_S2     (1U+R6)
#define YR_R_S16    (25U+R6)
#define YR_R_1E     (2U+R0)
#define YR_R_1C     (10U+R0)
#define YR_R_2E     (18U+R0)
#define YR_R_2C     (26U+R0)
#define YR_R_3E     (2U+R1)
#define YR_R_3C     (10U+R1)
#define YR_R_4E     (18U+R1)
#define YR_R_4C     (26U+R1)
#define YR_R_S7     (2U+R2)
#define YR_R_S12    (10U+R2)
#define YR_R_5E     (26U+R3)
#define YR_R_5C     (18U+R3)
#define YR_R_6E     (18U+R5)
#define YR_R_6C     (26U+R5)
#define YR_R_7E     (26U+R4)
#define YR_R_7C     (10U+R3)
#define YR_R_8E     (10U+R6)
#define YR_R_8C     (18U+R6)
#define YR_R_S3     (2U+R6)
#define YR_R_S15    (26U+R6)
#define YR_R_1D     (3U+R0)
#define YR_R_1P     (11U+R0)
#define YR_R_2D     (19U+R0)
#define YR_R_2P     (27U+R0)
#define YR_R_3D     (3U+R1)
#define YR_R_3P     (11U+R1)
#define YR_R_4D     (19U+R1)
#define YR_R_COLI   (27U+R1)
#define YR_R_S6     (3U+R2)
#define YR_R_S5     (11U+R2)
#define YR_R_5D     (27U+R3)
#define YR_R_5P     (19U+R3)
#define YR_R_6D     (19U+R5)
#define YR_R_6P     (27U+R5)
#define YR_R_7D     (27U+R4)
#define YR_R_7P     (11U+R3)
#define YR_R_8D     (11U+R6)
#define YR_R_COL2   (19U+R6)
#define YR_R_S4     (3U+R6)
#define YR_R_S13    (27U+R6)

#endif




#define LCD_YR1618A_BACK_LED_ON     GPIO_WriteBit(GPIOA,GPIO_PIN_5,Bit_SET);
#define LCD_YR1618A_BACK_LED_OFF    GPIO_WriteBit(GPIOA,GPIO_PIN_5,Bit_RESET);

#define GetLCDBackKey() HAL_GPIO_ReadPin(GPIOC,GPIO_PIN_15)
#define LCD_BACK_LED_EN GPIO_PIN_CLEAR

void LCD_YR1618A_BACK_LED(void);
void LCD_Init_YR1618A(void);
void YR1618A_VIEW(uint8_t NUM_IN[DIGIT_NUM_YR],uint8_t P,uint8_t COL,uint16_t S);
#endif
