/*
  ******************************************************************************
	* @file    lcd_YR1618A.c
	* Author(s)   : yht      
	* version     : V2.0
	* Modify date : 2024-07-03
  *******************************************************************************/
  
  
#include "lcd_YR1618A.h"

LCD_HandleTypeDef           lcdhandle_YR1618A;


uint16_t NUM_POS_YR[DIGIT_NUM_YR][7]
={
	{YR_R_1A,YR_R_1B,YR_R_1C,YR_R_1D,YR_R_1E,YR_R_1F,YR_R_1G},
	{YR_R_2A,YR_R_2B,YR_R_2C,YR_R_2D,YR_R_2E,YR_R_2F,YR_R_2G},
	{YR_R_3A,YR_R_3B,YR_R_3C,YR_R_3D,YR_R_3E,YR_R_3F,YR_R_3G},
	{YR_R_4A,YR_R_4B,YR_R_4C,YR_R_4D,YR_R_4E,YR_R_4F,YR_R_4G},
	{YR_R_5A,YR_R_5B,YR_R_5C,YR_R_5D,YR_R_5E,YR_R_5F,YR_R_5G},
	{YR_R_6A,YR_R_6B,YR_R_6C,YR_R_6D,YR_R_6E,YR_R_6F,YR_R_6G},
	{YR_R_7A,YR_R_7B,YR_R_7C,YR_R_7D,YR_R_7E,YR_R_7F,YR_R_7G},
	{YR_R_8A,YR_R_8B,YR_R_8C,YR_R_8D,YR_R_8E,YR_R_8F,YR_R_8G}
};

uint16_t P_POS_YR[P_NUM_YR]={YR_R_1P,YR_R_2P,YR_R_3P,YR_R_5P,YR_R_6P,YR_R_7P};
uint16_t COL_POS_YR[COL_NUM_YR]={YR_R_COLI,YR_R_COL2};
uint16_t S_POS_YR[S_NUM_YR]={
YR_R_S1 
,YR_R_S2 
,YR_R_S3 
,YR_R_S4 
,YR_R_S5 
,YR_R_S6 
,YR_R_S7 
,YR_R_S8 
,YR_R_S9
,YR_R_S10
,YR_R_S11
,YR_R_S12
,YR_R_S13
,YR_R_S14
,YR_R_S15
,YR_R_S16
};


void YR1618A_VIEW(uint8_t NUM_IN[DIGIT_NUM_YR],uint8_t P,uint8_t COL,uint16_t S)
{
	uint8_t i,j,duan;
	uint16_t index=0;
	uint16_t pos_lst[COM_NUM_YR*SEG_NUM_YR]={0};//根据com/seg定
	uint32_t ram[10]={0};
	for(i=0;i<DIGIT_NUM_YR;i++)
	{
		j=NUM_AG[NUM_IN[i]];
		for(duan=0;duan<7;duan++)
		{
			if(j&(0x1ul<<duan))
			{
				pos_lst[index]=NUM_POS_YR[i][duan];
			}
			else
				pos_lst[index]=0xffff;
			index++;
				
		}
	}
	
	for(i=0;i<P_NUM_YR;i++)
	{
		if(P&(0x1ul<<i))
			pos_lst[index]=P_POS_YR[i];
		else
			pos_lst[index]=0xffff;
		index++;
	}
	
	for(i=0;i<COL_NUM_YR;i++)
	{
		if(COL&(0x1ul<<i))
			pos_lst[index]=COL_POS_YR[i];
		else
			pos_lst[index]=0xffff;
		index++;
	}

	for(i=0;i<S_NUM_YR;i++)
	{
		if(S&(0x1ul<<i))
			pos_lst[index]=S_POS_YR[i];
		else
			pos_lst[index]=0xffff;
		index++;
	}
	
	for(i=0;i<COM_NUM_YR*SEG_NUM_YR;i++)
	{
		if(pos_lst[i]!=0xffff)
		{
			j=pos_lst[i]/32;
			ram[j] |= 0x1ul<<(pos_lst[i]%32);
		}
	}
	for(;index<COM_NUM_YR*SEG_NUM_YR;index++)
	{
		pos_lst[index]=0xffff;
	}
	
	for(i=0;i<8;i++)
	{
		LCD_Write(&lcdhandle_YR1618A,i,ram[i]);
	}
	for(i=8;i<16;i++)
	{
		LCD_Write(&lcdhandle_YR1618A,i,*((uint8_t*)&ram[8]+(i-8)));
	}
}

/*********************************************************************************
* Function    : LCD_GPIO_Config
* Description : Config the GPIO of LCD use.
* Input       : 
* Outpu       : 
* Author      : ZK                         Data : 2022年
**********************************************************************************/
void LCD_GPIO_Config_YR1618A(void)//配置LCD所需的GPIO
{
	GPIO_InitTypeDef            GPIO_Init_YR1618A; 
    memset(&GPIO_Init_YR1618A,0,sizeof(GPIO_Init_YR1618A));//初始化清零GPIO_Init_YR1618A
    /* COM0-COM3:PA9-PA12  SEG0:PA8  */
    GPIO_Init_YR1618A.Pin = GPIO_PIN_9|GPIO_PIN_10|GPIO_PIN_11|GPIO_PIN_12|GPIO_PIN_8|GPIO_PIN_4|GPIO_PIN_0;	
    GPIO_Init_YR1618A.Mode = GPIO_MODE_ANALOG;
    GPIO_Init(GPIOA, &GPIO_Init_YR1618A);//
    
    
    /* SEG1-4:PC9-6 */
    GPIO_Init_YR1618A.Pin = GPIO_PIN_9|GPIO_PIN_8|GPIO_PIN_7|GPIO_PIN_6|GPIO_PIN_5|GPIO_PIN_4|GPIO_PIN_3|GPIO_PIN_2|GPIO_PIN_1|GPIO_PIN_0;	
    GPIO_Init_YR1618A.Mode = GPIO_MODE_ANALOG;
    GPIO_Init(GPIOC, &GPIO_Init_YR1618A);    
    
    /* SEG5-7:PB15-13 */
    GPIO_Init_YR1618A.Pin = GPIO_PIN_0|GPIO_PIN_11|GPIO_PIN_12|GPIO_PIN_15|GPIO_PIN_14|GPIO_PIN_13;	
    GPIO_Init_YR1618A.Mode = GPIO_MODE_ANALOG;
    GPIO_Init(GPIOB, &GPIO_Init_YR1618A);  
    /* SEG5-7:PD5, =1*/
    GPIO_Init_YR1618A.Pin = GPIO_PIN_5;	
    GPIO_Init_YR1618A.Mode = GPIO_MODE_ANALOG;
    GPIO_Init(GPIOD, &GPIO_Init_YR1618A);      
}



/*********************************************************************************
* Function    : LCD_SegCom_Config
* Description : Config the SEG and COM  of LCD use.
* Input       : 
* Outpu       : 
* Author      : ZK                         Data : 2022年
**********************************************************************************/
void LCD_SegCom_Config_YR1618A(void)//配置LCD所需的COM和SEG口
{
	LCD_SegComInitTypeDef       LCD_YR1618A_SegComInitStructure;
    LCD_YR1618A_SegComInitStructure.SEG0_31=0xF0371C00;//开启SEG0-SEG70xF0371C00
    
    LCD_YR1618A_SegComInitStructure.Stc_SEG32_39_COM0_8.SEG32_39_COM0_8=0xFFFFFFFF;//初始化LCD_POEN1寄存器 关闭全部输出
    
    LCD_YR1618A_SegComInitStructure.Stc_SEG32_39_COM0_8.SEGCOM_bit.COM0_3=0;//开启COM0-COM3
    LCD_YR1618A_SegComInitStructure.Stc_SEG32_39_COM0_8.SEGCOM_bit.SEG32_35=0xf;//关闭SEG32_35和COM4-7
    LCD_YR1618A_SegComInitStructure.Stc_SEG32_39_COM0_8.SEGCOM_bit.SEG36_COM7=1;
    LCD_YR1618A_SegComInitStructure.Stc_SEG32_39_COM0_8.SEGCOM_bit.SEG37_COM6=1;
    LCD_YR1618A_SegComInitStructure.Stc_SEG32_39_COM0_8.SEGCOM_bit.SEG38_COM5=1;
    LCD_YR1618A_SegComInitStructure.Stc_SEG32_39_COM0_8.SEGCOM_bit.SEG39_COM4=1;
    
    LCD_SegComConfig(&lcdhandle_YR1618A,&LCD_YR1618A_SegComInitStructure);
}
/*********************************************************************************
* Function    : LCD_Init_Config
* Description : LCD  Init Config
* Input       : 
* Outpu       : 
* Author      : ZK                         Data : 2022年
**********************************************************************************/
void LCD_Init_YR1618A(void)
{  
    memset(&lcdhandle_YR1618A,0,sizeof(lcdhandle_YR1618A));//初始化清零Handle
    lcdhandle_YR1618A.Instance=LCD;
    lcdhandle_YR1618A.Init.Bias=LCD_BIAS_1_3;
    lcdhandle_YR1618A.Init.Duty=LCD_DUTY_1_4;
	#if (LCD_DisplayMode == 1)
    lcdhandle_YR1618A.Init.DisplayMode=LCD_DisplayMode_1;
	#elif (LCD_DisplayMode == 0)
    lcdhandle_YR1618A.Init.DisplayMode=LCD_DisplayMode_0;
	#endif
    lcdhandle_YR1618A.Init.LCDFrequency=LCD_LCDFrequency_512HZ;
    lcdhandle_YR1618A.Init.Driving_Waveform=LCD_Driving_Waveform_B;
    lcdhandle_YR1618A.Init.BiasSrc=LCD_BiasSrc_InRes_Seg31_35_Normal;//内部电阻模式
    //   lcdhandle_YR1618A.Init.BlinkEN=LCD_BlinkEN_Enable;//闪频使能
    lcdhandle_YR1618A.Init.BlinkFrequency =0x3;//帧间隔时间，影响帧中断时间和LCD DMA请求时间 以及闪烁时间
    LCD_Init(&lcdhandle_YR1618A);
    
    LCD_InResInitTypeDef  Resstrcut;
    memset(&Resstrcut,0,sizeof(Resstrcut));//初始化清零Handle
    Resstrcut.Contrast=LCD_Contrast_903VDD;
    Resstrcut.BiasRes=LCD_BiasRes_240k;//LCD_BiasRes_240k  LCD_BiasRes_4M
    Resstrcut.FastCharge=LCD_FastCharge_Enable;//快速充电配置
    Resstrcut.PONTime=0x3f;
    Resstrcut.DriveMod=LCD_DriveMod_FC;//LCD_DriveMod_FC
    LCD_InResConfig(&lcdhandle_YR1618A,&Resstrcut);
    
    
    LCD_GPIO_Config_YR1618A();
    LCD_SegCom_Config_YR1618A(); 

}


/*********************************************************************************
* Function    : LCD_YR1618A_BACK_LED
* Description : LCD_YR1618A_BACK_LED
* Input       : 
* Outpu       : 
* Author      : ZK                         Date : 2022年
**********************************************************************************/
void LCD_YR1618A_BACK_LED(void)
{   
    GPIO_InitTypeDef    GPIO_LCD_BACK_LED;
    
    GPIO_LCD_BACK_LED.Pin       = GPIO_PIN_5;
    GPIO_LCD_BACK_LED.Mode      = GPIO_MODE_OUTPUT_PP;
    GPIO_LCD_BACK_LED.Pull      = GPIO_NOPULL;
    GPIO_LCD_BACK_LED.Alternate = GPIO_FUNCTION_0;
    
    GPIO_Init(GPIOA, &GPIO_LCD_BACK_LED);
    
    GPIO_LCD_BACK_LED.Pin       = GPIO_PIN_15;
    GPIO_LCD_BACK_LED.Mode      = GPIO_MODE_INPUT;
    GPIO_LCD_BACK_LED.Pull      = GPIO_PULLUP;
    GPIO_LCD_BACK_LED.Alternate = GPIO_FUNCTION_0;
    
    GPIO_Init(GPIOC, &GPIO_LCD_BACK_LED);

    LCD_YR1618A_BACK_LED_ON;
    System_Delay_MS(500);
}


