/***********************************************************************
 * All rights reserved.
 * Filename    : lcd_H50261ARP.h
 * Description : lcd_H50261ARP driver header file
 * Author(s)   : yht      
 * version     : V2.0
 * Modify date : 2024-07-03
 ***********************************************************************/
#ifndef __LCD_H50261ARP_H__

#define __LCD_H50261ARP_H__

#include "fxx_std.h"
#include "lcd.h"
/**
  @verbatim
================================================================================
                              H50261ARP LCD ֵ
================================================================================
Ļеѹ3V   ռձ:1/4   ƫѹ:1/3   ţC0M0-COM3   SEG0-SEG1015
ֵ£
SEG_LCD:0-10
COM0_LCD	4D		5D	T1	1D	T2	2D	2P	3D	T7	T3
COM1_LCD	4E	4C	5E	5C	1E	1C	2E	2C	3E	3C	T4
COM2_LCD	4G	4B	5G	5B	1G	1B	2G	2B	3G	3B	T5
COM3_LCD	4F	4A	5F	5A	1F	1A	2F	2A	3F	3A	T6


ܽ
SEG_MCU		SEG_LCD
0			0
1			1
2			2
3			3
4			4
5			5
6			6
7			7
8			8
9			9
15			10
COM_MCU		COM_LCD
0			0
1			1
2			2
3			3
================================================================================
  @endverbatim
  */


#define COM_NUM_H5		4
#define SEG_NUM_H5		11

#define DIGIT_NUM_H5	5
#define T_NUM_H5		7
#define P_NUM_H5		1

#if (LCD_DisplayMode == 1)
//mode 1
#define H5_R_4D     (0U+R0)
#define H5_R_5D     (2U+R0)
#define H5_R_T1     (3U+R0)
#define H5_R_1D     (4U+R0)
#define H5_R_T2     (5U+R0)
#define H5_R_2D     (6U+R0)
#define H5_R_2P     (7U+R0)
#define H5_R_3D     (8U+R0)
#define H5_R_T7     (9U+R0)
#define H5_R_T3     (15U+R0)
#define H5_R_4E     (0U+R1)
#define H5_R_4C     (1U+R1)
#define H5_R_5E     (2U+R1)
#define H5_R_5C     (3U+R1)
#define H5_R_1E     (4U+R1)
#define H5_R_1C     (5U+R1)
#define H5_R_2E     (6U+R1)
#define H5_R_2C     (7U+R1)
#define H5_R_3E     (8U+R1)
#define H5_R_3C     (9U+R1)
#define H5_R_T4     (15U+R1)
#define H5_R_4G     (0U+R2)
#define H5_R_4B     (1U+R2)
#define H5_R_5G     (2U+R2)
#define H5_R_5B     (3U+R2)
#define H5_R_1G     (4U+R2)
#define H5_R_1B     (5U+R2)
#define H5_R_2G     (6U+R2)
#define H5_R_2B     (7U+R2)
#define H5_R_3G     (8U+R2)
#define H5_R_3B     (9U+R2)
#define H5_R_T5     (15U+R2)
#define H5_R_4F     (0U+R3)
#define H5_R_4A     (1U+R3)
#define H5_R_5F     (2U+R3)
#define H5_R_5A     (3U+R3)
#define H5_R_1F     (4U+R3)
#define H5_R_1A     (5U+R3)
#define H5_R_2F     (6U+R3)
#define H5_R_2A     (7U+R3)
#define H5_R_3F     (8U+R3)
#define H5_R_3A     (9U+R3)
#define H5_R_T6     (15U+R3)

#elif (LCD_DisplayMode == 0)
//mode 0
#define H5_R_4D     (0U+R0)
#define H5_R_5D     (16U+R0)
#define H5_R_T1     (24U+R0)
#define H5_R_1D     (0U+R1)
#define H5_R_T2     (8U+R1)
#define H5_R_2D     (16U+R1)
#define H5_R_2P     (24U+R1)
#define H5_R_3D     (0U+R2)
#define H5_R_T7     (8U+R2)
#define H5_R_T3     (24U+R3)
#define H5_R_4E     (1U+R0)
#define H5_R_4C     (9U+R0)
#define H5_R_5E     (17U+R0)
#define H5_R_5C     (25U+R0)
#define H5_R_1E     (1U+R1)
#define H5_R_1C     (9U+R1)
#define H5_R_2E     (17U+R1)
#define H5_R_2C     (25U+R1)
#define H5_R_3E     (1U+R2)
#define H5_R_3C     (9U+R2)
#define H5_R_T4     (25U+R3)
#define H5_R_4G     (2U+R0)
#define H5_R_4B     (10U+R0)
#define H5_R_5G     (18U+R0)
#define H5_R_5B     (26U+R0)
#define H5_R_1G     (2U+R1)
#define H5_R_1B     (10U+R1)
#define H5_R_2G     (18U+R1)
#define H5_R_2B     (26U+R1)
#define H5_R_3G     (2U+R2)
#define H5_R_3B     (10U+R2)
#define H5_R_T5     (26U+R3)
#define H5_R_4F     (3U+R0)
#define H5_R_4A     (11U+R0)
#define H5_R_5F     (19U+R0)
#define H5_R_5A     (27U+R0)
#define H5_R_1F     (3U+R1)
#define H5_R_1A     (11U+R1)
#define H5_R_2F     (19U+R1)
#define H5_R_2A     (27U+R1)
#define H5_R_3F     (3U+R2)
#define H5_R_3A     (11U+R2)
#define H5_R_T6     (27U+R3)

#endif

#define LCD_H50261ARP_BACK_LED_ON GPIO_WriteBit(GPIOA,GPIO_PIN_5,Bit_SET);
#define LCD_H50261ARP_BACK_LED_OFF GPIO_WriteBit(GPIOA,GPIO_PIN_5,Bit_RESET);

#define GetLCDBackKey() HAL_GPIO_ReadPin(GPIOC,GPIO_PIN_15)
#define LCD_BACK_LED_EN GPIO_PIN_CLEAR

void LCD_H50261ARP_BACK_LED(void);
void LCD_Init_H50261ARP(void);
void H50261ARP_VIEW(uint8_t NUM_IN[DIGIT_NUM_H5],uint8_t T,uint8_t P);

#endif
