/*
  ******************************************************************************
* @file    lcd_H50261ARP.c
* Author(s)   : yht      
* version     : V2.0
* Modify date : 2024-07-03
  *******************************************************************************/
  
  
#include "lcd_H50261ARP.h"
 
LCD_HandleTypeDef           lcdhandle_H50261ARP;
 
uint16_t NUM_POS_H5[DIGIT_NUM_H5][7]
={
	{H5_R_1A,H5_R_1B,H5_R_1C,H5_R_1D,H5_R_1E,H5_R_1F,H5_R_1G},
	{H5_R_2A,H5_R_2B,H5_R_2C,H5_R_2D,H5_R_2E,H5_R_2F,H5_R_2G},
	{H5_R_3A,H5_R_3B,H5_R_3C,H5_R_3D,H5_R_3E,H5_R_3F,H5_R_3G},
	{H5_R_4A,H5_R_4B,H5_R_4C,H5_R_4D,H5_R_4E,H5_R_4F,H5_R_4G},
	{H5_R_5A,H5_R_5B,H5_R_5C,H5_R_5D,H5_R_5E,H5_R_5F,H5_R_5G},
};
uint16_t T_POS_H5[T_NUM_H5]={H5_R_T1,H5_R_T2,H5_R_T3,H5_R_T4,H5_R_T5,H5_R_T6,H5_R_T7};
uint16_t P_POS_H5[P_NUM_H5]={H5_R_2P};
void H50261ARP_VIEW(uint8_t NUM_IN[DIGIT_NUM_H5],uint8_t T,uint8_t P)
{
	uint8_t i,j,duan;
	uint16_t index=0;
	uint16_t pos_lst[COM_NUM_H5*SEG_NUM_H5]={0};//com/seg
	uint32_t ram[10]={0};
	for(i=0;i<DIGIT_NUM_H5;i++)
	{
		j=NUM_AG[NUM_IN[i]];
		for(duan=0;duan<7;duan++)
		{
			if(j&(0x1ul<<duan))
			{
				pos_lst[index]=NUM_POS_H5[i][duan];
			}
			else
				pos_lst[index]=0xffff;
			index++;
				
		}
	}
	
	for(i=0;i<T_NUM_H5;i++)
	{
		if(T&(0x1ul<<i))
			pos_lst[index]=T_POS_H5[i];
		else
			pos_lst[index]=0xffff;
		index++;
	}
	
	for(i=0;i<P_NUM_H5;i++)
	{
		if(P&(0x1ul<<i))
			pos_lst[index]=P_POS_H5[i];
		else
			pos_lst[index]=0xffff;
		index++;
	}
	for(;index<COM_NUM_H5*SEG_NUM_H5;index++)
	{
		pos_lst[index]=0xffff;
	}

	
	for(i=0;i<COM_NUM_H5*SEG_NUM_H5;i++)
	{
		if(pos_lst[i]!=0xffff)
		{
			j=pos_lst[i]/32;
			ram[j] |= 0x1ul<<(pos_lst[i]%32);
		}
	}
	
	for(i=0;i<8;i++)
	{
		LCD_Write(&lcdhandle_H50261ARP,i,ram[i]);
	}
	for(i=8;i<16;i++)
	{
		LCD_Write(&lcdhandle_H50261ARP,i,*((uint8_t*)&ram[8]+(i-8)));
	}
}
  
/*********************************************************************************
* Function    : LCD_GPIO_Config
* Description : Config the GPIO of LCD use.
* Input       : 
* Outpu       : 
* Author      : ZK                         Data : 2022年
**********************************************************************************/
void LCD_GPIO_Config_H50261ARP(void)//配置LCD所需的GPIO
{
	GPIO_InitTypeDef            GPIO_Init_H50261ARP; 
    memset(&GPIO_Init_H50261ARP,0,sizeof(GPIO_Init_H50261ARP));//初始化清零GPIO_Init_H50261ARP
    /* COM0-COM3:PA9-PA12  SEG0:PA8  */
    GPIO_Init_H50261ARP.Pin = GPIO_PIN_9|GPIO_PIN_10|GPIO_PIN_11|GPIO_PIN_12|GPIO_PIN_8|GPIO_PIN_4|GPIO_PIN_0;	
    GPIO_Init_H50261ARP.Mode = GPIO_MODE_ANALOG;
    GPIO_Init(GPIOA, &GPIO_Init_H50261ARP);//
    
    
    /* SEG1-4:PC9-6 */
    GPIO_Init_H50261ARP.Pin = GPIO_PIN_9|GPIO_PIN_8|GPIO_PIN_7|GPIO_PIN_6|GPIO_PIN_5|GPIO_PIN_4|GPIO_PIN_3|GPIO_PIN_2|GPIO_PIN_1|GPIO_PIN_0;	
    GPIO_Init_H50261ARP.Mode = GPIO_MODE_ANALOG;
    GPIO_Init(GPIOC, &GPIO_Init_H50261ARP);    
    
    /* SEG5-7:PB15-13 */
    GPIO_Init_H50261ARP.Pin = GPIO_PIN_0|GPIO_PIN_11|GPIO_PIN_12|GPIO_PIN_15|GPIO_PIN_14|GPIO_PIN_13;	
    GPIO_Init_H50261ARP.Mode = GPIO_MODE_ANALOG;
    GPIO_Init(GPIOB, &GPIO_Init_H50261ARP);  
    /* SEG5-7:PD5, =1*/
    GPIO_Init_H50261ARP.Pin = GPIO_PIN_5;	
    GPIO_Init_H50261ARP.Mode = GPIO_MODE_ANALOG;
    GPIO_Init(GPIOD, &GPIO_Init_H50261ARP);      
}



/*********************************************************************************
* Function    : LCD_SegCom_Config
* Description : Config the SEG and COM  of LCD use.
* Input       : 
* Outpu       : 
* Author      : ZK                         Data : 2022年
**********************************************************************************/
void LCD_SegCom_Config_H50261ARP(void)//配置LCD所需的COM和SEG口
{
	LCD_SegComInitTypeDef       LCD_H50261ARP_SegComInitStructure;
    LCD_H50261ARP_SegComInitStructure.SEG0_31=0xFFFF7C00;//开启SEG0-SEG9 
    
    LCD_H50261ARP_SegComInitStructure.Stc_SEG32_39_COM0_8.SEG32_39_COM0_8=0xFFFFFFFF;//初始化LCD_POEN1寄存器 关闭全部输出
    
    LCD_H50261ARP_SegComInitStructure.Stc_SEG32_39_COM0_8.SEGCOM_bit.COM0_3=0;//开启COM0-COM3
    LCD_H50261ARP_SegComInitStructure.Stc_SEG32_39_COM0_8.SEGCOM_bit.SEG32_35=0xf;//关闭SEG32_35和COM4-7
    LCD_H50261ARP_SegComInitStructure.Stc_SEG32_39_COM0_8.SEGCOM_bit.SEG36_COM7=1;
    LCD_H50261ARP_SegComInitStructure.Stc_SEG32_39_COM0_8.SEGCOM_bit.SEG37_COM6=1;
    LCD_H50261ARP_SegComInitStructure.Stc_SEG32_39_COM0_8.SEGCOM_bit.SEG38_COM5=1;
    LCD_H50261ARP_SegComInitStructure.Stc_SEG32_39_COM0_8.SEGCOM_bit.SEG39_COM4=1;
    
    LCD_SegComConfig(&lcdhandle_H50261ARP,&LCD_H50261ARP_SegComInitStructure);
}
/*********************************************************************************
* Function    : LCD_Init_Config
* Description : LCD  Init Config
* Input       : 
* Outpu       : 
* Author      : ZK                         Data : 2022年
**********************************************************************************/
void LCD_Init_H50261ARP(void)
{  
    memset(&lcdhandle_H50261ARP,0,sizeof(lcdhandle_H50261ARP));//初始化清零Handle
    lcdhandle_H50261ARP.Instance=LCD;
    lcdhandle_H50261ARP.Init.Bias=LCD_BIAS_1_3;
    lcdhandle_H50261ARP.Init.Duty=LCD_DUTY_1_4;
	#if (LCD_DisplayMode == 1)
    lcdhandle_H50261ARP.Init.DisplayMode=LCD_DisplayMode_1;
	#elif (LCD_DisplayMode == 0)
    lcdhandle_H50261ARP.Init.DisplayMode=LCD_DisplayMode_0;
	#endif
    lcdhandle_H50261ARP.Init.LCDFrequency=LCD_LCDFrequency_512HZ;
    lcdhandle_H50261ARP.Init.Driving_Waveform=LCD_Driving_Waveform_B;
    lcdhandle_H50261ARP.Init.BiasSrc=LCD_BiasSrc_InRes_Seg31_35_Normal;//内部电阻模式
    //   lcdhandle_H50261ARP.Init.BlinkEN=LCD_BlinkEN_Enable;//闪频使能
    lcdhandle_H50261ARP.Init.BlinkFrequency =0x3;//帧间隔时间，影响帧中断时间和LCD DMA请求时间 以及闪烁时间
    LCD_Init(&lcdhandle_H50261ARP);
    
    LCD_InResInitTypeDef  Resstrcut;
    memset(&Resstrcut,0,sizeof(Resstrcut));//初始化清零Handle
    Resstrcut.Contrast=LCD_Contrast_903VDD;
    Resstrcut.BiasRes=LCD_BiasRes_240k;//LCD_BiasRes_240k  LCD_BiasRes_4M
    Resstrcut.FastCharge=LCD_FastCharge_Enable;//快速充电配置
    Resstrcut.PONTime=0x3f;
    Resstrcut.DriveMod=LCD_DriveMod_FC;//LCD_DriveMod_FC
    LCD_InResConfig(&lcdhandle_H50261ARP,&Resstrcut);
    
    
    LCD_GPIO_Config_H50261ARP();
    LCD_SegCom_Config_H50261ARP(); 

}

/*********************************************************************************
* Function    : LCD_H50261ARP_BACK_LED
* Description : LCD_H50261ARP_BACK_LED
* Input       : 
* Outpu       : 
* Author      : ZK                         Date : 2022年
**********************************************************************************/
void LCD_H50261ARP_BACK_LED(void)
{   
    GPIO_InitTypeDef    GPIO_LCD_BACK_LED;
    
    GPIO_LCD_BACK_LED.Pin       = GPIO_PIN_5;
    GPIO_LCD_BACK_LED.Mode      = GPIO_MODE_OUTPUT_PP;
    GPIO_LCD_BACK_LED.Pull      = GPIO_NOPULL;
    GPIO_LCD_BACK_LED.Alternate = GPIO_FUNCTION_0;
    
    GPIO_Init(GPIOA, &GPIO_LCD_BACK_LED);
    
    GPIO_LCD_BACK_LED.Pin       = GPIO_PIN_15;
    GPIO_LCD_BACK_LED.Mode      = GPIO_MODE_INPUT;
    GPIO_LCD_BACK_LED.Pull      = GPIO_PULLUP;
    GPIO_LCD_BACK_LED.Alternate = GPIO_FUNCTION_0;
    
    GPIO_Init(GPIOC, &GPIO_LCD_BACK_LED);

    LCD_H50261ARP_BACK_LED_ON;
  
}

