/*
  ******************************************************************************
  * Copyright (c)  2008 - 2024, Shanghai AisinoChip Co.,Ltd .
  * @file    APP.c 
  * @version V1.0.0
  * @date    2024
  * @author  Aisinochip Firmware Team  
  * @brief   lcd demo source code.
  ******************************************************************************        
*/
#include "app.h"  
#include "lcd_YR1618A.h"
#include "lcd_H50261ARP.h"

#define LCD_YR1618A
//#define LCD_H50261ARP
extern LCD_HandleTypeDef           lcdhandle_YR1618A;
extern LCD_HandleTypeDef           lcdhandle_H50261ARP;
LCD_HandleTypeDef           lcdhandle;
#define delay_ms 500
void App_Test(void)
{

	#if defined LCD_YR1618A
	uint8_t NUM_IN[8]={1,2,3,4,5,6,7,8},P=0x3f,COL=0x03,i,j;
	uint16_t S=0xffff;
	LCD_Init_YR1618A();
	
	lcdhandle=lcdhandle_YR1618A;
	
	LCD_YR1618A_BACK_LED();
	YR1618A_VIEW(NUM_IN,P,COL,S);
	System_Delay_MS(5000);
	memset(NUM_IN,10,DIGIT_NUM_YR);P=0;COL=0;S=0;
	YR1618A_VIEW(NUM_IN,P,COL,S);
	
	while(0)
	{
		NUM_IN[7]=0;
		YR1618A_VIEW(NUM_IN,P,COL,S);
		System_Delay_MS(1000);
		NUM_IN[7]=1;
		YR1618A_VIEW(NUM_IN,P,COL,S);
		System_Delay_MS(1000);
		NUM_IN[7]=2;
		YR1618A_VIEW(NUM_IN,P,COL,S);
		System_Delay_MS(1000);
	}
	
	while(1)
	{
		for(i=0;i<DIGIT_NUM_YR;i++)
		{
			for(j=0;j<11;j++)
			{
				NUM_IN[i]=j;
				YR1618A_VIEW(NUM_IN,P,COL,S);
				System_Delay_MS(delay_ms);
			}
			
		}
		memset(NUM_IN,10,DIGIT_NUM_YR);
		YR1618A_VIEW(NUM_IN,P,COL,S);
		for(i=0;i<P_NUM_YR;i++)
		{
			P=0x1u<<i;

			YR1618A_VIEW(NUM_IN,P,COL,S);
			System_Delay_MS(delay_ms);

		}
		P=0;
		YR1618A_VIEW(NUM_IN,P,COL,S);
		for(i=0;i<COL_NUM_YR;i++)
		{
			COL=0x1u<<i;

			YR1618A_VIEW(NUM_IN,P,COL,S);
			System_Delay_MS(delay_ms);

		}
		COL=0;
		YR1618A_VIEW(NUM_IN,P,COL,S);
		
		for(i=0;i<S_NUM_YR;i++)
		{
			S=0x1u<<i;

			YR1618A_VIEW(NUM_IN,P,COL,S);
			System_Delay_MS(delay_ms);

		}
		S=0;
		YR1618A_VIEW(NUM_IN,P,COL,S);
		
	}
	
	#elif defined LCD_H50261ARP

	uint8_t NUM_IN[DIGIT_NUM_H5]={5,6,7,8,9},T=0x7f,P=1,i,j;
	LCD_Init_H50261ARP();
	
	lcdhandle=lcdhandle_H50261ARP;
	
	LCD_H50261ARP_BACK_LED();
	H50261ARP_VIEW(NUM_IN,T,P);
	System_Delay_MS(5000);
	memset(NUM_IN,10,DIGIT_NUM_H5);T=0;P=0;
	H50261ARP_VIEW(NUM_IN,T,P);
	while(1)
	{
		for(i=0;i<DIGIT_NUM_H5;i++)
		{
			for(j=0;j<11;j++)
			{
				NUM_IN[i]=j;
				H50261ARP_VIEW(NUM_IN,T,P);
				System_Delay_MS(delay_ms);
			}
			
		}
		memset(NUM_IN,10,DIGIT_NUM_H5);
		H50261ARP_VIEW(NUM_IN,T,P);
		for(i=0;i<T_NUM_H5;i++)
		{
			T=0x1u<<i;

			H50261ARP_VIEW(NUM_IN,T,P);
			System_Delay_MS(delay_ms);

		}
		T=0;
		H50261ARP_VIEW(NUM_IN,T,P);
		for(i=0;i<P_NUM_H5;i++)
		{
			P=0x1u<<i;

			H50261ARP_VIEW(NUM_IN,T,P);
			System_Delay_MS(delay_ms);

		}
		P=0;
		H50261ARP_VIEW(NUM_IN,T,P);
		
	}
	
	#endif

}
