/*
  ******************************************************************************
  * @file    fxx_it.c
  * @brief   fxx_it source File.
  ******************************************************************************
*/

#include "fxx_it.h"

extern volatile uint32_t gu32_SystemCount; 
extern volatile uint32_t g_iwdtIRQFlag;

/*********************************************************************************
* Function    : HardFault_Handler
* Description : Hard Fault handle, while(1) loop, wait for debug 
* Input       : none 
* Output      : none   
* Author      : xwl                           
**********************************************************************************/  
void HardFault_Handler(void)
{
    while(1);   
} 


/*********************************************************************************
* Function    : SysTick_Handler
* Description : System tick handler
* Input       : none 
* Output      : none 
* Author      : xwl                         
**********************************************************************************/
void SysTick_Handler(void)
{
    gu32_SystemCount++;  
}


/******************************************************************************
*@brief : EXTI handler
*@param : none
*@return: none
******************************************************************************/
void EXTI_IRQHandler(void)
{
    if((EXTI->PDR & IWDT_EXTI_LINE) == IWDT_EXTI_LINE)
    {
        IWDT_FeedDog();
        printfS("EXTI->PDR = 0x%08x\r\n", EXTI->PDR);
        EXTI->PDR = IWDT_EXTI_LINE;
        g_iwdtIRQFlag = 19;
    }
}

