/*
  ******************************************************************************
  * @file    APP.h
  * @author  Chris_Kyle
  * @version V1.0.0
  * @date    2020
  * @brief   GPIO demo Header file.
  ******************************************************************************
*/
#ifndef __APP_H__
#define __APP_H__

#include "fxx_std.h"



#define  GPIO_LED_Port                      GPIOD
#define  GPIO_LED_Pin                       GPIO_PIN_3
#define  GPIO_LED_CLK                       EN_GPIOCD


#define  GPIO_IT_Port                      GPIOC
#define  GPIO_IT_Pin                       GPIO_PIN_13
#define  GPIO_IT_CLK                       EN_GPIOCD

#define  GPIO_IT_IRQ                       GPIOCD_IRQn
#define  GPIO_IT_IRQHandler                GPIOCD_IRQHandler

typedef enum
{
    GPIO_INT,
    LED_BLINK,
	GPIO_PC13
}enum_Mode_t;

extern volatile uint32_t gu32_GPIOIRQ_Flag; 

void APP_GPIO_Test(enum_Mode_t fe_Mode);

#endif
