/*
  ******************************************************************************
  * @file    APP.c
  * @author  Chris_Kyle
  * @version V1.0.0
  * @date    2020
  * @brief   GPIO demo source code.
  ******************************************************************************
*/

#include "app.h"

GPIO_InitTypeDef GPIO_LED_Handle;

GPIO_InitTypeDef GPIO_IT_Handle;  
GPIO_InitTypeDef GPIO_PC13_Handle;  

volatile uint32_t gu32_GPIOIRQ_Flag = false; 
/*********************************************************************************
* Function    : GPIO_LED_Test
* Description : GPIO LED Test
* Input       : 
* Output       : 
**********************************************************************************/
void GPIO_LED_Test()
{
    printfS("This is LED Blinking TEST \r\n");
    System_Module_Enable(GPIO_LED_CLK);
    
    GPIO_LED_Handle.Pin       = GPIO_LED_Pin;
    GPIO_LED_Handle.Mode      = GPIO_MODE_OUTPUT_PP;
    GPIO_LED_Handle.Pull      = GPIO_PULLUP;
    GPIO_LED_Handle.Alternate = GPIO_FUNCTION_0;
    GPIO_Init(GPIO_LED_Port, &GPIO_LED_Handle);
    
    while (1) 
    {
        GPIO_WriteBit(GPIOD, GPIO_PIN_3,Bit_RESET);
        System_Delay_MS(500);
        GPIO_WriteBit(GPIOD, GPIO_PIN_3,Bit_SET);
        System_Delay_MS(500);
    }
}

/*********************************************************************************
* Function    : GPIO_IT_Test
* Description : GPIO IT TEST
* Input       : 
* Output       : 
**********************************************************************************/
void GPIO_IT_Test()
{
    printfS("This is GPIO interrupt TEST. Please press user button to generate interrupt! \r\n");   
    System_Module_Enable(GPIO_IT_CLK);

    GPIO_IT_Handle.Pin       = GPIO_IT_Pin;
    GPIO_IT_Handle.Mode      = GPIO_MODE_IT_FALLING;  
    GPIO_IT_Handle.Pull      = GPIO_PULLUP;
    GPIO_IT_Handle.Alternate = GPIO_FUNCTION_0;

    GPIO_Init(GPIO_IT_Port, &GPIO_IT_Handle);
    
    GPIO_ITConfig(GPIO_IT_Port, GPIO_IT_Pin, ENABLE);
    
    /* Clear Pending Interrupt */
    NVIC_ClearPendingIRQ(GPIO_IT_IRQ);

    /* Enable External Interrupt */
    NVIC_EnableIRQ(GPIO_IT_IRQ);
    while (1) 
    {
        if (gu32_GPIOIRQ_Flag) 
        {
            gu32_GPIOIRQ_Flag = false;

            printfS("Get interrupt flag!!! \r\n");    
        }
    }
}

/*********************************************************************************
* Function    : APP_GPIO_Test
* Description : APP GPIO Test
* Input       : 
* Output       : 
**********************************************************************************/
void APP_GPIO_Test(enum_Mode_t fe_Mode)
{
    switch (fe_Mode)
    {
        case GPIO_INT: 
        {   
            
            GPIO_IT_Test();
            
        }break;
        
        case LED_BLINK: 
        {    
            
            GPIO_LED_Test();
            
        }break;
			
        default: break; 
    }
}

