/*
  ******************************************************************************
  * @file    fxx_it.c
  * @brief   fxx_it source File.
  ******************************************************************************
*/

#include "fxx_it.h"
#include "app.h"

extern volatile uint32_t gu32_SystemCount; 

/*********************************************************************************
* Function    : HardFault_Handler
* Description : Hard Fault handle, while(1) loop, wait for debug 
* Input       : none 
* Output      : none   
* Author      : xwl                           
**********************************************************************************/  
void HardFault_Handler(void)
{
    while(1);   
} 


/*********************************************************************************
* Function    : SysTick_Handler
* Description : System tick handler
* Input       : none 
* Output      : none 
* Author      : xwl                         
**********************************************************************************/
void SysTick_Handler(void)
{
    gu32_SystemCount++;  
}


/*********************************************************************************
* Function    : GPIOAB_IRQHandler
* Description : 
* Input       : 
* Output      : 
**********************************************************************************/
void GPIOAB_IRQHandler(void)
{
 
}

/*********************************************************************************
* Function    : GPIOCD_IRQHandler  
* Description : 
* Input       : 
* Output      : 
**********************************************************************************/
void GPIOCD_IRQHandler(void)
{
               
}

/*********************************************************************************
* Function    : DMA_IRQHandler  
* Description : 
* Input       : 
* Output      : 
**********************************************************************************/
void DMA_IRQHandler(void)
{
    /* Test on DMA Channel6 Transfer Complete interrupt */
    if(DMA_GetITStatus(DMA_IT_FLAG_TC0))
    {
        /* Clear DMA Channel6 Transfer Complete and Global interrupt pending bits */
        DMA_ClearITPendingBit(DMA_IT_FLAG_TC0);
        gu32_Refresh_Flag = 1;
        gu32_ITC_Conunt++;
    }
    else if(DMA_GetITStatus(DMA_IT_FLAG_TE0))
    {
        /* Clear DMA Channel6 error interrupt pending bits */
        DMA_ClearITPendingBit(DMA_IT_FLAG_TE0);
        gu32_IE_Conunt++;
    }
}

