/*
  ******************************************************************************
  * Copyright (c)  2008 - 2024, Shanghai AisinoChip Co.,Ltd .
  * @file    APP.c 
  * @version V1.0.0
  * @date    2024
  * @author  Aisinochip Firmware Team  
  * @brief   UART print demo source code.
  ******************************************************************************        
*/
#include "app.h"  
#include "fxx_comp.h"

void print_reg(uint32_t addr,uint32_t size)
{
	uint8_t i;
	for(i=0;i<size/sizeof(uint32_t);i++)
	{
		printf("addr=0x%08x,data=0x%08x\r\n",addr+i*4,*(uint32_t*)(addr+i*4));
	}
	printf("\r\n");
}
void COMP_Init_APP(void)
{
	
    COMP_InitTypeDef COMP_handle;
	COMP_StructInit(&COMP_handle);
	
    COMP_handle.InPSel = COMP_INPSEL_P0;
    COMP_handle.InMSel = COMP_INMSEL_P0;
    COMP_Init(COMP1,&COMP_handle);
	COMP_Cmd(COMP1,ENABLE);
	
    COMP_handle.InPSel = COMP_INPSEL_P0;
    COMP_handle.InMSel = COMP_INMSEL_VREF_AVDD;
    COMP_handle.CrvEn  = COMP_CRV_ENABLE;
    COMP_handle.CrvSel = COMP_CRVSEL_AVDD;
    COMP_handle.CrvCfg = 2;
    COMP_Init(COMP2,&COMP_handle);
	COMP_Cmd(COMP2,ENABLE);
}

void COMP_GPIO_Init(void)
{
    //COMP1 VINP:PA5, VINM:PA4, VOUT:PA0(AF7)
    GPIO_InitTypeDef GPIO_handle;
    GPIO_handle.Drive = GPIO_DRIVE_LEVEL3;
    GPIO_handle.Mode = GPIO_MODE_ANALOG;
    GPIO_handle.Pin = GPIO_PIN_5;
    GPIO_handle.Pull = GPIO_NOPULL;
    GPIO_Init(GPIOA,&GPIO_handle);
    
    GPIO_handle.Drive = GPIO_DRIVE_LEVEL3;
    GPIO_handle.Mode = GPIO_MODE_ANALOG;
    GPIO_handle.Pin = GPIO_PIN_4;
    GPIO_handle.Pull = GPIO_NOPULL;
    GPIO_Init(GPIOA,&GPIO_handle);
    
    GPIO_handle.Drive = GPIO_DRIVE_LEVEL3;
    GPIO_handle.Mode = GPIO_MODE_AF_PP;
    GPIO_handle.Pin = GPIO_PIN_0;
    GPIO_handle.Pull = GPIO_NOPULL;
    GPIO_handle.Alternate = GPIO_FUNCTION_7;
    GPIO_Init(GPIOA,&GPIO_handle);

    //COMP2 VINP:PB4, VINM:VDDA Crv, VOUT:PA12(AF7)
    GPIO_handle.Drive = GPIO_DRIVE_LEVEL3;
    GPIO_handle.Mode = GPIO_MODE_ANALOG;
    GPIO_handle.Pin = GPIO_PIN_4;
    GPIO_handle.Pull = GPIO_NOPULL;
	GPIO_Init(GPIOB,&GPIO_handle);
	
    GPIO_handle.Drive = GPIO_DRIVE_LEVEL3;
    GPIO_handle.Mode = GPIO_MODE_AF_PP;
    GPIO_handle.Pin = GPIO_PIN_12;
    GPIO_handle.Pull = GPIO_NOPULL;
    GPIO_handle.Alternate = GPIO_FUNCTION_7;
	GPIO_Init(GPIOA,&GPIO_handle);
}

/******************************************************************************
*@brief : app test
*@param : none
*@return: none
******************************************************************************/
void APP_Test(void)
{
    printfS("COMP1 Test\r\n");
	System_Module_Enable(EN_COMP);
    COMP_GPIO_Init();
    COMP_Init_APP();
    

    while(1)
	{
//	print_reg(COMP_BASE,sizeof(COMP_TypeDef));
		System_Delay_MS(500);
		if(COMP_GetOutputLevel(COMP1))
			printf("COMP1 1\r\n");
		else
			printf("COMP1 0\r\n");
		if(COMP_GetOutputLevel(COMP2))
			printf("COMP2 1\r\n");
		else
			printf("COMP2 0\r\n");
	};
}









