/*
  ******************************************************************************
  * @file    fxx_it.c
  * @brief   fxx_it source File.
  ******************************************************************************
*/

#include "fxx_it.h"

extern volatile uint32_t gu32_SystemCount; 
extern volatile uint32_t g_IRQFlag;
extern volatile uint32_t g_ADCValue;


/*********************************************************************************
* Function    : HardFault_Handler
* Description : Hard Fault handle, while(1) loop, wait for debug 
* Input       : none 
* Output      : none   
* Author      : xwl                           
**********************************************************************************/  
void HardFault_Handler(void)
{
    while(1);   
} 


/*********************************************************************************
* Function    : SysTick_Handler
* Description : System tick handler
* Input       : none 
* Output      : none 
* Author      : xwl                         
**********************************************************************************/
void SysTick_Handler(void)
{
    gu32_SystemCount++;  
}

/******************************************************************************
* brief : ADC IRQHandler.
* param : none
* return: none
******************************************************************************/ 
void ADC_IRQHandler(void)
{
    if((SET == ADC_GetITStatus(ADC_IT_FLAG_EOC)) && (SET == ADC_GetITStatus(ADC_IT_FLAG_EOG)))
    {
        g_IRQFlag = 1;
        g_ADCValue = ADC_GetRegularConversionValue();
        ADC_ClearITPendingBit(ADC_IT_FLAG_EOC | ADC_IT_FLAG_EOG);
    }
    if(SET == ADC_GetITStatus(ADC_IT_FLAG_AWD))
    {
        g_IRQFlag = 1;
        ADC_ClearITPendingBit(ADC_IT_FLAG_AWD);
    }        
}

/******************************************************************************
* brief : DMA IRQHandler.
* param : none
* return: none
******************************************************************************/ 
void DMA_IRQHandler(void)
{
    /* Test on DMA Channel2 Transfer Complete interrupt */
    if(DMA_GetITStatus(DMA_IT_FLAG_TC2))
    {
        /* Clear DMA Channel2 Transfer Complete and Global interrupt pending bits */
        DMA_ClearITPendingBit(DMA_IT_FLAG_TC2);
        g_IRQFlag++;
    }
    else if(DMA_GetITStatus(DMA_IT_FLAG_TE2))
    {
        /* Clear DMA Channel2 error interrupt pending bits */
        DMA_ClearITPendingBit(DMA_IT_FLAG_TE2);
        g_IRQFlag++;
    }
}

