
/******************************************************************************
*@file  : app.c
*@brief : application
******************************************************************************/

#include "app.h"


volatile uint32_t g_IRQFlag;
volatile uint32_t g_ADCValue;


/******************************************************************************
* @brief : ADC GPIO config.
* @param : None
* @return: None
******************************************************************************/
void ADC_GPIO_Config(void)
{
    GPIO_InitTypeDef GPIO_InitStruct;
   
    /* Configure ADC Channel_0 pin(PD5) as analog input */
    GPIO_InitStruct.Pin       = GPIO_PIN_5;
    GPIO_InitStruct.Mode      = GPIO_MODE_ANALOG;
    GPIO_InitStruct.Pull      = GPIO_NOPULL;
    GPIO_Init(GPIOD, &GPIO_InitStruct); 

    /* Configure ADC Channel_1 pin(PA4) as analog input */
    GPIO_InitStruct.Pin       = GPIO_PIN_4;
    GPIO_InitStruct.Mode      = GPIO_MODE_ANALOG;
    GPIO_InitStruct.Pull      = GPIO_NOPULL;
    GPIO_Init(GPIOA, &GPIO_InitStruct); 

    /* Configure ADC Channel_2 pin(PA5) as analog input */
    GPIO_InitStruct.Pin       = GPIO_PIN_5;
    GPIO_InitStruct.Mode      = GPIO_MODE_ANALOG;
    GPIO_InitStruct.Pull      = GPIO_NOPULL;
    GPIO_Init(GPIOA, &GPIO_InitStruct); 

    /* Configure ADC Channel_3 pin(PA6) as analog input */
    GPIO_InitStruct.Pin       = GPIO_PIN_6;
    GPIO_InitStruct.Mode      = GPIO_MODE_ANALOG;
    GPIO_InitStruct.Pull      = GPIO_NOPULL;
    GPIO_Init(GPIOA, &GPIO_InitStruct);     

    /* Configure ADC Channel_4 pin(PA7) as analog input */
    GPIO_InitStruct.Pin       = GPIO_PIN_7;
    GPIO_InitStruct.Mode      = GPIO_MODE_ANALOG;
    GPIO_InitStruct.Pull      = GPIO_NOPULL;
    GPIO_Init(GPIOA, &GPIO_InitStruct);  

    /* Configure ADC Channel_5 pin(PC4) as analog input */
    GPIO_InitStruct.Pin       = GPIO_PIN_4;
    GPIO_InitStruct.Mode      = GPIO_MODE_ANALOG;
    GPIO_InitStruct.Pull      = GPIO_NOPULL;
    GPIO_Init(GPIOC, &GPIO_InitStruct);  

    /* Configure ADC Channel_6 pin(PC5) as analog input */
    GPIO_InitStruct.Pin       = GPIO_PIN_5;
    GPIO_InitStruct.Mode      = GPIO_MODE_ANALOG;
    GPIO_InitStruct.Pull      = GPIO_NOPULL;
    GPIO_Init(GPIOC, &GPIO_InitStruct);  

    /* Configure ADC Channel_7 pin(PB0) as analog input */
    GPIO_InitStruct.Pin       = GPIO_PIN_0;
    GPIO_InitStruct.Mode      = GPIO_MODE_ANALOG;
    GPIO_InitStruct.Pull      = GPIO_NOPULL;
    GPIO_Init(GPIOB, &GPIO_InitStruct);   

    /* Configure ADC Channel_8 pin(PD4) as analog input */
    GPIO_InitStruct.Pin       = GPIO_PIN_4;
    GPIO_InitStruct.Mode      = GPIO_MODE_ANALOG;
    GPIO_InitStruct.Pull      = GPIO_NOPULL;
    GPIO_Init(GPIOD, &GPIO_InitStruct); 

//    /* Configure ADC Channel_9 pin(PA3) as analog input */
//    GPIO_InitStruct.Pin       = GPIO_PIN_3;
//    GPIO_InitStruct.Mode      = GPIO_MODE_ANALOG;
//    GPIO_InitStruct.Pull      = GPIO_NOPULL;
//    GPIO_Init(GPIOA, &GPIO_InitStruct);

//    /* Configure ADC Channel_10 pin(PA2) as analog input */
//    GPIO_InitStruct.Pin       = GPIO_PIN_2;
//    GPIO_InitStruct.Mode      = GPIO_MODE_ANALOG;
//    GPIO_InitStruct.Pull      = GPIO_NOPULL;
//    GPIO_Init(GPIOA, &GPIO_InitStruct);

    /* Configure ADC Channel_11 pin(PA0) as analog input */
    GPIO_InitStruct.Pin       = GPIO_PIN_0;
    GPIO_InitStruct.Mode      = GPIO_MODE_ANALOG;
    GPIO_InitStruct.Pull      = GPIO_NOPULL;
    GPIO_Init(GPIOA, &GPIO_InitStruct);

    /* Configure ADC Channel_12 pin(PC3) as analog input */
    GPIO_InitStruct.Pin       = GPIO_PIN_3;
    GPIO_InitStruct.Mode      = GPIO_MODE_ANALOG;
    GPIO_InitStruct.Pull      = GPIO_NOPULL;
    GPIO_Init(GPIOC, &GPIO_InitStruct);

    /* Configure ADC Channel_13 pin(PC2) as analog input */
    GPIO_InitStruct.Pin       = GPIO_PIN_2;
    GPIO_InitStruct.Mode      = GPIO_MODE_ANALOG;
    GPIO_InitStruct.Pull      = GPIO_NOPULL;
    GPIO_Init(GPIOC, &GPIO_InitStruct);

    /* Configure ADC Channel_14 pin(PC1) as analog input */
    GPIO_InitStruct.Pin       = GPIO_PIN_1;
    GPIO_InitStruct.Mode      = GPIO_MODE_ANALOG;
    GPIO_InitStruct.Pull      = GPIO_NOPULL;
    GPIO_Init(GPIOC, &GPIO_InitStruct);

    /* Configure ADC Channel_15 pin(PC0) as analog input */
    GPIO_InitStruct.Pin       = GPIO_PIN_0;
    GPIO_InitStruct.Mode      = GPIO_MODE_ANALOG;
    GPIO_InitStruct.Pull      = GPIO_NOPULL;
    GPIO_Init(GPIOC, &GPIO_InitStruct);

//    /* Configure ADC Channel_VBAT pin(PA1) as analog input */
//    GPIO_InitStruct.Pin       = GPIO_PIN_1;
//    GPIO_InitStruct.Mode      = GPIO_MODE_ANALOG;
//    GPIO_InitStruct.Pull      = GPIO_NOPULL;
//    GPIO_Init(GPIOA, &GPIO_InitStruct);

//    /* Configure ADC Channel_EXT2 pin(PB1) as analog input */
//    GPIO_InitStruct.Pin       = GPIO_PIN_1;
//    GPIO_InitStruct.Mode      = GPIO_MODE_ANALOG;
//    GPIO_InitStruct.Pull      = GPIO_NOPULL;
//    GPIO_Init(GPIOB, &GPIO_InitStruct); 
//    
//    /* Configure ADC Channel_EXT3 pin(PB2) as analog input */
//    GPIO_InitStruct.Pin       = GPIO_PIN_2;
//    GPIO_InitStruct.Mode      = GPIO_MODE_ANALOG;
//    GPIO_InitStruct.Pull      = GPIO_NOPULL;
//    GPIO_Init(GPIOB, &GPIO_InitStruct); 
}


/******************************************************************************
* @brief : Get ADC Value With Polling.
* @param : RegularData: Pointing to regular channel conversion data buffer
* @param : InjectData: Pointing to inject channel conversion data buffer
* @param : Length: regular and inject channel conversion data buffer length 
* @return: None
******************************************************************************/
void ADC_GetValueWithPolling(uint32_t* RegularData, uint32_t* InjectData, uint32_t Length, uint32_t Timeout)
{
    uint32_t tmp_status;
    uint32_t uiTimeout;  
    
    /* ADC */
    ADC_Cmd(ADC_STATE_ENABLE);    

    if(RegularData != NULL)
    {
        /* ʼתͨ */
        ADC_RegularSoftwareStart();
    }    
    if(InjectData != NULL)
    {
        /* ʼתעͨ */
        ADC_InjectedSoftwareStart();        
    }

    uiTimeout = Timeout;

    while(Length)
    {
        tmp_status = ADC->SR;
        if(tmp_status & ADC_IT_FLAG_EOC)//ͨת
        {
            *RegularData = ADC_GetRegularConversionValue();//ȡתĽ   
            ADC_ClearFlag(ADC_IT_FLAG_EOC);
            RegularData++;
            Length--;
        }
        if(tmp_status & ADC_IT_FLAG_JEOC)//עͨת
        {
            *InjectData = ADC_GetInjectedConversionValue();
            ADC_ClearFlag(ADC_IT_FLAG_JEOC);
            Length--;            
        }
        if(tmp_status & ADC_IT_FLAG_OVERF)//ͨ
        {
            ADC_ClearFlag(ADC_IT_FLAG_OVERF);
        }        
        if(tmp_status & ADC_IT_FLAG_EOG)//ͨת
        {
            ADC_ClearFlag(ADC_IT_FLAG_EOG);
            break;
        }

        if(uiTimeout)
        {
            uiTimeout--;
            if(uiTimeout == 0)
            {
                return;
            }
        }
    }

    ADC_Cmd(ADC_STATE_DISABLE); 
    ADC_ClearFlag(ADC_IT_FLAG_ALL);
}

/******************************************************************************
* @brief : ADC Get The VrefP Value.
* @param : Pre_Channel:Can be ADC_CHANNEL_2 ADC_CHANNEL_8 ADC_CHANNEL_10
* @return: VrefP Value
******************************************************************************/ 
uint32_t ADC_GetVrefP(uint8_t Pre_Channel)
{
    uint32_t TrimValue_3v, AdcValue_VrefP[2], VrefP, temp;
    /* ʹBUFFER */
    ADC_BufferCmd(ADC_STATE_ENABLE);
    /* 1.2V׼ѹʹ */
    ADC_VREF1P2Cmd(ADC_STATE_ENABLE);
    /* ùͨг */
    ADC_RegularChannelSequenceLengthConfig(2);
    /* ùͨ */
    ADC_RegularChannelConfig(Pre_Channel, ADC_SEQUENCE_SQ1, ADC_SMP_CLOCK_320);
    ADC_RegularChannelConfig(ADC_CHANNEL_BGR, ADC_SEQUENCE_SQ2, ADC_SMP_CLOCK_320);
    
    ADC_GetValueWithPolling(AdcValue_VrefP, NULL, 2, 0);
    
    printfS("BGR[%d] :  0x%08x[%d], VBGR = %dmV\r\n", ((AdcValue_VrefP[1] >> 16) & 0xFF), AdcValue_VrefP[1], \
                            AdcValue_VrefP[1] & 0xFFF, ((AdcValue_VrefP[1] & 0xFFF) * 3300 / 4095));
    
    
    TrimValue_3v = *(volatile uint32_t*)(0x00080240); //Read the 1.2v trim value in 3.0v vrefp.

    printfS("The adc 1.2v trim value is : 0x%08x \r\n", TrimValue_3v);

    if(((~TrimValue_3v & 0xFFFF0000) >> 16) == (TrimValue_3v & 0x0000FFFF))
    {
        temp = TrimValue_3v & 0xFFF;
        
        VrefP = (uint32_t)(temp * 3000 / (AdcValue_VrefP[1] & 0xFFF));
        
        printfS("Vrefp : %d mV \r\n", VrefP);
        return VrefP;
    }
    return 0;    
}


/******************************************************************************
* @brief : ADC Regular Polling Mode test.
* @param : none
* @return: none
******************************************************************************/ 
void ADC_Regular_Polling_Nchannels_Test(void)
{
    uint32_t i, AdcValBuff[14];
    /* ùͨг */
    ADC_RegularChannelSequenceLengthConfig(14);
    /* ùͨ */
    ADC_RegularChannelConfig(ADC_CHANNEL_0, ADC_SEQUENCE_SQ1, ADC_SMP_CLOCK_320);
    ADC_RegularChannelConfig(ADC_CHANNEL_1, ADC_SEQUENCE_SQ2, ADC_SMP_CLOCK_320);
    ADC_RegularChannelConfig(ADC_CHANNEL_2, ADC_SEQUENCE_SQ3, ADC_SMP_CLOCK_320);
    ADC_RegularChannelConfig(ADC_CHANNEL_3, ADC_SEQUENCE_SQ4, ADC_SMP_CLOCK_320); 
    ADC_RegularChannelConfig(ADC_CHANNEL_4, ADC_SEQUENCE_SQ5, ADC_SMP_CLOCK_320);
    ADC_RegularChannelConfig(ADC_CHANNEL_5, ADC_SEQUENCE_SQ6, ADC_SMP_CLOCK_320);
    ADC_RegularChannelConfig(ADC_CHANNEL_6, ADC_SEQUENCE_SQ7, ADC_SMP_CLOCK_320);
    ADC_RegularChannelConfig(ADC_CHANNEL_7, ADC_SEQUENCE_SQ8, ADC_SMP_CLOCK_320);
    ADC_RegularChannelConfig(ADC_CHANNEL_8, ADC_SEQUENCE_SQ9, ADC_SMP_CLOCK_320);
    ADC_RegularChannelConfig(ADC_CHANNEL_11, ADC_SEQUENCE_SQ10, ADC_SMP_CLOCK_320);
    ADC_RegularChannelConfig(ADC_CHANNEL_12, ADC_SEQUENCE_SQ11, ADC_SMP_CLOCK_320);
    ADC_RegularChannelConfig(ADC_CHANNEL_13, ADC_SEQUENCE_SQ12, ADC_SMP_CLOCK_320);
    ADC_RegularChannelConfig(ADC_CHANNEL_14, ADC_SEQUENCE_SQ13, ADC_SMP_CLOCK_320);
    ADC_RegularChannelConfig(ADC_CHANNEL_15, ADC_SEQUENCE_SQ14, ADC_SMP_CLOCK_320);
    //ADC_RegularChannelConfig(ADC_CHANNEL_9, ADC_SEQUENCE_SQ15, ADC_SMP_CLOCK_320);
    //ADC_RegularChannelConfig(ADC_CHANNEL_10, ADC_SEQUENCE_SQ16, ADC_SMP_CLOCK_320);
    while(1)
    {
        for (i = 0; i < 14; i++)
        {
            AdcValBuff[i] = 0;
        }

        ADC_GetValueWithPolling(AdcValBuff, NULL, 14, 0);

        for (i = 0; i < 14; i++)
        {
            printfS("Channel_%d = %d\r\n", ((AdcValBuff[i] >> 16) & 0xFF), AdcValBuff[i]&0xFFF);
        } 
        System_Delay_MS(1000);     
    }       
}


/******************************************************************************
* @brief : ADC Interrupt Mode test.
* @param : none
* @return: none
******************************************************************************/ 
void ADC_Interrupt_Test(void)
{
    /* ùͨг */
    ADC_RegularChannelSequenceLengthConfig(1);
    /* ùͨ */
    ADC_RegularChannelConfig(ADC_CHANNEL_15, ADC_SEQUENCE_SQ1, ADC_SMP_CLOCK_320);
    /* ADC */
    ADC_Cmd(ADC_STATE_ENABLE);

    /* עͨת־ */
    ADC_ClearFlag(ADC_IT_FLAG_EOC | ADC_IT_FLAG_EOG);
    
    /* ʹעͨתж */
    ADC_ITConfig(ADC_IT_FLAG_EOC | ADC_IT_FLAG_EOG, ADC_STATE_ENABLE); 

    /* ж */
    NVIC_ClearPendingIRQ(ADC_IRQn);
    
    /* ʹADCж */
    NVIC_EnableIRQ(ADC_IRQn);    

    g_IRQFlag = 0;
    g_ADCValue = 0;

    
    /* ʼתͨ */
    ADC_RegularSoftwareStart(); 
    
    while(1)
    {
        if(g_IRQFlag)
        {
            g_IRQFlag = 0;   
            printfS("Channel %d = %d\r\n", ((g_ADCValue >> 16) & 0xFF), g_ADCValue & 0xFFF);
            System_Delay_MS(1000);
            /* ADC */
            ADC_Cmd(ADC_STATE_ENABLE);          
            /* ʼתͨ */
            ADC_RegularSoftwareStart(); 
        }   
    }
}


/******************************************************************************
* brief : ADC External trigger test.
* param : none
* return: none
******************************************************************************/ 
void ADC_External_Trigger_Test(void)
{
    TIM_Base_InitTypeDef TIM_TimeBaseStructure; 
    uint32_t timer_clock; 
    
    /* TIM */
    System_Module_Enable(EN_TIM6); 
    timer_clock = System_Get_APBClock(); 
    if (System_Get_SystemClock() != System_Get_APBClock())  // if hclk/pclk != 1, then timer clk = pclk * 2  
    {
       timer_clock =  System_Get_APBClock() << 1;    
    }
	TIM_TimeBaseStructure.ClockDivision = TIM_CLOCKDIVISION_DIV1; 
	TIM_TimeBaseStructure.CounterMode = TIM_COUNTERMODE_UP; 
	TIM_TimeBaseStructure.RepetitionCounter = 0;  
	TIM_TimeBaseStructure.Prescaler = (timer_clock/10000) - 1;  
	TIM_TimeBaseStructure.Period = (10000/1000)*2000 - 1;  // 2000ms  
	TIM_TimeBase_Init(TIM6, &TIM_TimeBaseStructure);           
    /* ѡTIMxģʽ */
    TIM_SelectOutputTrigger(TIM6, TIM_TRGO_UPDATE);
    /* ʹTIM6 */
    TIM_Cmd(TIM6, ENABLE);


    g_IRQFlag = 0;
    g_ADCValue = 0;
    
    /* עͨת */
    ADC_InjectedConvertCmd(ADC_STATE_ENABLE); 
    
    /* עͨ */
    ADC_InjectedChannelConfig(ADC_CHANNEL_12, ADC_SMP_CLOCK_320);
    
    /* ⲿ */
    ADC_InjectedExternalTriggerConfig(ADC_EXTERNAL_TIG6);
    
    /* עͨת־ */
    ADC_ClearFlag(ADC_IT_FLAG_JEOC);
    
    /* ADC */
    ADC_Cmd(ADC_STATE_ENABLE);

    while(1)
    {
        if(SET == ADC_GetFlagStatus(ADC_IT_FLAG_JEOC))
        {
            g_IRQFlag = 1;
            g_ADCValue = ADC_GetInjectedConversionValue();
            ADC_ClearFlag(ADC_IT_FLAG_JEOC);  
            printfS("Channel %d = %d\r\n", ((g_ADCValue >> 16) & 0xFF), g_ADCValue & 0xFFF);
        }
    }        
}


/******************************************************************************
* @brief : ADC DMA Mode Test.
* @param : none
* @return: none
******************************************************************************/ 
void ADC_DMA_Test(void)
{
    DMA_InitTypeDef adc_dma_init;           
    uint32_t adc_val_buff[2], i;
    
    /* DMA */
    System_Module_Enable(EN_DMA);
    DMA_DeInit(DMA_Channel2);
    adc_dma_init.Request_ID       = REQ0_ADC;
    adc_dma_init.SrcAddr          = (uint32_t)&ADC->DR;
    adc_dma_init.DstAddr          = (uint32_t)adc_val_buff;
    adc_dma_init.Data_Flow        = DMA_DATA_FLOW_P2M;
    adc_dma_init.DMA_BufferSize   = 2;
    adc_dma_init.Source_Inc       = DMA_SOURCE_ADDR_INCREASE_DISABLE;
    adc_dma_init.Desination_Inc   = DMA_DST_ADDR_INCREASE_ENABLE;
    adc_dma_init.Source_Width     = DMA_SRC_WIDTH_WORD;
    adc_dma_init.Desination_Width = DMA_DST_WIDTH_WORD;
    adc_dma_init.DMA_Mode         = DMA_CIRCULAR;

    DMA_Init(DMA_Channel2, &adc_dma_init);
    /* DMAͨ2ж */
    DMA_ITConfig(DMA_Channel2, DMA_CHANNEL_CONFIG_ITC, ENABLE);    

    /* ʹDMAж */
    NVIC_ClearPendingIRQ(DMA_IRQn);
    NVIC_EnableIRQ(DMA_IRQn);
    
    
    /* ùͨг */
    ADC_RegularChannelSequenceLengthConfig(2);
    /* ùͨ */
    ADC_RegularChannelConfig(ADC_CHANNEL_0,  ADC_SEQUENCE_SQ1,  ADC_SMP_CLOCK_320);
    ADC_RegularChannelConfig(ADC_CHANNEL_7,  ADC_SEQUENCE_SQ2,  ADC_SMP_CLOCK_320);
    /* Ϊģʽ */
    ADC_DifferentialConfig(ADC_CHANNEL_0, ADC_DIFFERENTIAL_MODE);
    ADC_DifferentialConfig(ADC_CHANNEL_7, ADC_DIFFERENTIAL_MODE);
    /* ʹDMAģʽ */
    ADC_DMACmd(ADC_STATE_ENABLE);
    /* תģʽ */
    ADC_ContinuousModeCmd(ADC_STATE_ENABLE);
    /* ʹADCж */
    NVIC_ClearPendingIRQ(ADC_IRQn);
    NVIC_EnableIRQ(ADC_IRQn);
    
    /* ADC */
    ADC_Cmd(ADC_STATE_ENABLE);

    /* б־ */
    ADC_ClearFlag(ADC_IT_FLAG_ALL);
    
    /* رADCж */
    NVIC_ClearPendingIRQ(ADC_IRQn);
    NVIC_DisableIRQ(ADC_IRQn); 
      
           
    /* Enable DMA channel2 transfer */
    DMA_Cmd(DMA_Channel2, ENABLE);
    
    /* ʼתͨ */
    ADC_RegularSoftwareStart();

    while(1)
    {
        while(!g_IRQFlag){};
            
        g_IRQFlag--;
            
        for (i = 0; i < 2; i++)
        {
            printfS("Channel_%d = %d\r\n", ((adc_val_buff[i] >> 16) & 0xFF), adc_val_buff[i]&0xFFF);
        }
        System_Delay_MS(1000);
    }    
}


/******************************************************************************
* @brief : ADC Analog watchdog Test.
* @param : none
* @return: none
******************************************************************************/ 
void ADC_Analog_Watchdog_Test(void)
{
    uint32_t regular_buff[4], inject_buff[1], i;
    /* ùͨг */
    ADC_RegularChannelSequenceLengthConfig(4);
    /* ùͨ */
    ADC_RegularChannelConfig(ADC_CHANNEL_15, ADC_SEQUENCE_SQ1, ADC_SMP_CLOCK_320);
    ADC_RegularChannelConfig(ADC_CHANNEL_14, ADC_SEQUENCE_SQ2, ADC_SMP_CLOCK_320);
    ADC_RegularChannelConfig(ADC_CHANNEL_13, ADC_SEQUENCE_SQ3, ADC_SMP_CLOCK_320);
    ADC_RegularChannelConfig(ADC_CHANNEL_12, ADC_SEQUENCE_SQ4, ADC_SMP_CLOCK_320);

    /* עͨ */
    ADC_InjectedChannelConfig(ADC_CHANNEL_7, ADC_SMP_CLOCK_320);
    /* עͨת */
    ADC_InjectedConvertCmd(ADC_STATE_ENABLE);

    /* ע鵥һͨʹÿŹ */
    ADC_AnalogWatchdogConfig(ADC_ANALOGWDG_RCH_OR_JCH_SINGLE);    
    ADC_AnalogWatchdogRegularChannelConfig(ADC_CHANNEL_15);
    ADC_AnalogWatchdogInjectChannelConfig(ADC_CHANNEL_7);
    ADC_AnalogWatchdogSingleThresholdConfig(4000, 10);
    
    /* б־ */
    ADC_ClearFlag(ADC_IT_FLAG_ALL);
    /* ʹģ⿴Źж */
    ADC_ITConfig(ADC_IT_FLAG_AWD, ADC_STATE_ENABLE); 
    /* ʹADCж */
    NVIC_ClearPendingIRQ(ADC_IRQn);
    NVIC_EnableIRQ(ADC_IRQn);    

    g_IRQFlag = 0;
    
    while(1)
    {
        for (i = 0; i < 4; i++)
        {
            regular_buff[i] = 0;
        }
        inject_buff[0] = 0;
        ADC_GetValueWithPolling(regular_buff, inject_buff, 5, 0);
        
        for (i = 0; i < 4; i++)
        {
            printfS("Regular Channel %d = 0x%03x\r\n", (regular_buff[i] >> 16 & 0xFF), (regular_buff[i] & 0xFFF));
        }  
        printfS("Inject Channel %d = 0x%03x\r\n", (inject_buff[0] >> 16 & 0xFF), (inject_buff[0]& 0xFFF));
        
        if(g_IRQFlag)
        {
            printfS("ADC Channel Level Out Of Window. \r\n");
            g_IRQFlag = 0;       
        }         
        System_Delay_MS(1000);     
    }
}

/******************************************************************************
*@brief : ADC test
*@param : test_mode: Test mode selection
*@return: none
******************************************************************************/
void ADC_Test(Test_mode_t test_mode)
{
    uint32_t VrefP;
    ADC_Init();
    ADC_ClockConfig(ADC_CLOCK_DIV4);
    ADC_GPIO_Config();
    VrefP = ADC_GetVrefP(ADC_CHANNEL_8);
    printfS("The VrefP value is : %d \r\n", VrefP);
    
    switch(test_mode)
    {
        case Test_ADC_Regular:
        {
            ADC_Regular_Polling_Nchannels_Test();
        }break;
        case Test_ADC_Interrupt:
        {
            ADC_Interrupt_Test();           
        }break;
        case Test_ADC_External_Trigger:
        {
            ADC_External_Trigger_Test();           
        }break;
        case Test_ADC_DMA_Diff:
        {
            ADC_DMA_Test();           
        }break;
        case Test_ADC_AnalogWatchdog:
        {
            ADC_Analog_Watchdog_Test();           
        }break;         
        default:
        {
            printfS("This application does not support\r\n");
        }break;
    }
}

/******************************************************************************
* @brief : app test.
* @param : None
* @return: None
******************************************************************************/
void APP_Test(void)
{
    /*
    Test_ADC_Regular,
    Test_ADC_Interrupt,
    Test_ADC_External_Trigger,
    Test_ADC_DMA_Diff,
    Test_ADC_AnalogWatchdog,
    */
    ADC_Test(Test_ADC_Regular);

}










