#include "ACM32Fxx_HAL.h"

/*****************************************************************
@	Stop͹ģʽرEflash,Ram
@	
@	
******************************************************************/
void Enter_Stop_Ram(void)
{
	volatile uint32_t i;
    
    SysTick->CTRL = 0;              //SysTick Off
	__set_PRIMASK(1);               // disable interrupt 

   /* STOP ģʽ¹رLDO12RC64M */
    SCU->STOPCFG   |=  (1 << 3);    //STOP ģʽ¹ر RC64M
    SCU->STOPCFG   |=  (1 << 9);    //STOP ģʽ½LPSTOP
    
    /* All Clock Disable */
    SCU->CLKOCR &= ~(1ul << 31);    // Buzzer2 Disable
    SCU->CLKOCR &= ~(1ul << 23);    // Buzzer1 Disable
    
    SCU->IPCKENR1 = 0x0000E000;
    SCU->IPCKENR2 = 0x00000070;
    
    /* ADCãԽͲֹ */
    ADC->TSREF |= (1 << 27);
    
    SCU->PCDADS |= 0x1 << 19; //Set Boot Pin to analog.

    SCU->RCHCR &=  (~SCU_RCHCR_RC4M_EN); //RC4M Disable.
    
    TKEY->ISR = 0xFFF;

    /*رSRAMδÿռ*/
	//SCU->MEMCFG  |=(1<<16)| (2<<16)|(3<<16);

    /*RAM Retention ģʽ*/	
	SCU->STOPCFG |=(1<<28);
    
    EXTI->PDR = 0xFFFFFFFF; //EXTIжϱ־λ
    //RTC дʹ
    SCU->STOPCFG |= SCU_STOPCFG_RTC_WE;
    RTC->SR = 0xFFFFFFFF;   //RTCжϱ־λ
    //RTC дֹ  
    SCU->STOPCFG &= (~SCU_STOPCFG_RTC_WE);
    
    /*Eflash sleepģʽ */
    EFC->CTRL |= 1<<12;
    
    SET_BIT(SCB->SCR, ((uint32_t)SCB_SCR_SLEEPDEEP_Msk));   // Set SLEEPDEEP bit of Cortex System Control Register 
    
    SCU->STOPCFG &= (~BIT11);  // PDDS=0     

	/*---------------stopģʽ-----------*/
	/* Wait For Interrupt */   
    __WFI();
	
	/*---------------Ѻ-------------*/
	CLEAR_BIT(SCB->SCR, ((uint32_t)SCB_SCR_SLEEPDEEP_Msk)); 
	 	 
	/* ѺEflash˳Sleepģʽ */
	EFC->CTRL &= ~(1<<12);
	for(i = 0; i < 10 *5000; i++); //Elash˳Sleepʱ10uS
    
    SCU->RCHCR |= SCU_RCHCR_RC4M_EN; //RC4M Enable.
    
	__set_PRIMASK(0);    // enable interrupt 
    /* Enable SysTick IRQ and SysTick Timer */ 
    SysTick->CTRL  = SysTick_CTRL_CLKSOURCE_Msk |
                   SysTick_CTRL_TICKINT_Msk   |
                   SysTick_CTRL_ENABLE_Msk;  
}



