/*
  ******************************************************************************
  * Copyright (c)  2008 - 2022, Shanghai AisinoChip Co.,Ltd .
  * @file    APP.c 
  * @version V1.0.0
  * @date    2022
  * @author  Aisinochip Firmware Team  
  * @brief   Stop Mode demo source code.
  ******************************************************************************        
*/
#include "APP.h"

GPIO_InitTypeDef GPIOD_Handle;

EXTI_HandleTypeDef EXTI_Line9_Handle;

GPIO_InitTypeDef GPIO_PB9_Handle;


/*********************************************************************************
* Function    : EXTI_IRQHandler
* Description : EXTI Interrupt Handler
* Input       : None
* Output      : None
**********************************************************************************/
void EXTI_IRQHandler(void)
{ 
    HAL_EXTI_IRQHandler(&EXTI_Line9_Handle);
}

void Exit_Config(void)
{
	System_Module_Enable(EN_EXTI);

    /* Initialization GPIO */
    GPIO_PB9_Handle.Pin       = GPIO_PIN_9;
    GPIO_PB9_Handle.Mode      = GPIO_MODE_INPUT;
    GPIO_PB9_Handle.Pull      = GPIO_PULLUP;
    GPIO_PB9_Handle.Alternate = GPIO_FUNCTION_0;

    HAL_GPIO_Init(GPIOB, &GPIO_PB9_Handle);
    
    /* Config EXTI */
    EXTI_Line9_Handle.u32_Line    = EXTI_LINE_9;
    EXTI_Line9_Handle.u32_Mode    = EXTI_MODE_INTERRUPT;
    EXTI_Line9_Handle.u32_Trigger = EXTI_TRIGGER_FALLING;
    EXTI_Line9_Handle.u32_GPIOSel = EXTI_GPIOB;

    HAL_EXTI_SetConfigLine(&EXTI_Line9_Handle);

}

void GPIO_Turn()  /* תIOʱ */
{
    uint32_t i;
    GPIOD_Handle.Pin       = GPIO_PIN_3 ;
    GPIOD_Handle.Mode      = GPIO_MODE_OUTPUT_PP;
    GPIOD_Handle.Pull      = GPIO_PULLUP;
    GPIOD_Handle.Alternate = GPIO_FUNCTION_0;

    HAL_GPIO_Init(GPIOD, &GPIOD_Handle);

    for(i = 0; i < 20 ; i++)
    {   
		HAL_GPIO_WritePin(GPIOD, GPIO_PIN_3 , GPIO_PIN_SET);
		System_Delay_MS(100);
        HAL_GPIO_WritePin(GPIOD, GPIO_PIN_3 , GPIO_PIN_CLEAR);
		System_Delay_MS(100);
    }
}


static void SimpleDelay(volatile uint32_t delay)  
{
    while(delay--)
    {
        ;
    }
}

/*********************************************************************************
*  :  Enter_LowPower_STOP
*    :  STOP & ģģIP 
* ˵   :  
*    :  
*    :  
**********************************************************************************/
void Enter_LowPower_STOP(void)
{
    /* رж */
    __set_PRIMASK(1);
    /* رSystickж */     
    SysTick->CTRL &= ~SysTick_CTRL_TICKINT_Msk;
    /* SystickжϹ־ */    
    SCB->ICSR = BIT25;
    
    HAL_RTC_PCLK_ENABLE();
	/*----------------stopģʽǰ-------------*/
    /* IOλģ */
    SCU->PABADS= 0xFFFFFFFF;
    SCU->PCDADS  = 0xFFFFFFFF;

	/*ʱлRCH*/
	SCU->CCR1 =SYS_CLK_SRC_RCH;
    /* رXTHXTLRC4M32K ʱ  */
    SCU->RCHCR&= ~(1 << 16);      // RC4M Disable
    SCU->XTHCR &= ~(1 <<  0);     // XTH  Disable
	SCU->PLLCR &= ~(1 << 0);      //PLL Disable

    SCU->STOPCFG   |=  (1 << 0);  // RTCдʹ
    PMU->ANACR &= ~(1 << 0);      // XTL   Disable
    PMU->ANACR &= ~(1 << 8);      // RC32K Disable

	/*Դ*/
	Exit_Config();	
	
    /* LVD Disable */
    SCU->LVDCFG &= ~(1 << 0);

    /* STOP ģʽ¹رLDO12RC64M */
    /* STOPģʽǰҪMLDO12ѹԶ(MLDO12LV)Ϊ1.0VԼСرMLDO12ĵѹ */
    SCU->STOPCFG &= ~(0x03 << 4);
    SCU->STOPCFG |= (0x01 << 4);//MLDO12Ϊ1.0V
    SCU->STOPCFG |= 1 << 9;//STOP Զ LPSTP ģʽ
    SCU->STOPCFG |= 1 << 3;//ֹͣSTOPģʽ£RC64M Զر

    /* All Clock Disable */
    SCU->CLKOCR &= ~(1ul << 31);    // Buzzer2 Disable
    SCU->CLKOCR &= ~(1ul << 23);    // Buzzer1 Disable

    /*RAM Retention ģʽ*/	
	SCU->STOPCFG |=(1<<28);
	
	/*رSRAMδÿռ*/
	//SCU->MEMCFG  |= (14<<16);    //1110 رδõĺ24K
	
    /*Eflash sleepģʽ */
    EFC->CTRL |= 1<<12;
	
    SET_BIT(SCB->SCR, ((uint32_t)SCB_SCR_SLEEPDEEP_Msk));   // Set SLEEPDEEP bit of Cortex System Control Register 
    
    SCU->STOPCFG &= (~BIT11);  // PDDS=0     
    

	/*---------------stopģʽ-----------*/
	/* Wait For Interrupt */   
    __WFI();
	
	/*---------------Ѻ-------------*/
	CLEAR_BIT(SCB->SCR, ((uint32_t)SCB_SCR_SLEEPDEEP_Msk)); 
    
    SCU->STOPCFG &= ~(0x03 << 4);//MLDO12Ϊ1.2V
	 	 
	/* ѺEflash˳Sleepģʽ */
	EFC->CTRL &= ~(1<<12);
    /* Elash˳Sleepʱ10uS */
	SimpleDelay(5000); 

    /* ʹSystickж */
    SysTick->CTRL |= SysTick_CTRL_TICKINT_Msk; 
    /* ʹȫж */    
    __set_PRIMASK(0);
	
}


/*********************************************************************************
* Function    : APP_Power_Stop_Test
* Description : 
* Input       : None
* Output      : None
**********************************************************************************/
void APP_Power_Stop_Test(void)
{
    while(1)
    {
        GPIO_Turn();   //GPIOת൱ʱ
        printfS("MCU enter stop mode, MCU will wakeup by PB9 falling edge!\n");            
        Enter_LowPower_STOP();
        System_Init(); 
        
        extern void Uart_Init(uint32_t fu32_Baudrate);
        Uart_Init(115200);
        
        printfS("MCU exit stop mode, wakeup by PB9 falling edge!\n");
    }
}
